/*
 * Decompiled with CFR 0.152.
 */
package efclient.bin.si.net.sid.io;

import efclient.bin.si.net.sid.net.Connection;
import efclient.bin.si.net.sid.net.ConnectionData;
import efclient.bin.si.net.sid.net.ConnectionEvent;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;

public class SiIO {
    private Connection m_Connection;
    private ConnectionData m_ConnectionData;
    private DataOutputStream m_Out;
    private DataInputStream m_In;
    private IACHandler m_IACHandler;
    private InetAddress m_LocalAddress;
    private boolean m_NOIAC = false;
    private boolean m_Initializing;
    private boolean m_CRFlag;
    protected static final int IAC = 255;
    protected static final int GA = 249;
    protected static final int WILL = 251;
    protected static final int WONT = 252;
    protected static final int DO = 253;
    protected static final int DONT = 254;
    protected static final int SB = 250;
    protected static final int SE = 240;
    protected static final int NOP = 241;
    protected static final int DM = 242;
    protected static final int BRK = 243;
    protected static final int IP = 244;
    protected static final int AO = 245;
    protected static final int AYT = 246;
    protected static final int EC = 247;
    protected static final int EL = 248;
    protected static final int ECHO = 1;
    protected static final int SUPGA = 3;
    protected static final int NAWS = 31;
    protected static final int TTYPE = 24;
    protected static final int IS = 0;
    protected static final int SEND = 1;
    protected static final int LOGOUT = 18;
    protected static final int LINEMODE = 34;
    protected static final int LM_MODE = 1;
    protected static final int LM_EDIT = 1;
    protected static final int LM_TRAPSIG = 2;
    protected static final int LM_MODEACK = 4;
    protected static final int LM_FORWARDMASK = 2;
    protected static final int LM_SLC = 3;
    protected static final int LM_SLC_NOSUPPORT = 0;
    protected static final int LM_SLC_DEFAULT = 3;
    protected static final int LM_SLC_VALUE = 2;
    protected static final int LM_SLC_CANTCHANGE = 1;
    protected static final int LM_SLC_LEVELBITS = 3;
    protected static final int LM_SLC_ACK = 128;
    protected static final int LM_SLC_FLUSHIN = 64;
    protected static final int LM_SLC_FLUSHOUT = 32;
    protected static final int LM_SLC_SYNCH = 1;
    protected static final int LM_SLC_BRK = 2;
    protected static final int LM_SLC_IP = 3;
    protected static final int LM_SLC_AO = 4;
    protected static final int LM_SLC_AYT = 5;
    protected static final int LM_SLC_EOR = 6;
    protected static final int LM_SLC_ABORT = 7;
    protected static final int LM_SLC_EOF = 8;
    protected static final int LM_SLC_SUSP = 9;
    protected static final int NEWENV = 39;
    protected static final int NE_INFO = 2;
    protected static final int NE_VAR = 0;
    protected static final int NE_VALUE = 1;
    protected static final int NE_ESC = 2;
    protected static final int NE_USERVAR = 3;
    protected static final int NE_VAR_OK = 2;
    protected static final int NE_VAR_DEFINED = 1;
    protected static final int NE_VAR_DEFINED_EMPTY = 0;
    protected static final int NE_VAR_UNDEFINED = -1;
    protected static final int NE_IN_ERROR = -2;
    protected static final int NE_IN_END = -3;
    protected static final int NE_VAR_NAME_MAXLENGTH = 50;
    protected static final int NE_VAR_VALUE_MAXLENGTH = 1000;
    protected static final int EXT_ASCII = 17;
    protected static final int SEND_LOC = 23;
    protected static final int AUTHENTICATION = 37;
    protected static final int ENCRYPT = 38;
    private static final int SMALLEST_BELIEVABLE_WIDTH = 20;
    private static final int SMALLEST_BELIEVABLE_HEIGHT = 6;
    private static final int DEFAULT_WIDTH = 80;
    private static final int DEFAULT_HEIGHT = 25;

    public void closeInput() {
        try {
            this.m_In.close();
        }
        catch (IOException iOException) {}
    }

    public void closeOutput() {
        try {
            this.write(255);
            this.write(253);
            this.write(18);
            this.m_Out.close();
        }
        catch (IOException iOException) {}
    }

    public void flush() throws IOException {
        this.m_Out.flush();
    }

    private void IamHere() {
        try {
            this.write("[" + this.m_LocalAddress.toString() + ":Yes]");
            this.flush();
        }
        catch (Exception exception) {}
    }

    public void initIO() throws IOException {
        this.m_IACHandler = new IACHandler(this);
        this.m_In = new DataInputStream(this.m_ConnectionData.getSocket().getInputStream());
        this.m_Out = new DataOutputStream(new BufferedOutputStream(this.m_ConnectionData.getSocket().getOutputStream()));
        this.m_LocalAddress = this.m_ConnectionData.getSocket().getLocalAddress();
        this.m_CRFlag = false;
        this.initSiCommunication();
    }

    private void initSiCommunication() {
        this.m_Initializing = true;
        try {
            try {
                if (this.m_ConnectionData.isLineMode()) {
                    this.m_IACHandler.doLineModeInit();
                } else {
                    this.m_IACHandler.doCharacterModeInit();
                }
                this.m_ConnectionData.getSocket().setSoTimeout(1000);
                this.read();
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            try {
                this.m_ConnectionData.getSocket().setSoTimeout(0);
            }
            catch (Exception exception) {}
            throw throwable;
        }
        Object var1_3 = null;
        try {
            this.m_ConnectionData.getSocket().setSoTimeout(0);
        }
        catch (Exception exception) {}
        this.m_Initializing = false;
    }

    private void nvtBreak() {
        this.m_Connection.processConnectionEvent(new ConnectionEvent(this.m_Connection, 104));
    }

    private int rawread() throws IOException {
        int n = 0;
        n = this.m_In.readUnsignedByte();
        this.m_ConnectionData.activity();
        return n;
    }

    private void rawWrite(int n) throws IOException {
        this.m_Out.write(n);
    }

    public int read() throws IOException {
        int n = this.rawread();
        this.m_NOIAC = false;
        while (n == 255 && !this.m_NOIAC) {
            n = this.rawread();
            if (n != 255) {
                this.m_IACHandler.handleC(n);
                n = this.rawread();
                continue;
            }
            this.m_NOIAC = true;
        }
        return this.stripCRSeq(n);
    }

    private int read16int() throws IOException {
        int n = this.m_In.readUnsignedShort();
        return n;
    }

    public void setConnection(Connection connection) {
        this.m_Connection = connection;
        this.m_ConnectionData = this.m_Connection.getConnectionData();
    }

    public void setEcho(boolean bl) {
    }

    private void setTerminalGeometry(int n, int n2) {
        if (n < 20) {
            n = 80;
        }
        if (n2 < 6) {
            n2 = 25;
        }
        this.m_ConnectionData.setTerminalGeometry(n, n2);
    }

    private int stripCRSeq(int n) throws IOException {
        if (n == 13) {
            this.rawread();
            return 10;
        }
        return n;
    }

    public void write(byte by) throws IOException {
        if (!this.m_CRFlag && by == 10) {
            this.m_Out.write(13);
        }
        if (this.m_CRFlag && by != 10) {
            this.m_Out.write(10);
        }
        this.m_Out.write(by);
        this.m_CRFlag = by == 13;
    }

    public void write(char c) throws IOException {
        this.write((byte)c);
    }

    public void write(int n) throws IOException {
        this.write((byte)n);
    }

    public void write(String string) throws IOException {
        this.write(string.getBytes());
    }

    public void write(byte[] byArray) throws IOException {
        int n = 0;
        while (n < byArray.length) {
            this.write(byArray[n]);
            ++n;
        }
    }

    public void write(int[] nArray) throws IOException {
        int n = 0;
        while (n < nArray.length) {
            this.write((byte)nArray[n]);
            ++n;
        }
    }

    static ConnectionData access$m_ConnectionData(SiIO siIO) {
        return siIO.m_ConnectionData;
    }

    static void access$rawWrite(SiIO siIO, int n) throws IOException {
        siIO.rawWrite(n);
    }

    static void access$nvtBreak(SiIO siIO) {
        siIO.nvtBreak();
    }

    static int access$rawread(SiIO siIO) throws IOException {
        return siIO.rawread();
    }

    static void access$IamHere(SiIO siIO) {
        siIO.IamHere();
    }

    static void access$setTerminalGeometry(SiIO siIO, int n, int n2) {
        siIO.setTerminalGeometry(n, n2);
    }

    static int access$read16int(SiIO siIO) throws IOException {
        return siIO.read16int();
    }

    class IACHandler {
        /* synthetic */ SiIO this$0;
        private int[] buffer = new int[2];
        private boolean DO_ECHO = false;
        private boolean DO_SUPGA = false;
        private boolean DO_NAWS = false;
        private boolean DO_TTYPE = false;
        private boolean DO_LINEMODE = false;
        private boolean DO_NEWENV = false;
        private boolean WAIT_DO_REPLY_SUPGA = false;
        private boolean WAIT_DO_REPLY_ECHO = false;
        private boolean WAIT_DO_REPLY_NAWS = false;
        private boolean WAIT_DO_REPLY_TTYPE = false;
        private boolean WAIT_DO_REPLY_LINEMODE = false;
        private boolean WAIT_LM_MODE_ACK = false;
        private boolean WAIT_LM_DO_REPLY_FORWARDMASK = false;
        private boolean WAIT_DO_REPLY_NEWENV = false;
        private boolean WAIT_NE_SEND_REPLY = false;
        private boolean WAIT_WILL_REPLY_SUPGA = false;
        private boolean WAIT_WILL_REPLY_ECHO = false;
        private boolean WAIT_WILL_REPLY_NAWS = false;
        private boolean WAIT_WILL_REPLY_TTYPE = false;

        public void doCharacterModeInit() throws IOException {
            this.sendCommand(251, 1, true);
            this.sendCommand(254, 1, true);
            this.sendCommand(253, 31, true);
            this.sendCommand(251, 3, true);
            this.sendCommand(253, 3, true);
            this.sendCommand(253, 24, true);
            this.sendCommand(253, 39, true);
        }

        public void doLineModeInit() throws IOException {
            this.sendCommand(253, 31, true);
            this.sendCommand(251, 3, true);
            this.sendCommand(253, 3, true);
            this.sendCommand(253, 24, true);
            this.sendCommand(253, 34, true);
            this.sendCommand(253, 39, true);
        }

        public void handleC(int n) throws IOException {
            this.buffer[0] = n;
            if (!this.parseTWO(this.buffer)) {
                this.buffer[1] = SiIO.access$rawread(this.this$0);
                this.parse(this.buffer);
            }
            this.buffer[0] = 0;
            this.buffer[1] = 0;
        }

        private boolean parseTWO(int[] nArray) {
            switch (nArray[0]) {
                case 255: {
                    break;
                }
                case 246: {
                    SiIO.access$IamHere(this.this$0);
                    break;
                }
                case 241: 
                case 244: 
                case 245: 
                case 247: 
                case 248: {
                    break;
                }
                case 243: {
                    SiIO.access$nvtBreak(this.this$0);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        private void parse(int[] nArray) throws IOException {
            block0 : switch (nArray[0]) {
                case 251: {
                    if (this.supported(nArray[1]) && this.isEnabled(nArray[1])) break;
                    if (this.waitDOreply(nArray[1]) && this.supported(nArray[1])) {
                        this.enable(nArray[1]);
                        this.setWait(253, nArray[1], false);
                        break;
                    }
                    if (this.supported(nArray[1])) {
                        this.sendCommand(253, nArray[1], false);
                        this.enable(nArray[1]);
                        break;
                    }
                    this.sendCommand(254, nArray[1], false);
                    break;
                }
                case 252: {
                    if (this.waitDOreply(nArray[1]) && this.supported(nArray[1])) {
                        this.setWait(253, nArray[1], false);
                        break;
                    }
                    if (!this.supported(nArray[1]) || !this.isEnabled(nArray[1])) break;
                    this.enable(nArray[1]);
                    break;
                }
                case 253: {
                    if (this.supported(nArray[1]) && this.isEnabled(nArray[1])) break;
                    if (this.waitWILLreply(nArray[1]) && this.supported(nArray[1])) {
                        this.enable(nArray[1]);
                        this.setWait(251, nArray[1], false);
                        break;
                    }
                    if (this.supported(nArray[1])) {
                        this.sendCommand(251, nArray[1], false);
                        this.enable(nArray[1]);
                        break;
                    }
                    this.sendCommand(252, nArray[1], false);
                    break;
                }
                case 254: {
                    if (this.waitWILLreply(nArray[1]) && this.supported(nArray[1])) {
                        this.setWait(251, nArray[1], false);
                        break;
                    }
                    if (!this.supported(nArray[1]) || !this.isEnabled(nArray[1])) break;
                    this.enable(nArray[1]);
                    break;
                }
                case 242: {
                    break;
                }
                case 250: {
                    if (!this.supported(nArray[1]) || !this.isEnabled(nArray[1])) break;
                    switch (nArray[1]) {
                        case 31: {
                            this.handleNAWS();
                            break block0;
                        }
                        case 24: {
                            this.handleTTYPE();
                            break block0;
                        }
                        case 34: {
                            this.handleLINEMODE();
                            break block0;
                        }
                        case 39: {
                            this.handleNEWENV();
                            break block0;
                        }
                    }
                    break;
                }
            }
        }

        private void handleNAWS() throws IOException {
            int n;
            int n2 = SiIO.access$read16int(this.this$0);
            if (n2 == 255) {
                n2 = SiIO.access$read16int(this.this$0);
            }
            if ((n = SiIO.access$read16int(this.this$0)) == 255) {
                n = SiIO.access$read16int(this.this$0);
            }
            this.skipToSE();
            SiIO.access$setTerminalGeometry(this.this$0, n2, n);
        }

        private void handleTTYPE() throws IOException {
            String string = "";
            int n = SiIO.access$rawread(this.this$0);
            string = this.readIACSETerminatedString(40);
            SiIO.access$m_ConnectionData(this.this$0).setNegotiatedTerminalType(string);
        }

        public void handleLINEMODE() throws IOException {
            int n = SiIO.access$rawread(this.this$0);
            switch (n) {
                case 1: {
                    this.handleLMMode();
                    break;
                }
                case 3: {
                    this.handleLMSLC();
                    break;
                }
                case 251: 
                case 252: {
                    this.handleLMForwardMask(n);
                    break;
                }
                default: {
                    this.skipToSE();
                }
            }
        }

        public void handleLMMode() throws IOException {
            if (this.WAIT_LM_MODE_ACK) {
                int n = SiIO.access$rawread(this.this$0);
                this.WAIT_LM_MODE_ACK = false;
            }
            this.skipToSE();
        }

        public void handleLMSLC() throws IOException {
            int[] nArray = new int[3];
            if (!this.readTriple(nArray)) {
                return;
            }
            if (nArray[0] == 0 && nArray[1] == 3 && nArray[2] == 0) {
                this.skipToSE();
                SiIO.access$rawWrite(this.this$0, 255);
                SiIO.access$rawWrite(this.this$0, 250);
                SiIO.access$rawWrite(this.this$0, 34);
                SiIO.access$rawWrite(this.this$0, 3);
                int n = 1;
                while (n < 12) {
                    SiIO.access$rawWrite(this.this$0, n);
                    SiIO.access$rawWrite(this.this$0, 3);
                    SiIO.access$rawWrite(this.this$0, 0);
                    ++n;
                }
                SiIO.access$rawWrite(this.this$0, 255);
                SiIO.access$rawWrite(this.this$0, 240);
                this.this$0.flush();
            } else {
                SiIO.access$rawWrite(this.this$0, 255);
                SiIO.access$rawWrite(this.this$0, 250);
                SiIO.access$rawWrite(this.this$0, 34);
                SiIO.access$rawWrite(this.this$0, 3);
                SiIO.access$rawWrite(this.this$0, nArray[0]);
                SiIO.access$rawWrite(this.this$0, nArray[1] | 0x80);
                SiIO.access$rawWrite(this.this$0, nArray[2]);
                while (this.readTriple(nArray)) {
                    SiIO.access$rawWrite(this.this$0, nArray[0]);
                    SiIO.access$rawWrite(this.this$0, nArray[1] | 0x80);
                    SiIO.access$rawWrite(this.this$0, nArray[2]);
                }
                SiIO.access$rawWrite(this.this$0, 255);
                SiIO.access$rawWrite(this.this$0, 240);
                this.this$0.flush();
            }
        }

        public void handleLMForwardMask(int n) throws IOException {
            switch (n) {
                case 252: {
                    if (!this.WAIT_LM_DO_REPLY_FORWARDMASK) break;
                    this.WAIT_LM_DO_REPLY_FORWARDMASK = false;
                }
            }
            this.skipToSE();
        }

        public void handleNEWENV() throws IOException {
            int n = SiIO.access$rawread(this.this$0);
            switch (n) {
                case 0: {
                    this.handleNEIs();
                    break;
                }
                case 2: {
                    this.handleNEInfo();
                    break;
                }
                default: {
                    this.skipToSE();
                }
            }
        }

        private int readNEVariableName(StringBuffer stringBuffer) throws IOException {
            int n = -1;
            while ((n = SiIO.access$rawread(this.this$0)) != -1) {
                if (n == 255) {
                    n = SiIO.access$rawread(this.this$0);
                    if (n == 255) {
                        stringBuffer.append((char)n);
                        continue;
                    }
                    if (n == 240) {
                        return -3;
                    }
                    return -2;
                }
                if (n == 2) {
                    n = SiIO.access$rawread(this.this$0);
                    if (n == 2 || n == 0 || n == 3 || n == 1) {
                        stringBuffer.append((char)n);
                        continue;
                    }
                    return -2;
                }
                if (n == 0 || n == 3) {
                    return -1;
                }
                if (n == 1) {
                    return 1;
                }
                if (stringBuffer.length() >= 50) {
                    return -2;
                }
                stringBuffer.append((char)n);
            }
            return -2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int readNEVariableValue(StringBuffer stringBuffer) throws IOException {
            int n = SiIO.access$rawread(this.this$0);
            if (n == -1) {
                return -2;
            }
            if (n == 255) {
                n = SiIO.access$rawread(this.this$0);
                if (n == 255) {
                    return 0;
                }
                if (n != 240) return -2;
                return -3;
            }
            if (n == 0 || n == 3) {
                return 0;
            }
            if (n == 2) {
                n = SiIO.access$rawread(this.this$0);
                if (n != 2 && n != 0 && n != 3 && n != 1) return -2;
                stringBuffer.append((char)n);
            } else {
                stringBuffer.append((char)n);
            }
            while ((n = SiIO.access$rawread(this.this$0)) != -1) {
                if (n == 255) {
                    n = SiIO.access$rawread(this.this$0);
                    if (n == 255) {
                        stringBuffer.append((char)n);
                        continue;
                    }
                    if (n != 240) return -2;
                    return -3;
                }
                if (n == 2) {
                    n = SiIO.access$rawread(this.this$0);
                    if (n != 2 && n != 0 && n != 3 && n != 1) return -2;
                    stringBuffer.append((char)n);
                    continue;
                }
                if (n == 0 || n == 3) {
                    return 2;
                }
                if (stringBuffer.length() > 1000) {
                    return -2;
                }
                stringBuffer.append((char)n);
            }
            return -2;
        }

        public void readNEVariables() throws IOException {
            StringBuffer stringBuffer = new StringBuffer(50);
            int n = SiIO.access$rawread(this.this$0);
            if (n == 255) {
                this.skipToSE();
                return;
            }
            boolean bl = true;
            if (n == 0 || n == 3) {
                do {
                    switch (this.readNEVariableName(stringBuffer)) {
                        case -2: {
                            return;
                        }
                        case -3: {
                            return;
                        }
                        case 1: {
                            String string = stringBuffer.toString();
                            stringBuffer = new StringBuffer(50);
                            switch (this.readNEVariableValue(stringBuffer)) {
                                case -2: {
                                    return;
                                }
                                case -3: {
                                    return;
                                }
                                case 0: {
                                    break;
                                }
                                case 2: {
                                    SiIO.access$m_ConnectionData(this.this$0).getEnvironment().addElement(string);
                                    stringBuffer = new StringBuffer(50);
                                }
                            }
                        }
                    }
                } while (bl);
            }
        }

        public void handleNEIs() throws IOException {
            if (this.isEnabled(39)) {
                this.readNEVariables();
            }
        }

        public void handleNEInfo() throws IOException {
            if (this.isEnabled(39)) {
                this.readNEVariables();
            }
        }

        public void getTTYPE() throws IOException {
            if (this.isEnabled(24)) {
                SiIO.access$rawWrite(this.this$0, 255);
                SiIO.access$rawWrite(this.this$0, 250);
                SiIO.access$rawWrite(this.this$0, 24);
                SiIO.access$rawWrite(this.this$0, 1);
                SiIO.access$rawWrite(this.this$0, 255);
                SiIO.access$rawWrite(this.this$0, 240);
                this.this$0.flush();
            }
        }

        public void negotiateLineMode() throws IOException {
            if (this.isEnabled(34)) {
                SiIO.access$rawWrite(this.this$0, 255);
                SiIO.access$rawWrite(this.this$0, 250);
                SiIO.access$rawWrite(this.this$0, 34);
                SiIO.access$rawWrite(this.this$0, 1);
                SiIO.access$rawWrite(this.this$0, 3);
                SiIO.access$rawWrite(this.this$0, 255);
                SiIO.access$rawWrite(this.this$0, 240);
                this.WAIT_LM_MODE_ACK = true;
                SiIO.access$rawWrite(this.this$0, 255);
                SiIO.access$rawWrite(this.this$0, 250);
                SiIO.access$rawWrite(this.this$0, 34);
                SiIO.access$rawWrite(this.this$0, 254);
                SiIO.access$rawWrite(this.this$0, 2);
                SiIO.access$rawWrite(this.this$0, 255);
                SiIO.access$rawWrite(this.this$0, 240);
                this.WAIT_LM_DO_REPLY_FORWARDMASK = true;
                this.this$0.flush();
            }
        }

        private void negotiateEnvironment() throws IOException {
            if (this.isEnabled(39)) {
                SiIO.access$rawWrite(this.this$0, 255);
                SiIO.access$rawWrite(this.this$0, 250);
                SiIO.access$rawWrite(this.this$0, 39);
                SiIO.access$rawWrite(this.this$0, 1);
                SiIO.access$rawWrite(this.this$0, 0);
                SiIO.access$rawWrite(this.this$0, 3);
                SiIO.access$rawWrite(this.this$0, 255);
                SiIO.access$rawWrite(this.this$0, 240);
                this.WAIT_NE_SEND_REPLY = true;
                this.this$0.flush();
            }
        }

        private void skipToSE() throws IOException {
            while (SiIO.access$rawread(this.this$0) != 240) {
            }
        }

        private boolean readTriple(int[] nArray) throws IOException {
            nArray[0] = SiIO.access$rawread(this.this$0);
            nArray[1] = SiIO.access$rawread(this.this$0);
            if (nArray[0] == 255 && nArray[1] == 240) {
                return false;
            }
            nArray[2] = SiIO.access$rawread(this.this$0);
            return true;
        }

        private String readIACSETerminatedString(int n) throws IOException {
            int n2 = 0;
            char[] cArray = new char[n];
            int n3 = 32;
            boolean bl = true;
            do {
                int n4 = SiIO.access$rawread(this.this$0);
                switch (n4) {
                    case 255: {
                        n4 = SiIO.access$rawread(this.this$0);
                        if (n4 != 240) break;
                        bl = false;
                        break;
                    }
                    case -1: {
                        return new String("default");
                    }
                }
                if (!bl) continue;
                n3 = (char)n4;
                if (n3 == 10 || n3 == 13 || n2 == n) {
                    bl = false;
                    continue;
                }
                cArray[n2++] = n3;
            } while (bl);
            return new String(cArray, 0, n2);
        }

        private boolean supported(int n) {
            switch (n) {
                case 1: 
                case 3: 
                case 24: 
                case 31: 
                case 39: {
                    return true;
                }
                case 34: {
                    return SiIO.access$m_ConnectionData(this.this$0).isLineMode();
                }
            }
            return false;
        }

        private void sendCommand(int n, int n2, boolean bl) throws IOException {
            SiIO.access$rawWrite(this.this$0, 255);
            SiIO.access$rawWrite(this.this$0, n);
            SiIO.access$rawWrite(this.this$0, n2);
            if (n == 253 && bl) {
                this.setWait(253, n2, true);
            }
            if (n == 251 && bl) {
                this.setWait(251, n2, true);
            }
            this.this$0.flush();
        }

        private void enable(int n) throws IOException {
            switch (n) {
                case 3: {
                    if (this.DO_SUPGA) {
                        this.DO_SUPGA = false;
                        break;
                    }
                    this.DO_SUPGA = true;
                    break;
                }
                case 1: {
                    if (this.DO_ECHO) {
                        this.DO_ECHO = false;
                        break;
                    }
                    this.DO_ECHO = true;
                    break;
                }
                case 31: {
                    if (this.DO_NAWS) {
                        this.DO_NAWS = false;
                        break;
                    }
                    this.DO_NAWS = true;
                    break;
                }
                case 24: {
                    if (this.DO_TTYPE) {
                        this.DO_TTYPE = false;
                        break;
                    }
                    this.DO_TTYPE = true;
                    this.getTTYPE();
                    break;
                }
                case 34: {
                    if (this.DO_LINEMODE) {
                        this.DO_LINEMODE = false;
                        SiIO.access$m_ConnectionData(this.this$0).setLineMode(false);
                        break;
                    }
                    this.DO_LINEMODE = true;
                    this.negotiateLineMode();
                    break;
                }
                case 39: {
                    if (this.DO_NEWENV) {
                        this.DO_NEWENV = false;
                        break;
                    }
                    this.DO_NEWENV = true;
                    this.negotiateEnvironment();
                }
            }
        }

        private boolean isEnabled(int n) {
            switch (n) {
                case 3: {
                    return this.DO_SUPGA;
                }
                case 1: {
                    return this.DO_ECHO;
                }
                case 31: {
                    return this.DO_NAWS;
                }
                case 24: {
                    return this.DO_TTYPE;
                }
                case 34: {
                    return this.DO_LINEMODE;
                }
                case 39: {
                    return this.DO_NEWENV;
                }
            }
            return false;
        }

        private boolean waitWILLreply(int n) {
            switch (n) {
                case 3: {
                    return this.WAIT_WILL_REPLY_SUPGA;
                }
                case 1: {
                    return this.WAIT_WILL_REPLY_ECHO;
                }
                case 31: {
                    return this.WAIT_WILL_REPLY_NAWS;
                }
                case 24: {
                    return this.WAIT_WILL_REPLY_TTYPE;
                }
            }
            return false;
        }

        private boolean waitDOreply(int n) {
            switch (n) {
                case 3: {
                    return this.WAIT_DO_REPLY_SUPGA;
                }
                case 1: {
                    return this.WAIT_DO_REPLY_ECHO;
                }
                case 31: {
                    return this.WAIT_DO_REPLY_NAWS;
                }
                case 24: {
                    return this.WAIT_DO_REPLY_TTYPE;
                }
                case 34: {
                    return this.WAIT_DO_REPLY_LINEMODE;
                }
                case 39: {
                    return this.WAIT_DO_REPLY_NEWENV;
                }
            }
            return false;
        }

        private void setWait(int n, int n2, boolean bl) {
            block0 : switch (n) {
                case 253: {
                    switch (n2) {
                        case 3: {
                            this.WAIT_DO_REPLY_SUPGA = bl;
                            break;
                        }
                        case 1: {
                            this.WAIT_DO_REPLY_ECHO = bl;
                            break;
                        }
                        case 31: {
                            this.WAIT_DO_REPLY_NAWS = bl;
                            break;
                        }
                        case 24: {
                            this.WAIT_DO_REPLY_TTYPE = bl;
                            break;
                        }
                        case 34: {
                            this.WAIT_DO_REPLY_LINEMODE = bl;
                            break;
                        }
                        case 39: {
                            this.WAIT_DO_REPLY_NEWENV = bl;
                        }
                    }
                    break;
                }
                case 251: {
                    switch (n2) {
                        case 3: {
                            this.WAIT_WILL_REPLY_SUPGA = bl;
                            break block0;
                        }
                        case 1: {
                            this.WAIT_WILL_REPLY_ECHO = bl;
                            break block0;
                        }
                        case 31: {
                            this.WAIT_WILL_REPLY_NAWS = bl;
                            break block0;
                        }
                        case 24: {
                            this.WAIT_WILL_REPLY_TTYPE = bl;
                        }
                    }
                }
            }
        }

        IACHandler(SiIO siIO) {
            this.this$0 = siIO;
        }
    }
}

