/*
 * Decompiled with CFR 0.152.
 */
package efclient.bin.si.net.sid.io;

import efclient.bin.si.net.sid.io.BasicTerminalIO;
import efclient.bin.si.net.sid.io.SiIO;
import efclient.bin.si.net.sid.io.terminal.Terminal;
import efclient.bin.si.net.sid.io.terminal.TerminalManager;
import efclient.bin.si.net.sid.net.Connection;
import efclient.bin.si.net.sid.net.ConnectionData;
import efclient.bin.si.net.sid.net.ConnectionEvent;
import java.io.IOException;

public class TerminalIO
implements BasicTerminalIO {
    public SiIO m_SiIO;
    public Connection m_Connection;
    public ConnectionData m_ConnectionData;
    public Terminal m_Terminal;
    private boolean m_AcousticSignalling;
    private boolean m_Autoflush;
    private boolean m_ForceBold;
    private boolean m_LineWrapping;
    public static final int[] HOME = new int[]{0, 0};
    public static final int IOERROR = -1;
    public static final int UP = 1001;
    public static final int DOWN = 1002;
    public static final int RIGHT = 1003;
    public static final int LEFT = 1004;
    public static final int STORECURSOR = 1051;
    public static final int RESTORECURSOR = 1052;
    public static final int EEOL = 1100;
    public static final int EBOL = 1101;
    public static final int EEL = 1103;
    public static final int EEOS = 1104;
    public static final int EBOS = 1105;
    public static final int EES = 1106;
    public static final int ESCAPE = 1200;
    public static final int BYTEMISSING = 1201;
    public static final int UNRECOGNIZED = 1202;
    public static final int ENTER = 1300;
    public static final int TABULATOR = 1301;
    public static final int DELETE = 1302;
    public static final int BACKSPACE = 1303;
    public static final int COLORINIT = 1304;
    public static final int HANDLED = 1305;
    public static final int LOGOUTREQUEST = 1306;
    public static final int LineUpdate = 475;
    public static final int CharacterUpdate = 476;
    public static final int ScreenpartUpdate = 477;
    public static final int EditBuffer = 575;
    public static final int LineEditBuffer = 576;
    public static final int BEL = 7;
    public static final int BS = 8;
    public static final int DEL = 127;
    public static final int CR = 13;
    public static final int LF = 10;
    public static final int FCOLOR = 10001;
    public static final int BCOLOR = 10002;
    public static final int STYLE = 10003;
    public static final int RESET = 10004;
    public static final int BOLD = 1;
    public static final int BOLD_OFF = 22;
    public static final int ITALIC = 3;
    public static final int ITALIC_OFF = 23;
    public static final int BLINK = 5;
    public static final int BLINK_OFF = 25;
    public static final int UNDERLINED = 4;
    public static final int UNDERLINED_OFF = 24;
    public static final int DEVICERESET = 10005;
    public static final int LINEWRAP = 10006;
    public static final int NOLINEWRAP = 10007;

    public TerminalIO(Connection connection) {
        this.m_Connection = connection;
        this.m_AcousticSignalling = true;
        this.m_Autoflush = true;
        this.m_ConnectionData = this.m_Connection.getConnectionData();
        try {
            this.m_SiIO = new SiIO();
            this.m_SiIO.setConnection(connection);
            this.m_SiIO.initIO();
        }
        catch (Exception exception) {}
        try {
            this.setDefaultTerminal();
        }
        catch (Exception exception) {
            throw new RuntimeException();
        }
    }

    public void bell() throws IOException {
        if (this.m_AcousticSignalling) {
            this.m_SiIO.write(7);
        }
        if (this.m_Autoflush) {
            this.flush();
        }
    }

    public void close() {
        try {
            this.m_SiIO.closeOutput();
        }
        catch (Exception exception) {}
        try {
            this.m_SiIO.closeInput();
        }
        catch (Exception exception) {}
    }

    public boolean defineScrollRegion(int n, int n2) throws IOException {
        if (this.m_Terminal.supportsScrolling()) {
            this.m_SiIO.write(this.m_Terminal.getScrollMarginsSequence(n, n2));
            this.flush();
            return true;
        }
        return false;
    }

    private void doErase(int n) throws IOException {
        this.m_SiIO.write(this.m_Terminal.getEraseSequence(n));
        if (this.m_Autoflush) {
            this.flush();
        }
    }

    public void eraseLine() throws IOException {
        this.doErase(1103);
    }

    public void eraseScreen() throws IOException {
        this.doErase(1106);
    }

    public void eraseToBeginOfLine() throws IOException {
        this.doErase(1101);
    }

    public void eraseToBeginOfScreen() throws IOException {
        this.doErase(1105);
    }

    public void eraseToEndOfLine() throws IOException {
        this.doErase(1100);
    }

    public void eraseToEndOfScreen() throws IOException {
        this.doErase(1104);
    }

    public void flush() throws IOException {
        this.m_SiIO.flush();
    }

    public void forceBold(boolean bl) {
        this.m_ForceBold = bl;
    }

    public int getColumns() {
        return this.m_ConnectionData.getTerminalColumns();
    }

    public int getRows() {
        return this.m_ConnectionData.getTerminalRows();
    }

    public Terminal getTerminal() {
        return this.m_Terminal;
    }

    private int handleEscapeSequence(int n) throws IOException {
        if (n == 1200) {
            int[] nArray = new int[this.m_Terminal.getAtomicSequenceLength()];
            int n2 = 0;
            while (n2 < nArray.length) {
                nArray[n2] = this.m_SiIO.read();
                ++n2;
            }
            return this.m_Terminal.translateEscapeSequence(nArray);
        }
        return 1305;
    }

    public void homeCursor() throws IOException {
        this.m_SiIO.write(this.m_Terminal.getCursorPositioningSequence(HOME));
        if (this.m_Autoflush) {
            this.flush();
        }
    }

    private void initTerminal() throws IOException {
        this.m_SiIO.write(this.m_Terminal.getInitSequence());
        this.flush();
    }

    public boolean isAutoflushing() {
        return this.m_Autoflush;
    }

    public boolean isLineWrapping() {
        return this.m_LineWrapping;
    }

    public boolean isSignalling() {
        return this.m_AcousticSignalling;
    }

    public boolean isTerminalGeometryChanged() {
        return this.m_ConnectionData.isTerminalGeometryChanged();
    }

    public void moveCursor(int n, int n2) throws IOException {
        this.m_SiIO.write(this.m_Terminal.getCursorMoveSequence(n, n2));
        if (this.m_Autoflush) {
            this.flush();
        }
    }

    public void moveDown(int n) throws IOException {
        this.moveCursor(1002, n);
    }

    public void moveLeft(int n) throws IOException {
        this.moveCursor(1004, n);
    }

    public void moveRight(int n) throws IOException {
        this.moveCursor(1003, n);
    }

    public void moveUp(int n) throws IOException {
        this.moveCursor(1001, n);
    }

    public int read() throws IOException {
        int n = this.m_SiIO.read();
        if ((n = this.m_Terminal.translateControlCharacter(n)) == 1306) {
            this.m_Connection.processConnectionEvent(new ConnectionEvent(this.m_Connection, 102));
            n = 1305;
        } else if (n > 256 && n == 1200) {
            n = this.handleEscapeSequence(n);
        }
        return n;
    }

    public void resetAttributes() throws IOException {
        if (this.m_Terminal.supportsSGR()) {
            this.m_SiIO.write(this.m_Terminal.getGRSequence(10004, 0));
        }
    }

    public void resetTerminal() throws IOException {
        this.m_SiIO.write(this.m_Terminal.getSpecialSequence(10005));
    }

    public void restoreCursor() throws IOException {
        this.m_SiIO.write(this.m_Terminal.getSpecialSequence(1052));
    }

    public void setAutoflushing(boolean bl) {
        this.m_Autoflush = bl;
    }

    public void setBackgroundColor(int n) throws IOException {
        if (this.m_Terminal.supportsSGR()) {
            this.m_SiIO.write(this.m_Terminal.getGRSequence(10002, n + 10));
            if (this.m_Autoflush) {
                this.flush();
            }
        }
    }

    public void setBlink(boolean bl) throws IOException {
        if (this.m_Terminal.supportsSGR()) {
            if (bl) {
                this.m_SiIO.write(this.m_Terminal.getGRSequence(10003, 5));
            } else {
                this.m_SiIO.write(this.m_Terminal.getGRSequence(10003, 25));
            }
            if (this.m_Autoflush) {
                this.flush();
            }
        }
    }

    public void setBold(boolean bl) throws IOException {
        if (this.m_Terminal.supportsSGR()) {
            if (bl) {
                this.m_SiIO.write(this.m_Terminal.getGRSequence(10003, 1));
            } else {
                this.m_SiIO.write(this.m_Terminal.getGRSequence(10003, 22));
            }
            if (this.m_Autoflush) {
                this.flush();
            }
        }
    }

    public void setCursor(int n, int n2) throws IOException {
        int[] nArray = new int[]{n, n2};
        this.m_SiIO.write(this.m_Terminal.getCursorPositioningSequence(nArray));
        if (this.m_Autoflush) {
            this.flush();
        }
    }

    public void setDefaultTerminal() throws IOException {
        this.setTerminal(this.m_ConnectionData.getNegotiatedTerminalType());
    }

    public void setForegroundColor(int n) throws IOException {
        if (this.m_Terminal.supportsSGR()) {
            this.m_SiIO.write(this.m_Terminal.getGRSequence(10001, n));
            if (this.m_Autoflush) {
                this.flush();
            }
        }
    }

    public void setItalic(boolean bl) throws IOException {
        if (this.m_Terminal.supportsSGR()) {
            if (bl) {
                this.m_SiIO.write(this.m_Terminal.getGRSequence(10003, 3));
            } else {
                this.m_SiIO.write(this.m_Terminal.getGRSequence(10003, 23));
            }
            if (this.m_Autoflush) {
                this.flush();
            }
        }
    }

    public void setLinewrapping(boolean bl) throws IOException {
        if (bl && !this.m_LineWrapping) {
            this.m_SiIO.write(this.m_Terminal.getSpecialSequence(10006));
            this.m_LineWrapping = true;
            return;
        }
        if (!bl && this.m_LineWrapping) {
            this.m_SiIO.write(this.m_Terminal.getSpecialSequence(10007));
            this.m_LineWrapping = false;
            return;
        }
    }

    public void setSignalling(boolean bl) {
        this.m_AcousticSignalling = bl;
    }

    public void setTerminal(String string) throws IOException {
        this.m_Terminal = TerminalManager.getReference().getTerminal(string);
        this.initTerminal();
    }

    public void setUnderlined(boolean bl) throws IOException {
        if (this.m_Terminal.supportsSGR()) {
            if (bl) {
                this.m_SiIO.write(this.m_Terminal.getGRSequence(10003, 4));
            } else {
                this.m_SiIO.write(this.m_Terminal.getGRSequence(10003, 24));
            }
            if (this.m_Autoflush) {
                this.flush();
            }
        }
    }

    public void storeCursor() throws IOException {
        this.m_SiIO.write(this.m_Terminal.getSpecialSequence(1051));
    }

    public void write(byte by) throws IOException {
        this.m_SiIO.write(by);
        if (this.m_Autoflush) {
            this.flush();
        }
    }

    public void write(char c) throws IOException {
        this.m_SiIO.write(c);
        if (this.m_Autoflush) {
            this.flush();
        }
    }

    public void write(String string) throws IOException {
        if (this.m_ForceBold) {
            this.m_SiIO.write(this.m_Terminal.formatBold(string));
        } else {
            this.m_SiIO.write(this.m_Terminal.format(string));
        }
        if (this.m_Autoflush) {
            this.flush();
        }
    }
}

