/*
 * Decompiled with CFR 0.152.
 */
package efclient.bin.si.net.sid.io.toolkit;

import efclient.bin.si.net.sid.io.toolkit.BufferOverflowException;
import java.util.Vector;

class CharBuffer {
    private Vector m_Buffer;
    private int m_Size;

    public CharBuffer(int n) {
        this.m_Buffer = new Vector(n);
        this.m_Size = n;
    }

    public void append(char c) throws BufferOverflowException {
        this.m_Buffer.addElement(new Character(c));
    }

    public void append(String string) throws BufferOverflowException {
        int n = 0;
        while (n < string.length()) {
            this.append(string.charAt(n));
            ++n;
        }
    }

    public void clear() {
        this.m_Buffer.removeAllElements();
    }

    public void ensureSpace(int n) throws BufferOverflowException {
        if (n > this.m_Size - this.m_Buffer.size()) {
            throw new BufferOverflowException();
        }
    }

    public char getCharAt(int n) throws IndexOutOfBoundsException {
        return ((Character)this.m_Buffer.elementAt(n)).charValue();
    }

    public void insertCharAt(int n, char c) throws BufferOverflowException, IndexOutOfBoundsException {
        this.m_Buffer.insertElementAt(new Character(c), n);
    }

    public void removeCharAt(int n) throws IndexOutOfBoundsException {
        this.m_Buffer.removeElementAt(n);
    }

    public void setCharAt(int n, char c) throws IndexOutOfBoundsException {
        this.m_Buffer.setElementAt(new Character(c), n);
    }

    public int size() {
        return this.m_Buffer.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.m_Buffer.size()) {
            stringBuffer.append(((Character)this.m_Buffer.elementAt(n)).charValue());
            ++n;
        }
        return stringBuffer.toString();
    }
}

