/*
 * Decompiled with CFR 0.152.
 */
package efclient.bin.si.net.sid.io.toolkit;

import efclient.bin.si.net.sid.io.BasicTerminalIO;
import efclient.bin.si.net.sid.io.toolkit.ActiveComponent;
import java.io.IOException;

public class Checkbox
extends ActiveComponent {
    private String m_Text = "";
    private boolean m_Selected = false;
    private String m_Mark;
    private String m_LeftBracket;
    private String m_RightBracket;
    public static final int SMALL_CHECKMARK = 10;
    public static final int LARGE_CHECKMARK = 11;
    public static final int SQUARED_BOXSTYLE = 1;
    public static final int ROUND_BOXSTYLE = 2;
    public static final int EDGED_BOXSTYLE = 3;
    private static final int SPACE = 32;

    public Checkbox(BasicTerminalIO basicTerminalIO, String string) {
        super(basicTerminalIO, string);
        this.setBoxStyle(1);
        this.setMarkStyle(11);
    }

    public void draw() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ");
        stringBuffer.append(this.m_LeftBracket);
        if (this.m_Selected) {
            stringBuffer.append(this.m_Mark);
        } else {
            stringBuffer.append(" ");
        }
        stringBuffer.append(this.m_RightBracket);
        stringBuffer.append(" ");
        stringBuffer.append(this.m_Text);
        if (this.m_Position != null) {
            this.m_IO.setCursor(this.m_Position.getRow(), this.m_Position.getColumn());
        }
        this.m_IO.write(stringBuffer.toString());
        this.m_IO.moveLeft(3 + this.m_Text.length());
        this.m_IO.flush();
    }

    private void drawMark() throws IOException {
        if (this.m_Position != null) {
            this.m_IO.storeCursor();
            this.m_IO.setCursor(this.m_Position.getRow(), this.m_Position.getColumn());
            this.m_IO.moveRight(2);
        }
        if (this.m_Selected) {
            this.m_IO.write(this.m_Mark);
        } else {
            this.m_IO.write(" ");
        }
        if (this.m_Position == null) {
            this.m_IO.moveLeft(1);
        } else {
            this.m_IO.restoreCursor();
        }
        this.m_IO.flush();
    }

    public boolean isSelected() {
        return this.m_Selected;
    }

    public void run() throws IOException {
        int n = 0;
        this.draw();
        this.m_IO.flush();
        do {
            n = this.m_IO.read();
            switch (n) {
                case 32: {
                    this.setSelected(!this.m_Selected);
                    break;
                }
                case 10: 
                case 1301: {
                    n = -1;
                    break;
                }
                default: {
                    this.m_IO.bell();
                }
            }
            this.m_IO.flush();
        } while (n != -1);
    }

    public void setBoxStyle(int n) {
        switch (n) {
            case 2: {
                this.m_LeftBracket = "(";
                this.m_RightBracket = ")";
                break;
            }
            case 3: {
                this.m_LeftBracket = "<";
                this.m_RightBracket = ">";
                break;
            }
            default: {
                this.m_LeftBracket = "[";
                this.m_RightBracket = "]";
            }
        }
    }

    public void setMarkStyle(int n) {
        switch (n) {
            case 10: {
                this.m_Mark = "x";
                break;
            }
            default: {
                this.m_Mark = "X";
            }
        }
    }

    public void setSelected(boolean bl) throws IOException {
        this.m_Selected = bl;
        this.drawMark();
    }

    public void setText(String string) {
        this.m_Text = string;
    }
}

