/*
 * Decompiled with CFR 0.152.
 */
package efclient.bin.si.net.sid.io.toolkit;

import efclient.bin.si.net.sid.io.BasicTerminalIO;
import efclient.bin.si.net.sid.io.toolkit.ActiveComponent;
import efclient.bin.si.net.sid.io.toolkit.BufferOverflowException;
import efclient.bin.si.net.sid.io.toolkit.Dimension;
import efclient.bin.si.net.sid.io.toolkit.Editline;
import java.io.IOException;
import java.util.Vector;

public class Editarea
extends ActiveComponent {
    private int m_ColCursor = 0;
    private int m_RowCursor = 0;
    private int m_Rows = 0;
    private boolean m_Firstrun = true;
    private int m_FirstVisibleRow = 0;
    private int m_LastCursor = 0;
    private String m_Hardwrap = "\n";
    private String m_Softwrap = " ";
    private Vector lines = new Vector();
    private Editline line;

    public Editarea(BasicTerminalIO basicTerminalIO, String string, int n, int n2) {
        super(basicTerminalIO, string);
        this.m_Rows = n2;
        this.m_Firstrun = true;
        this.m_FirstVisibleRow = 0;
        this.setDimension(new Dimension(this.m_IO.getColumns(), n));
    }

    private void activateLine(int n) {
        this.line = this.getLine(n);
    }

    private void appendLine(Editline editline) {
        this.lines.addElement(editline);
    }

    private void appendNewLine() throws IOException {
        this.appendLine(this.createLine());
        if (this.m_RowCursor == this.m_FirstVisibleRow + (this.m_Dim.getHeight() - 1)) {
            ++this.m_FirstVisibleRow;
            this.m_IO.moveUp(this.m_Dim.getHeight() - 1);
            this.m_IO.moveLeft(this.line.getCursorPosition());
            this.line.getCursorPosition();
            int n = this.m_FirstVisibleRow;
            while (n < this.m_FirstVisibleRow + this.m_Dim.getHeight()) {
                Editline editline = (Editline)this.lines.elementAt(n);
                this.m_IO.eraseToEndOfLine();
                this.m_IO.write(editline.getValue());
                this.m_IO.moveLeft(editline.size());
                this.m_IO.moveDown(1);
                ++n;
            }
            this.m_IO.moveUp(1);
        } else {
            this.m_IO.moveLeft(this.line.getCursorPosition());
            this.m_IO.moveDown(1);
        }
    }

    public void clear() throws IOException {
        this.lines.removeAllElements();
        this.m_RowCursor = 0;
        this.m_ColCursor = 0;
        this.draw();
    }

    private Editline createLine() {
        return new Editline(this.m_IO);
    }

    private void cursorDown() throws IOException {
        int n = this.line.getCursorPosition();
        ++this.m_RowCursor;
        this.activateLine(this.m_RowCursor);
        this.line.setCursorPosition(n);
        this.m_IO.moveDown(1);
        if (n > this.line.getCursorPosition()) {
            this.m_IO.moveLeft(n - this.line.getCursorPosition());
        }
    }

    private void cursorUp() throws IOException {
        int n = this.line.getCursorPosition();
        --this.m_RowCursor;
        this.activateLine(this.m_RowCursor);
        this.line.setCursorPosition(n);
        this.m_IO.moveUp(1);
        if (n > this.line.getCursorPosition()) {
            this.m_IO.moveLeft(n - this.line.getCursorPosition());
        }
    }

    private void deleteLine(int n) {
        this.lines.removeElementAt(n);
    }

    public void draw() throws IOException {
        if (this.m_Position != null) {
            this.m_IO.setCursor(this.m_Position.getRow(), this.m_Position.getColumn());
            int n = 0;
            int n2 = this.m_FirstVisibleRow;
            while (n2 < this.m_FirstVisibleRow + this.m_Dim.getHeight() && n2 < this.lines.size()) {
                this.m_IO.eraseToEndOfLine();
                Editline editline = (Editline)this.lines.elementAt(n2);
                this.m_IO.write(editline.getValue());
                this.m_IO.moveLeft(editline.size());
                this.m_IO.moveDown(1);
                ++n;
                ++n2;
            }
            n2 = this.m_FirstVisibleRow + n - this.m_RowCursor;
            if (n2 > 0) {
                this.m_IO.moveUp(n2);
            }
        }
        this.m_IO.flush();
    }

    public String getHardwrapString() {
        return this.m_Hardwrap;
    }

    private Editline getLine(int n) {
        return (Editline)this.lines.elementAt(n);
    }

    public int getSize() {
        int n = 0;
        return n;
    }

    public String getSoftwrapString() {
        return this.m_Softwrap;
    }

    public String getValue() {
        StringBuffer stringBuffer = new StringBuffer();
        Editline editline = null;
        int n = 0;
        while (n < this.lines.size()) {
            editline = this.getLine(n);
            stringBuffer.append(editline.getValue()).append(editline.isHardwrapped() ? this.m_Hardwrap : this.m_Softwrap);
            ++n;
        }
        return stringBuffer.toString();
    }

    private boolean hasLineSpace() {
        return this.lines.size() < this.m_Rows;
    }

    private void insertLine(int n, Editline editline) {
        this.lines.insertElementAt(editline, n);
    }

    private void insertNewLine() throws IOException {
        this.insertLine(this.m_RowCursor + 1, this.createLine());
        if (this.m_RowCursor == this.m_FirstVisibleRow + (this.m_Dim.getHeight() - 1)) {
            ++this.m_FirstVisibleRow;
            this.m_IO.moveUp(this.m_Dim.getHeight() - 1);
            int n = this.line.getCursorPosition();
            int n2 = this.m_FirstVisibleRow;
            while (n2 < this.m_FirstVisibleRow + this.m_Dim.getHeight()) {
                this.m_IO.moveLeft(n);
                Editline editline = (Editline)this.lines.elementAt(n2);
                n = editline.size();
                this.m_IO.eraseToEndOfLine();
                this.m_IO.write(editline.getValue());
                this.m_IO.moveDown(1);
                ++n2;
            }
            this.m_IO.moveUp(1);
        } else {
            this.m_IO.moveDown(1);
            this.m_IO.moveLeft(this.line.getCursorPosition());
            int n = 0;
            int n3 = this.m_RowCursor + 1;
            while (n3 < this.m_FirstVisibleRow + this.m_Dim.getHeight() && n3 < this.lines.size()) {
                this.m_IO.eraseToEndOfLine();
                Editline editline = (Editline)this.lines.elementAt(n3);
                this.m_IO.write(editline.getValue());
                this.m_IO.moveLeft(editline.size());
                this.m_IO.moveDown(1);
                ++n;
                ++n3;
            }
            this.m_IO.moveUp(n);
        }
    }

    private void removeLine() throws IOException {
        this.deleteLine(this.m_RowCursor);
        this.activateLine(this.m_RowCursor - 1);
        --this.m_RowCursor;
        int n = 0;
        int n2 = this.m_RowCursor + 1;
        while (n2 < this.m_FirstVisibleRow + this.m_Dim.getHeight()) {
            if (n2 < this.lines.size()) {
                this.m_IO.eraseToEndOfLine();
                Editline editline = (Editline)this.lines.elementAt(n2);
                this.m_IO.write(editline.getValue());
                this.m_IO.moveLeft(editline.size());
                this.m_IO.moveDown(1);
                ++n;
            } else {
                this.m_IO.eraseToEndOfLine();
                this.m_IO.moveDown(1);
                ++n;
            }
            ++n2;
        }
        this.m_IO.moveUp(n + 1);
        this.line.setCursorPosition(this.line.size());
        this.m_IO.moveRight(this.line.size());
    }

    public void run() throws IOException {
        boolean bl = false;
        this.m_IO.setAutoflushing(false);
        if (this.m_Firstrun) {
            this.m_Firstrun = false;
            this.line = this.createLine();
            this.appendLine(this.line);
        }
        do {
            switch (this.line.run()) {
                case 1001: {
                    if (this.m_RowCursor > 0) {
                        if (this.m_FirstVisibleRow == this.m_RowCursor) {
                            this.scrollUp();
                            break;
                        }
                        this.cursorUp();
                        break;
                    }
                    this.m_IO.bell();
                    break;
                }
                case 1002: {
                    if (this.m_RowCursor < this.lines.size() - 1) {
                        if (this.m_RowCursor == this.m_FirstVisibleRow + (this.m_Dim.getHeight() - 1)) {
                            this.scrollDown();
                            break;
                        }
                        this.cursorDown();
                        break;
                    }
                    this.m_IO.bell();
                    break;
                }
                case 10: {
                    if (this.m_RowCursor == this.m_Rows - 1) {
                        bl = true;
                        break;
                    }
                    if (!this.hasLineSpace()) {
                        this.m_IO.bell();
                        break;
                    }
                    String string = this.line.getHardwrap();
                    this.line.setHardwrapped(true);
                    if (this.m_RowCursor == this.lines.size() - 1) {
                        this.appendNewLine();
                    } else {
                        this.insertNewLine();
                    }
                    ++this.m_RowCursor;
                    this.activateLine(this.m_RowCursor);
                    try {
                        this.line.setValue(string);
                        this.line.setCursorPosition(0);
                        this.m_IO.moveLeft(this.line.size());
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 1301: {
                    bl = true;
                    break;
                }
                case 1004: {
                    if (this.m_RowCursor > 0) {
                        if (this.m_FirstVisibleRow == this.m_RowCursor) {
                            this.scrollUp();
                            this.line.setCursorPosition(this.line.size());
                            this.m_IO.moveRight(this.line.size());
                            break;
                        }
                        --this.m_RowCursor;
                        this.activateLine(this.m_RowCursor);
                        this.line.setCursorPosition(this.line.size());
                        this.m_IO.moveUp(1);
                        this.m_IO.moveRight(this.line.size());
                        break;
                    }
                    this.m_IO.bell();
                    break;
                }
                case 1003: {
                    if (this.m_RowCursor < this.lines.size() - 1) {
                        if (this.m_RowCursor == this.m_FirstVisibleRow + (this.m_Dim.getHeight() - 1)) {
                            this.line.setCursorPosition(0);
                            this.m_IO.moveLeft(this.line.size());
                            this.scrollDown();
                            break;
                        }
                        ++this.m_RowCursor;
                        this.m_IO.moveLeft(this.line.size());
                        this.activateLine(this.m_RowCursor);
                        this.line.setCursorPosition(0);
                        this.m_IO.moveDown(1);
                        break;
                    }
                    this.m_IO.bell();
                    break;
                }
                case 1303: {
                    if (this.m_RowCursor == 0 || this.line.size() != 0 || this.m_RowCursor == this.m_FirstVisibleRow) {
                        this.m_IO.bell();
                        break;
                    }
                    this.removeLine();
                    break;
                }
                default: {
                    if (!this.hasLineSpace()) {
                        this.m_IO.bell();
                        break;
                    }
                    String string = this.line.getSoftwrap();
                    this.line.setHardwrapped(false);
                    if (this.m_RowCursor == this.lines.size() - 1) {
                        this.appendNewLine();
                    } else {
                        this.insertNewLine();
                    }
                    ++this.m_RowCursor;
                    this.activateLine(this.m_RowCursor);
                    try {
                        this.line.setValue(string);
                        break;
                    }
                    catch (Exception exception) {}
                }
            }
            this.m_IO.flush();
        } while (!bl);
    }

    private void scrollDown() throws IOException {
        int n = this.line.getCursorPosition();
        ++this.m_FirstVisibleRow;
        ++this.m_RowCursor;
        this.activateLine(this.m_RowCursor);
        this.line.setCursorPosition(n);
        this.m_IO.moveUp(this.m_Dim.getHeight() - 1);
        int n2 = n;
        int n3 = this.m_FirstVisibleRow;
        while (n3 < this.m_FirstVisibleRow + this.m_Dim.getHeight()) {
            this.m_IO.moveLeft(n2);
            Editline editline = (Editline)this.lines.elementAt(n3);
            n2 = editline.size();
            this.m_IO.eraseToEndOfLine();
            this.m_IO.write(editline.getValue());
            this.m_IO.moveDown(1);
            ++n3;
        }
        this.m_IO.moveUp(1);
        if (n2 > n) {
            this.m_IO.moveLeft(n2 - n);
        } else if (n2 < n) {
            this.m_IO.moveRight(n - n2);
        }
        if (n > this.line.getCursorPosition()) {
            this.m_IO.moveLeft(n - this.line.getCursorPosition());
        }
    }

    private void scrollUp() throws IOException {
        int n = this.line.getCursorPosition();
        --this.m_FirstVisibleRow;
        --this.m_RowCursor;
        this.activateLine(this.m_RowCursor);
        this.line.setCursorPosition(n);
        int n2 = n;
        int n3 = 0;
        int n4 = this.m_FirstVisibleRow;
        while (n4 < this.m_FirstVisibleRow + this.m_Dim.getHeight() && n4 < this.lines.size()) {
            this.m_IO.moveLeft(n2);
            Editline editline = (Editline)this.lines.elementAt(n4);
            n2 = editline.size();
            this.m_IO.eraseToEndOfLine();
            this.m_IO.write(editline.getValue());
            this.m_IO.moveDown(1);
            ++n3;
            ++n4;
        }
        this.m_IO.moveUp(n3);
        if (n2 > n) {
            this.m_IO.moveLeft(n2 - n);
        } else if (n2 < n) {
            this.m_IO.moveRight(n - n2);
        }
        if (n > this.line.getCursorPosition()) {
            this.m_IO.moveLeft(n - this.line.getCursorPosition());
        }
    }

    public void setHardwrapString(String string) {
        this.m_Hardwrap = string;
    }

    public void setSoftwrapString(String string) {
        this.m_Softwrap = string;
    }

    public void setValue(String string) throws BufferOverflowException {
        this.lines.removeAllElements();
        this.m_RowCursor = 0;
        this.m_ColCursor = 0;
    }
}

