/*
 * Decompiled with CFR 0.152.
 */
package efclient.bin.si.net.sid.io.toolkit;

import efclient.bin.si.net.sid.io.BasicTerminalIO;
import efclient.bin.si.net.sid.io.toolkit.ActiveComponent;
import efclient.bin.si.net.sid.io.toolkit.BufferOverflowException;
import efclient.bin.si.net.sid.io.toolkit.CharBuffer;
import efclient.bin.si.net.sid.io.toolkit.Dimension;
import efclient.bin.si.net.sid.io.toolkit.InputFilter;
import efclient.bin.si.net.sid.io.toolkit.InputValidator;
import java.io.IOException;

public class Editfield
extends ActiveComponent {
    private InputFilter m_InputFilter = null;
    private InputValidator m_InputValidator = null;
    private Buffer m_Buffer;
    private int m_Cursor = 0;
    private boolean m_InsertMode = true;
    private int m_LastSize = 0;
    private boolean m_PasswordField = false;
    private boolean m_JustBackspace;

    public Editfield(BasicTerminalIO basicTerminalIO, String string, int n) {
        super(basicTerminalIO, string);
        this.m_Buffer = new Buffer(this, n);
        this.setDimension(new Dimension(n, 1));
        this.m_Cursor = 0;
        this.m_InsertMode = true;
    }

    public void append(char c) throws BufferOverflowException, IOException {
        this.storeSize();
        this.m_Buffer.ensureSpace(1);
        this.m_Buffer.append(c);
        ++this.m_Cursor;
        if (!this.m_PasswordField) {
            this.m_IO.write(c);
        } else {
            this.m_IO.write('.');
        }
    }

    public void append(String string) throws BufferOverflowException, IOException {
        this.storeSize();
        this.m_Buffer.ensureSpace(string.length());
        int n = 0;
        while (n < string.length()) {
            this.m_Buffer.append(string.charAt(n));
            ++this.m_Cursor;
            ++n;
        }
        if (!this.m_PasswordField) {
            this.m_IO.write(string);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < string.length()) {
                stringBuffer.append('.');
                ++n2;
            }
            this.m_IO.write(stringBuffer.toString());
        }
    }

    public void clear() throws IOException {
        this.positionCursorAtBegin();
        int n = 0;
        while (n < this.m_Buffer.size()) {
            this.m_IO.write(' ');
            ++n;
        }
        this.positionCursorAtBegin();
        this.m_Buffer.clear();
        this.m_Cursor = 0;
        this.m_LastSize = 0;
        this.m_IO.flush();
    }

    public void draw() throws IOException {
        int n;
        StringBuffer stringBuffer;
        int n2 = this.m_LastSize - this.m_Buffer.size();
        String string = this.m_Buffer.toString();
        if (this.m_PasswordField) {
            stringBuffer = new StringBuffer();
            n = 0;
            while (n < string.length()) {
                stringBuffer.append('.');
                ++n;
            }
            string = stringBuffer.toString();
        }
        if (n2 > 0) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            n = 0;
            while (n < n2) {
                stringBuffer.append(" ");
                ++n;
            }
            string = stringBuffer.toString();
        }
        if (this.m_Position != null) {
            this.m_IO.setCursor(this.m_Position.getRow(), this.m_Position.getColumn());
        } else {
            this.m_IO.moveLeft(this.m_Cursor);
        }
        this.m_IO.write(string);
        if (this.m_Cursor < string.length()) {
            this.m_IO.moveLeft(string.length() - this.m_Cursor);
        }
    }

    public char getCharAt(int n) throws IndexOutOfBoundsException {
        return this.m_Buffer.getCharAt(n);
    }

    public int getCursorPosition() {
        return this.m_Cursor;
    }

    public int getLength() {
        return this.m_Dim.getWidth();
    }

    public int getSize() {
        return this.m_Buffer.size();
    }

    public String getValue() {
        return this.m_Buffer.toString();
    }

    private void handleCharInput(int n) throws IOException {
        if (this.isCursorAtEnd()) {
            try {
                this.append((char)n);
            }
            catch (BufferOverflowException bufferOverflowException) {
                this.m_IO.bell();
            }
        } else if (this.isInInsertMode()) {
            try {
                this.insertCharAt(this.m_Cursor, (char)n);
            }
            catch (BufferOverflowException bufferOverflowException) {
                this.m_IO.bell();
            }
        } else {
            try {
                this.setCharAt(this.m_Cursor, (char)n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.m_IO.bell();
            }
        }
    }

    public void insertCharAt(int n, char c) throws BufferOverflowException, IndexOutOfBoundsException, IOException {
        this.storeSize();
        this.m_Buffer.ensureSpace(1);
        this.m_Buffer.insertCharAt(n, c);
        if (this.m_Cursor >= n) {
            this.moveRight();
        }
        this.draw();
    }

    public void insertStringAt(int n, String string) throws BufferOverflowException, IndexOutOfBoundsException, IOException {
        this.storeSize();
        this.m_Buffer.ensureSpace(string.length());
        int n2 = 0;
        while (n2 < string.length()) {
            this.m_Buffer.insertCharAt(n, string.charAt(n2));
            ++this.m_Cursor;
            ++n2;
        }
        this.draw();
    }

    private boolean isCursorAtEnd() {
        return this.m_Cursor == this.m_Buffer.size();
    }

    public boolean isInInsertMode() {
        return this.m_InsertMode;
    }

    public boolean isJustBackspace() {
        return this.m_JustBackspace;
    }

    public boolean isPasswordField() {
        return this.m_PasswordField;
    }

    private void moveLeft() throws IOException {
        if (this.m_Cursor > 0) {
            --this.m_Cursor;
            this.m_IO.moveLeft(1);
        } else {
            this.m_IO.bell();
        }
    }

    private void moveRight() throws IOException {
        if (this.m_Cursor < this.m_Buffer.size()) {
            ++this.m_Cursor;
            this.m_IO.moveRight(1);
        } else {
            this.m_IO.bell();
        }
    }

    private void positionCursorAtBegin() throws IOException {
        if (this.m_Position == null) {
            this.m_IO.moveLeft(this.m_Cursor);
        } else {
            this.m_IO.setCursor(this.m_Position.getRow(), this.m_Position.getColumn());
        }
    }

    public void registerInputFilter(InputFilter inputFilter) {
        this.m_InputFilter = inputFilter;
    }

    public void registerInputValidator(InputValidator inputValidator) {
        this.m_InputValidator = inputValidator;
    }

    public void removeCharAt(int n) throws IndexOutOfBoundsException, IOException {
        this.storeSize();
        this.m_Buffer.removeCharAt(n);
        if (this.m_Cursor > n) {
            this.moveLeft();
        }
        this.draw();
    }

    public void run() throws IOException {
        int n = 0;
        this.draw();
        this.m_IO.flush();
        block16: do {
            n = this.m_IO.read();
            if (this.m_JustBackspace && n == 1302) {
                n = 1303;
            }
            if (this.m_InputFilter != null) {
                n = this.m_InputFilter.filterInput(n);
            }
            switch (n) {
                case -1: {
                    this.m_Buffer.clear();
                    break;
                }
                case -2000: {
                    continue block16;
                }
                case -2001: {
                    this.m_IO.bell();
                    break;
                }
                case 1004: {
                    this.moveLeft();
                    break;
                }
                case 1003: {
                    this.moveRight();
                    break;
                }
                case 1001: 
                case 1002: {
                    this.m_IO.bell();
                    break;
                }
                case 10: {
                    if (this.m_InputValidator != null) {
                        if (this.m_InputValidator.validate(this.m_Buffer.toString())) {
                            n = -1;
                            break;
                        }
                        this.m_IO.bell();
                        break;
                    }
                    n = -1;
                    break;
                }
                case 1303: {
                    try {
                        this.removeCharAt(this.m_Cursor - 1);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        this.m_IO.bell();
                    }
                    break;
                }
                case 1302: {
                    try {
                        this.removeCharAt(this.m_Cursor);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        this.m_IO.bell();
                    }
                    break;
                }
                case 1301: {
                    n = -1;
                    break;
                }
                default: {
                    this.handleCharInput(n);
                }
            }
            this.m_IO.flush();
        } while (n != -1);
    }

    public void setCharAt(int n, char c) throws IndexOutOfBoundsException, IOException {
        this.m_Buffer.setCharAt(n, c);
        this.draw();
    }

    public void setInsertMode(boolean bl) {
        this.m_InsertMode = bl;
    }

    public void setJustBackspace(boolean bl) {
        this.m_JustBackspace = true;
    }

    public void setPasswordField(boolean bl) {
        this.m_PasswordField = bl;
    }

    public void setValue(String string) throws BufferOverflowException, IOException {
        this.clear();
        this.append(string);
    }

    private void storeSize() {
        this.m_LastSize = this.m_Buffer.size();
    }

    class Buffer
    extends CharBuffer {
        /* synthetic */ Editfield this$0;

        public Buffer(Editfield editfield, int n) {
            super(n);
            this.this$0 = editfield;
        }
    }
}

