/*
 * Decompiled with CFR 0.152.
 */
package efclient.bin.si.net.sid.io.toolkit;

import efclient.bin.si.net.sid.io.BasicTerminalIO;
import efclient.bin.si.net.sid.io.toolkit.BufferOverflowException;
import efclient.bin.si.net.sid.io.toolkit.CharBuffer;
import java.io.IOException;

class Editline {
    private Buffer m_Buffer;
    private BasicTerminalIO m_IO;
    private int m_Cursor = 0;
    private boolean m_InsertMode = true;
    private int m_LastSize = 0;
    private boolean m_HardWrapped = false;
    private char m_LastRead;
    private int m_LastCursPos = 0;

    public Editline(BasicTerminalIO basicTerminalIO) {
        this.m_IO = basicTerminalIO;
        this.m_Buffer = new Buffer(this, this.m_IO.getColumns() - 1);
        this.m_Cursor = 0;
        this.m_InsertMode = true;
    }

    public void append(char c) throws BufferOverflowException, IOException {
        this.storeSize();
        this.m_Buffer.ensureSpace(1);
        this.m_Buffer.append(c);
        ++this.m_Cursor;
        this.m_IO.write(c);
    }

    public void append(String string) throws BufferOverflowException, IOException {
        this.storeSize();
        this.m_Buffer.ensureSpace(string.length());
        int n = 0;
        while (n < string.length()) {
            this.m_Buffer.append(string.charAt(n));
            ++this.m_Cursor;
            ++n;
        }
        this.m_IO.write(string);
    }

    public void clear() throws IOException {
        this.storeSize();
        this.m_Buffer.clear();
        this.m_Cursor = 0;
        this.draw();
    }

    public void draw() throws IOException {
        this.m_IO.moveLeft(this.m_LastCursPos);
        this.m_IO.eraseToEndOfLine();
        this.m_IO.write(this.m_Buffer.toString());
        if (this.m_Cursor < this.m_Buffer.size()) {
            this.m_IO.moveLeft(this.m_Buffer.size() - this.m_Cursor);
        }
    }

    public int getCursorPosition() {
        return this.m_Cursor;
    }

    public String getHardwrap() throws IndexOutOfBoundsException, IOException {
        String string = this.m_Buffer.toString();
        string = string.substring(this.m_Cursor, string.length());
        int n = this.m_Buffer.size();
        int n2 = this.m_Cursor;
        while (n2 < n) {
            this.m_Buffer.removeCharAt(this.m_Cursor);
            ++n2;
        }
        this.m_IO.eraseToEndOfLine();
        return string;
    }

    private char getLastRead() {
        return this.m_LastRead;
    }

    public String getSoftwrap() throws IndexOutOfBoundsException, IOException {
        String string = this.m_Buffer.toString();
        int n = string.lastIndexOf(" ");
        if (n == -1) {
            string = "";
        } else {
            string = string.substring(n + 1, string.length());
            this.m_Cursor = this.size();
            this.m_Cursor -= string.length();
            int n2 = 0;
            while (n2 < string.length()) {
                this.m_Buffer.removeCharAt(this.m_Cursor);
                ++n2;
            }
            this.m_IO.moveLeft(string.length());
            this.m_IO.eraseToEndOfLine();
        }
        return String.valueOf(string) + this.getLastRead();
    }

    public String getValue() {
        return this.m_Buffer.toString();
    }

    private void handleCharInput(int n) throws BufferOverflowException, IOException {
        if (this.isCursorAtEnd()) {
            this.append((char)n);
        } else if (this.isInInsertMode()) {
            try {
                this.insertCharAt(this.m_Cursor, (char)n);
            }
            catch (BufferOverflowException bufferOverflowException) {
                this.m_IO.bell();
            }
        } else {
            this.setCharAt(this.m_Cursor, (char)n);
        }
    }

    private void insertCharAt(int n, char c) throws BufferOverflowException, IndexOutOfBoundsException, IOException {
        this.storeSize();
        this.m_Buffer.ensureSpace(1);
        this.m_Buffer.insertCharAt(n, c);
        if (this.m_Cursor >= n) {
            ++this.m_Cursor;
        }
        this.draw();
    }

    private void insertStringAt(int n, String string) throws BufferOverflowException, IndexOutOfBoundsException, IOException {
        this.storeSize();
        this.m_Buffer.ensureSpace(string.length());
        int n2 = 0;
        while (n2 < string.length()) {
            this.m_Buffer.insertCharAt(n, string.charAt(n2));
            ++this.m_Cursor;
            ++n2;
        }
        this.draw();
    }

    private boolean isCursorAtEnd() {
        return this.m_Cursor == this.m_Buffer.size();
    }

    public boolean isHardwrapped() {
        return this.m_HardWrapped;
    }

    public boolean isInInsertMode() {
        return this.m_InsertMode;
    }

    private boolean moveLeft() throws IOException {
        if (this.m_Cursor > 0) {
            --this.m_Cursor;
            this.m_IO.moveLeft(1);
            return true;
        }
        return false;
    }

    private boolean moveRight() throws IOException {
        if (this.m_Cursor < this.m_Buffer.size()) {
            ++this.m_Cursor;
            this.m_IO.moveRight(1);
            return true;
        }
        return false;
    }

    private void removeCharAt(int n) throws IndexOutOfBoundsException, IOException {
        this.storeSize();
        this.m_Buffer.removeCharAt(n);
        if (this.m_Cursor > n) {
            --this.m_Cursor;
        }
        this.draw();
    }

    public int run() throws IOException {
        int n = 0;
        while (true) {
            n = this.m_IO.read();
            this.m_LastCursPos = this.m_Cursor;
            switch (n) {
                case 1004: {
                    if (this.moveLeft()) break;
                    return n;
                }
                case 1003: {
                    if (this.moveRight()) break;
                    return n;
                }
                case 1303: {
                    try {
                        if (this.m_Cursor == 0) {
                            return n;
                        }
                        this.removeCharAt(this.m_Cursor - 1);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        this.m_IO.bell();
                    }
                    break;
                }
                case 1302: {
                    try {
                        this.removeCharAt(this.m_Cursor);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        this.m_IO.bell();
                    }
                    break;
                }
                case 10: 
                case 1001: 
                case 1002: 
                case 1301: {
                    return n;
                }
                default: {
                    try {
                        this.handleCharInput(n);
                        break;
                    }
                    catch (BufferOverflowException bufferOverflowException) {
                        this.setLastRead((char)n);
                        return n;
                    }
                }
            }
            this.m_IO.flush();
        }
    }

    private void setCharAt(int n, char c) throws IndexOutOfBoundsException, IOException {
        this.m_Buffer.setCharAt(n, c);
        this.draw();
    }

    public void setCursorPosition(int n) {
        this.m_Cursor = this.m_Buffer.size() < n ? this.m_Buffer.size() : n;
    }

    public void setHardwrapped(boolean bl) {
        this.m_HardWrapped = bl;
    }

    public void setInsertMode(boolean bl) {
        this.m_InsertMode = bl;
    }

    private void setLastRead(char c) {
        this.m_LastRead = c;
    }

    public void setValue(String string) throws BufferOverflowException, IOException {
        this.storeSize();
        this.m_Buffer.clear();
        this.m_Cursor = 0;
        this.m_IO.moveLeft(this.m_LastSize);
        this.m_IO.eraseToEndOfLine();
        this.append(string);
    }

    public int size() {
        return this.m_Buffer.size();
    }

    private void storeSize() {
        this.m_LastSize = this.m_Buffer.size();
    }

    class Buffer
    extends CharBuffer {
        /* synthetic */ Editline this$0;

        public Buffer(Editline editline, int n) {
            super(n);
            this.this$0 = editline;
        }
    }
}

