/*
 * Decompiled with CFR 0.152.
 */
package efclient.bin.si.net.sid.io.toolkit;

import efclient.bin.si.net.sid.io.BasicTerminalIO;
import efclient.bin.si.net.sid.io.toolkit.Statusbar;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Vector;

public class Pager {
    private BasicTerminalIO m_IO;
    private StringReader m_Source;
    private String m_Prompt;
    private int m_StopKey;
    private Vector m_Chunks;
    private int m_ChunkPos;
    private int m_LastNewChunk;
    private boolean m_EOS;
    private int m_TermRows;
    private int m_TermCols;
    private boolean m_NoPrompt;
    private boolean m_ShowPos;
    private Statusbar m_Status;
    private static final char DEFAULT_STOPKEY = 's';
    private static final String DEFAULT_PROMPT = "[Cursor Up,Cursor Down,Space,s (stop)] ";
    private static final int SPACE = 32;

    public Pager(BasicTerminalIO basicTerminalIO) {
        this.m_IO = basicTerminalIO;
        this.setPrompt(DEFAULT_PROMPT);
        this.setStopKey('s');
        this.m_TermRows = this.m_IO.getRows();
        this.m_TermCols = this.m_IO.getColumns();
        this.m_Status = new Statusbar(this.m_IO, "Pager Status");
        this.m_Status.setAlignment(2);
    }

    public Pager(BasicTerminalIO basicTerminalIO, String string, char c) {
        this.m_IO = basicTerminalIO;
        this.setPrompt(string);
        this.m_StopKey = c;
        this.m_TermRows = this.m_IO.getRows();
        this.m_TermCols = this.m_IO.getColumns();
        this.m_Status.setAlignment(2);
    }

    private void drawNewPage() throws IOException {
        ++this.m_ChunkPos;
        ++this.m_LastNewChunk;
        if (this.m_ChunkPos < this.m_Chunks.size()) {
            this.m_IO.homeCursor();
            this.m_IO.eraseScreen();
            this.m_IO.write((String)this.m_Chunks.elementAt(this.m_ChunkPos));
        } else {
            this.m_EOS = true;
            this.m_NoPrompt = true;
        }
    }

    private void drawNextPage() throws IOException {
        if (this.m_ChunkPos == this.m_LastNewChunk) {
            this.drawNewPage();
        } else {
            this.m_IO.homeCursor();
            this.m_IO.eraseScreen();
            this.m_IO.write((String)this.m_Chunks.elementAt(++this.m_ChunkPos));
        }
    }

    private void drawPreviousPage() throws IOException {
        if (this.m_ChunkPos > 0) {
            this.m_IO.homeCursor();
            this.m_IO.eraseScreen();
            this.m_IO.write((String)this.m_Chunks.elementAt(--this.m_ChunkPos));
        } else {
            this.m_IO.bell();
            this.m_NoPrompt = true;
        }
    }

    public void page(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(3060);
        int n = 0;
        while (n != -1) {
            n = inputStream.read();
            if (n == -1) continue;
            stringBuffer.append((char)n);
        }
        this.page(stringBuffer.toString());
    }

    public void page(String string) throws IOException {
        this.terminalGeometryChanged();
        boolean bl = this.m_IO.isAutoflushing();
        this.m_IO.setAutoflushing(true);
        this.m_Source = new StringReader(string);
        this.m_ChunkPos = 0;
        this.m_LastNewChunk = 0;
        this.m_EOS = false;
        this.m_NoPrompt = false;
        this.renderChunks();
        if (this.m_Chunks.size() == 1) {
            this.m_IO.write((String)this.m_Chunks.elementAt(0));
        } else {
            this.m_IO.homeCursor();
            this.m_IO.eraseScreen();
            this.m_IO.write((String)this.m_Chunks.elementAt(this.m_ChunkPos));
            this.updateStatus();
            this.m_Status.draw();
            int n = 0;
            block7: do {
                this.m_NoPrompt = false;
                n = this.m_IO.read();
                if (this.terminalGeometryChanged()) {
                    try {
                        this.m_Source.reset();
                    }
                    catch (Exception exception) {}
                    this.renderChunks();
                    this.m_ChunkPos = 0;
                    this.m_LastNewChunk = 0;
                    this.m_EOS = false;
                    this.m_NoPrompt = false;
                    this.m_IO.homeCursor();
                    this.m_IO.eraseScreen();
                    this.m_IO.write((String)this.m_Chunks.elementAt(this.m_ChunkPos));
                    this.updateStatus();
                    this.m_Status.draw();
                    continue;
                }
                switch (n) {
                    case 1001: {
                        this.drawPreviousPage();
                        break;
                    }
                    case 1002: {
                        this.drawNextPage();
                        break;
                    }
                    case 32: {
                        this.drawNextPage();
                        break;
                    }
                    default: {
                        if (n == this.m_StopKey) {
                            n = -1;
                            continue block7;
                        }
                        this.m_IO.bell();
                        continue block7;
                    }
                }
                if (this.m_EOS) {
                    n = -1;
                    continue;
                }
                if (this.m_NoPrompt) continue;
                this.updateStatus();
                this.m_Status.draw();
            } while (n != -1);
            this.m_IO.eraseToEndOfLine();
        }
        this.m_IO.write("\n");
        this.m_Source.close();
        this.m_IO.setAutoflushing(bl);
    }

    private void renderChunks() {
        this.m_Chunks = new Vector(20);
        StringBuffer stringBuffer = new StringBuffer((this.m_TermCols + 25) * 25);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        do {
            if (n3 == this.m_TermRows - 1) {
                this.m_Chunks.addElement(stringBuffer.toString());
                stringBuffer = new StringBuffer((this.m_TermCols + 25) * 25);
                n2 = 0;
                n3 = 0;
            }
            try {
                n = this.m_Source.read();
            }
            catch (IOException iOException) {
                n = -1;
            }
            if (n == -1) {
                this.m_Chunks.addElement(stringBuffer.toString());
                continue;
            }
            if (n == 1 || bl) {
                stringBuffer.append((char)n);
                if (!bl) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            if (n == 13) {
                ++n3;
                n2 = 0;
                stringBuffer.append("\n");
                try {
                    n = this.m_Source.read();
                }
                catch (IOException iOException) {
                    n = -1;
                }
                if (n == -1 || n == 10) continue;
                stringBuffer.append((char)n);
                continue;
            }
            if (n == 10) {
                ++n3;
                n2 = 0;
                stringBuffer.append("\n");
                continue;
            }
            stringBuffer.append((char)n);
            if (++n2 != this.m_TermCols) continue;
            ++n3;
            stringBuffer.append("\n");
            n2 = 0;
        } while (n != -1);
    }

    public void setPrompt(String string) {
        this.m_Prompt = string;
    }

    public void setShowPosition(boolean bl) {
        this.m_ShowPos = bl;
    }

    public void setStopKey(char c) {
        this.m_StopKey = c;
    }

    private boolean terminalGeometryChanged() {
        if (this.m_TermRows != this.m_IO.getRows() || this.m_TermCols != this.m_IO.getColumns()) {
            this.m_TermRows = this.m_IO.getRows();
            this.m_TermCols = this.m_IO.getColumns();
            return true;
        }
        return false;
    }

    private void updateStatus() {
        if (this.m_ShowPos) {
            this.m_Status.setStatusText(String.valueOf(this.m_Prompt) + " [" + (this.m_ChunkPos + 1) + "/" + this.m_Chunks.size() + "]");
        } else {
            this.m_Status.setStatusText(this.m_Prompt);
        }
    }
}

