/*
 * Decompiled with CFR 0.152.
 */
package efclient.bin.si.net.sid.io.toolkit;

import efclient.bin.si.net.sid.io.BasicTerminalIO;
import efclient.bin.si.net.sid.io.toolkit.ActiveComponent;
import java.io.IOException;
import java.util.Vector;

public class Selection
extends ActiveComponent {
    private Vector m_Options = new Vector(10, 5);
    private int m_Selected = 0;
    private int m_LastSelected = 0;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;

    public Selection(BasicTerminalIO basicTerminalIO, String string) {
        super(basicTerminalIO, string);
    }

    public void addOption(String string) {
        this.m_Options.addElement(string);
    }

    public void draw() throws IOException {
        String string = this.getOption(this.m_Selected);
        int n = this.getOption(this.m_LastSelected).length() - string.length();
        if (n > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(" ");
                ++n2;
            }
            string = stringBuffer.toString();
        }
        if (this.m_Position != null) {
            this.m_IO.setCursor(this.m_Position.getRow(), this.m_Position.getColumn());
        }
        this.m_IO.write(string);
        this.m_IO.moveLeft(string.length());
    }

    public String getOption(int n) {
        try {
            Object e = this.m_Options.elementAt(n);
            if (e != null) {
                return (String)e;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return null;
    }

    public int getSelected() {
        return this.m_Selected;
    }

    public void insertOption(String string, int n) {
        try {
            this.m_Options.insertElementAt(string, n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.addOption(string);
        }
    }

    public void removeOption(int n) {
        try {
            this.m_Options.removeElementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public void removeOption(String string) {
        int n = 0;
        while (n < this.m_Options.size()) {
            if (((String)this.m_Options.elementAt(n)).equals(string)) {
                this.removeOption(n);
                return;
            }
            ++n;
        }
    }

    public void run() throws IOException {
        int n = 0;
        this.draw();
        this.m_IO.flush();
        do {
            n = this.m_IO.read();
            switch (n) {
                case 1001: 
                case 1004: {
                    if (this.selectPrevious()) break;
                    this.m_IO.bell();
                    break;
                }
                case 1002: 
                case 1003: {
                    if (this.selectNext()) break;
                    this.m_IO.bell();
                    break;
                }
                case 10: 
                case 1301: {
                    n = -1;
                    break;
                }
                default: {
                    this.m_IO.bell();
                }
            }
            this.m_IO.flush();
        } while (n != -1);
    }

    private boolean selectNext() throws IOException {
        if (this.m_Selected < this.m_Options.size() - 1) {
            this.setSelected(this.m_Selected + 1);
            return true;
        }
        return false;
    }

    private boolean selectPrevious() throws IOException {
        if (this.m_Selected > 0) {
            this.setSelected(this.m_Selected - 1);
            return true;
        }
        return false;
    }

    public void setSelected(int n) throws IOException {
        if (n < 0 || n > this.m_Options.size()) {
            return;
        }
        this.m_LastSelected = this.m_Selected;
        this.m_Selected = n;
        this.draw();
    }
}

