/*
 * Decompiled with CFR 0.152.
 */
package efclient.bin.si.net.sid.io.toolkit;

import efclient.bin.si.net.sid.io.BasicTerminalIO;
import efclient.bin.si.net.sid.io.terminal.ColorHelper;
import efclient.bin.si.net.sid.io.toolkit.InertComponent;
import java.io.IOException;

public class Statusbar
extends InertComponent {
    private String m_Status;
    private int m_Align;
    private String m_BgColor;
    private String m_FgColor;
    public static final int ALIGN_RIGHT = 1;
    public static final int ALIGN_LEFT = 2;
    public static final int ALIGN_CENTER = 3;

    public Statusbar(BasicTerminalIO basicTerminalIO, String string) {
        super(basicTerminalIO, string);
    }

    private void appendSpaceString(StringBuffer stringBuffer, int n) {
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(" ");
            ++n2;
        }
    }

    public void draw() throws IOException {
        this.m_IO.storeCursor();
        this.m_IO.setCursor(this.m_IO.getRows(), 1);
        this.m_IO.write(this.getBar());
        this.m_IO.restoreCursor();
    }

    private String getBar() {
        String string = this.m_Status;
        int n = this.m_IO.getColumns() - 1;
        int n2 = (int)ColorHelper.getVisibleLength(this.m_Status);
        if (n2 > n) {
            string = this.m_Status.substring(0, n);
        }
        n2 = (int)ColorHelper.getVisibleLength(string);
        StringBuffer stringBuffer = new StringBuffer(n + n2);
        switch (this.m_Align) {
            case 2: {
                stringBuffer.append(string);
                this.appendSpaceString(stringBuffer, n - n2);
                break;
            }
            case 1: {
                this.appendSpaceString(stringBuffer, n - n2);
                stringBuffer.append(string);
                break;
            }
            case 3: {
                int n3 = n - n2 != 0 ? (n - n2) / 2 : 0;
                int n4 = n - n2 - n3;
                this.appendSpaceString(stringBuffer, n3);
                stringBuffer.append(string);
                this.appendSpaceString(stringBuffer, n4);
            }
        }
        if (this.m_FgColor != null && this.m_BgColor != null) {
            return ColorHelper.boldcolorizeText(stringBuffer.toString(), this.m_FgColor, this.m_BgColor);
        }
        if (this.m_FgColor != null && this.m_BgColor == null) {
            return ColorHelper.boldcolorizeText(stringBuffer.toString(), this.m_FgColor);
        }
        if (this.m_FgColor == null && this.m_BgColor != null) {
            return ColorHelper.colorizeBackground(stringBuffer.toString(), this.m_BgColor);
        }
        return stringBuffer.toString();
    }

    public String getStatusText() {
        return this.m_Status;
    }

    public void setAlignment(int n) {
        if (n < 1 || n > 3) {
            n = 2;
        } else {
            this.m_Align = n;
        }
    }

    public void setBackgroundColor(String string) {
        this.m_BgColor = string;
    }

    public void setForegroundColor(String string) {
        this.m_FgColor = string;
    }

    public void setStatusText(String string) {
        this.m_Status = string;
    }
}

