/*
 * Decompiled with CFR 0.152.
 */
package efclient.bin.si.net.sid.net;

import efclient.bin.si.net.sid.io.BasicTerminalIO;
import efclient.bin.si.net.sid.io.TerminalIO;
import efclient.bin.si.net.sid.net.ConnectionData;
import efclient.bin.si.net.sid.net.ConnectionEvent;
import efclient.bin.si.net.sid.net.ConnectionListener;
import efclient.bin.si.net.sid.shell.Shell;
import efclient.bin.si.net.sid.shell.ShellManager;
import eforward.util.Mt;
import java.util.Vector;

public class Connection {
    Mt iMt = null;
    boolean done = false;
    private static int m_Number;
    private boolean m_Dead;
    private Vector m_Listeners;
    public ConnectionData m_ConnectionData;
    public BasicTerminalIO m_TerminalIO;
    public Shell m_NextShell = null;

    public Connection(ConnectionData connectionData, Mt mt) {
        this.iMt = mt;
        this.m_ConnectionData = connectionData;
        this.m_Listeners = new Vector(3);
        this.m_TerminalIO = new TerminalIO(this);
        this.m_Dead = false;
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        this.m_Listeners.addElement(connectionListener);
    }

    public synchronized void close() {
        if (this.m_Dead) {
            return;
        }
        try {
            this.m_Dead = true;
            this.m_TerminalIO.close();
            this.m_ConnectionData.getSocket().close();
            this.m_ConnectionData.getManager().registerClosedConnection(this);
            int n = 0;
            while (n < 10 && !this.done) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
                ++n;
            }
        }
        catch (Exception exception) {}
    }

    public void end() {
        if (!this.m_Dead) {
            this.close();
        }
    }

    public ConnectionData getConnectionData() {
        return this.m_ConnectionData;
    }

    private Shell getNextShell() {
        Shell shell = this.m_NextShell;
        if (shell != null) {
            this.m_NextShell = null;
            return shell;
        }
        return null;
    }

    public BasicTerminalIO getTerminalIO() {
        return this.m_TerminalIO;
    }

    public boolean isActive() {
        return !this.m_Dead;
    }

    public void processConnectionEvent(ConnectionEvent connectionEvent) {
        int n = 0;
        while (n < this.m_Listeners.size()) {
            ConnectionListener connectionListener = (ConnectionListener)this.m_Listeners.elementAt(n);
            if (connectionEvent.isType(100)) {
                connectionListener.connectionIdle(connectionEvent);
            } else if (connectionEvent.isType(101)) {
                connectionListener.connectionTimedOut(connectionEvent);
            } else if (connectionEvent.isType(102)) {
                connectionListener.connectionLogoutRequest(connectionEvent);
            } else if (connectionEvent.isType(104)) {
                connectionListener.connectionSentBreak(connectionEvent);
            }
            ++n;
        }
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        this.m_Listeners.removeElement(connectionListener);
    }

    public void run() {
        boolean bl = false;
        try {
            try {
                Shell shell = ShellManager.getReference().getShell(this.m_ConnectionData.getLoginShell());
                shell.setMt(this.iMt);
                do {
                    shell.run(this);
                    if (this.m_Dead) {
                        bl = true;
                        break;
                    }
                    shell = this.getNextShell();
                    if (shell != null) continue;
                    bl = true;
                } while (!bl || this.m_Dead);
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            if (!this.m_Dead) {
                this.close();
            }
            throw throwable;
        }
        Object var2_5 = null;
        if (!this.m_Dead) {
            this.close();
        }
        this.done = true;
    }

    public void run(String string) {
        this.run();
    }

    public boolean setNextShell(String string) {
        this.m_NextShell = ShellManager.getReference().getShell(string);
        return this.m_NextShell != null;
    }
}

