/*
 * Decompiled with CFR 0.152.
 */
package efclient.bin.si.net.sid.net;

import efclient.bin.si.net.sid.net.ConnectionManager;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Locale;
import java.util.Vector;

public class ConnectionData {
    private ConnectionManager m_CM;
    private Socket m_Socket;
    private InetAddress m_IP;
    Vector ev = new Vector();
    private String m_HostName;
    private String m_HostAddress;
    private int m_Port;
    private Locale m_Locale;
    private long m_LastActivity;
    private boolean m_Warned;
    private String m_NegotiatedTerminalType;
    private int[] m_TerminalGeometry;
    private boolean m_TerminalGeometryChanged = true;
    private String m_LoginShell;
    private boolean m_LineMode = false;
    private String m_EchoMode = "server";

    public ConnectionData(Socket socket, ConnectionManager connectionManager) {
        this.m_Socket = socket;
        this.m_CM = connectionManager;
        this.m_IP = socket.getInetAddress();
        this.setHostName();
        this.setHostAddress();
        this.setLocale();
        this.m_Port = socket.getPort();
        this.m_TerminalGeometry = new int[2];
        this.m_TerminalGeometry[0] = 80;
        this.m_TerminalGeometry[1] = 25;
        this.m_NegotiatedTerminalType = "default";
        this.activity();
    }

    public void activity() {
        this.m_Warned = false;
        this.m_LastActivity = System.currentTimeMillis();
    }

    public Vector getEnvironment() {
        return this.ev;
    }

    public String getHostAddress() {
        return this.m_HostAddress;
    }

    public String getHostName() {
        return this.m_HostName;
    }

    public InetAddress getInetAddress() {
        return this.m_IP;
    }

    public long getLastActivity() {
        return this.m_LastActivity;
    }

    public Locale getLocale() {
        return this.m_Locale;
    }

    public String getLoginShell() {
        return this.m_LoginShell;
    }

    public ConnectionManager getManager() {
        return this.m_CM;
    }

    public String getNegotiatedTerminalType() {
        return this.m_NegotiatedTerminalType;
    }

    public int getPort() {
        return this.m_Port;
    }

    public Socket getSocket() {
        return this.m_Socket;
    }

    public int getTerminalColumns() {
        return this.m_TerminalGeometry[0];
    }

    public int[] getTerminalGeometry() {
        if (this.m_TerminalGeometryChanged) {
            this.m_TerminalGeometryChanged = false;
        }
        return this.m_TerminalGeometry;
    }

    public int getTerminalRows() {
        return this.m_TerminalGeometry[1];
    }

    public boolean isLineMode() {
        return this.m_LineMode;
    }

    public boolean isTerminalGeometryChanged() {
        return this.m_TerminalGeometryChanged;
    }

    public boolean isWarned() {
        return this.m_Warned;
    }

    private void setHostAddress() {
        this.m_HostAddress = this.m_IP.getHostAddress();
    }

    private void setHostName() {
        this.m_HostName = this.m_IP.getHostName();
    }

    public void setLineMode(boolean bl) {
        this.m_LineMode = bl;
    }

    private void setLocale() {
        String string = this.getHostName();
        try {
            string = string.substring(string.lastIndexOf(".") + 1);
            if (string.equals("at")) {
                this.m_Locale = new Locale("de", "AT");
                return;
            }
            if (string.equals("de")) {
                this.m_Locale = new Locale("de", "DE");
                return;
            }
            if (string.equals("mx")) {
                this.m_Locale = new Locale("es", "MX");
                return;
            }
            if (string.equals("es")) {
                this.m_Locale = new Locale("es", "ES");
                return;
            }
            if (string.equals("it")) {
                this.m_Locale = Locale.ITALY;
                return;
            }
            if (string.equals("fr")) {
                this.m_Locale = Locale.FRANCE;
                return;
            }
            if (string.equals("uk")) {
                this.m_Locale = new Locale("en", "GB");
                return;
            }
            if (string.equals("arpa")) {
                this.m_Locale = Locale.US;
                return;
            }
            if (string.equals("com")) {
                this.m_Locale = Locale.US;
                return;
            }
            if (string.equals("edu")) {
                this.m_Locale = Locale.US;
                return;
            }
            if (string.equals("gov")) {
                this.m_Locale = Locale.US;
                return;
            }
            if (string.equals("org")) {
                this.m_Locale = Locale.US;
                return;
            }
            if (string.equals("mil")) {
                this.m_Locale = Locale.US;
                return;
            }
            this.m_Locale = Locale.ENGLISH;
        }
        catch (Exception exception) {
            this.m_Locale = Locale.ENGLISH;
        }
    }

    public void setLoginShell(String string) {
        this.m_LoginShell = string;
    }

    public void setNegotiatedTerminalType(String string) {
        this.m_NegotiatedTerminalType = string;
    }

    public void setTerminalGeometry(int n, int n2) {
        this.m_TerminalGeometry[0] = n;
        this.m_TerminalGeometry[1] = n2;
        this.m_TerminalGeometryChanged = true;
    }

    public void setWarned(boolean bl) {
        this.m_Warned = bl;
        if (!bl) {
            this.m_LastActivity = System.currentTimeMillis();
        }
    }
}

