/*
 * Decompiled with CFR 0.152.
 */
package efclient.bin.si.net.sid.net;

import efclient.bin.si.net.sid.BootException;
import efclient.bin.si.net.sid.net.Connection;
import efclient.bin.si.net.sid.net.ConnectionData;
import efclient.bin.si.net.sid.net.ConnectionEvent;
import efclient.bin.si.net.sid.net.ConnectionFilter;
import eforward.util.Mt;
import java.io.IOException;
import java.net.Socket;
import java.util.Properties;
import java.util.Vector;

public class ConnectionManager {
    Mt iMt = null;
    boolean done = false;
    Vector ov = new Vector();
    private ConnectionFilter m_Filter;
    private int m_MaxConnections;
    private int m_WarningTimeout;
    private int m_DisconnectTimeout;
    private int m_HousekeepingInterval;
    private String m_LoginShell;
    private boolean m_LineMode = false;
    private boolean m_Stopping = false;

    private ConnectionManager(int n, int n2, int n3, int n4, ConnectionFilter connectionFilter, String string, boolean bl, Mt mt) {
        this.iMt = mt;
        this.ov = new Vector();
        this.m_Filter = connectionFilter;
        this.m_LoginShell = string;
        this.m_LineMode = bl;
        this.m_MaxConnections = n;
        this.m_WarningTimeout = n2;
        this.m_DisconnectTimeout = n3;
        this.m_HousekeepingInterval = n4;
    }

    private void checkOpenConnections() {
        if (this.m_Stopping) {
            return;
        }
        this.process(3, null);
    }

    public static ConnectionManager createConnectionManager(String string, Properties properties, Mt mt) throws BootException {
        try {
            int n = Integer.parseInt(properties.getProperty(String.valueOf(string) + ".maxcon"));
            int n2 = Integer.parseInt(properties.getProperty(String.valueOf(string) + ".time_to_warning"));
            int n3 = Integer.parseInt(properties.getProperty(String.valueOf(string) + ".time_to_timedout"));
            int n4 = Integer.parseInt(properties.getProperty(String.valueOf(string) + ".housekeepinginterval"));
            String string2 = properties.getProperty(String.valueOf(string) + ".connectionfilter");
            ConnectionFilter connectionFilter = null;
            String string3 = "";
            boolean bl = false;
            if (string2 != null && string2.length() != 0 && !string2.toLowerCase().equals("none")) {
                connectionFilter = (ConnectionFilter)Class.forName(string2).newInstance();
                connectionFilter.initialize(properties);
            }
            if ((string3 = properties.getProperty(String.valueOf(string) + ".loginshell")) == null || string3.length() == 0) {
                throw new BootException("Login shell must be specified.");
            }
            String string4 = properties.getProperty(String.valueOf(string) + ".inputmode");
            if (string4 == null || string4.length() == 0) {
                bl = false;
            } else if (string4.toLowerCase().equals("line")) {
                bl = true;
            }
            ConnectionManager connectionManager = new ConnectionManager(n, n2, n3, n4, connectionFilter, string3, bl, mt);
            return connectionManager;
        }
        catch (Exception exception) {
            System.out.println("ConnectionManager createConnectionManager ex:" + exception);
            throw new BootException("Failure while creating ConnectionManger instance:\n" + exception.getMessage());
        }
    }

    public void end() {
    }

    public ConnectionFilter getConnectionFilter() {
        return this.m_Filter;
    }

    public void makeConnection(Socket socket) {
        if (this.m_Filter == null || this.m_Filter != null && this.m_Filter.isAllowed(socket.getInetAddress())) {
            ConnectionData connectionData = new ConnectionData(socket, this);
            connectionData.setLoginShell(this.m_LoginShell);
            connectionData.setLineMode(this.m_LineMode);
            if (this.ov.size() < this.m_MaxConnections) {
                Connection connection = new Connection(connectionData, this.iMt);
                this.process(1, connection);
                String[] stringArray = new String[]{""};
                this.iMt.add(connection, "run", "end", stringArray);
            }
        } else {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    public synchronized void process(int n, Connection connection) {
        Object object;
        int n2;
        if (n == 1) {
            this.ov.addElement(connection);
        }
        if (n == 2) {
            n2 = 1;
            int n3 = 0;
            while (n3 < this.ov.size() && n2 != 0) {
                object = (Connection)this.ov.elementAt(n3);
                if (object.equals(connection)) {
                    n2 = 0;
                    this.ov.removeElementAt(n3);
                }
                ++n3;
            }
        }
        if (n == 3) {
            n2 = 0;
            while (n2 < this.ov.size()) {
                Connection connection2 = (Connection)this.ov.elementAt(n2);
                object = connection2.getConnectionData();
                if (!connection2.isActive()) {
                    boolean bl = true;
                    int n4 = 0;
                    while (n4 < this.ov.size() && bl) {
                        Connection connection3 = (Connection)this.ov.elementAt(n4);
                        if (connection3.equals(connection2)) {
                            this.ov.removeElementAt(n4);
                            --n2;
                        }
                        ++n4;
                    }
                } else {
                    long l = System.currentTimeMillis() - ((ConnectionData)object).getLastActivity();
                    if (l > (long)this.m_WarningTimeout) {
                        if (l > (long)(this.m_DisconnectTimeout + this.m_WarningTimeout)) {
                            connection2.processConnectionEvent(new ConnectionEvent(connection2, 101));
                        } else if (!((ConnectionData)object).isWarned()) {
                            ((ConnectionData)object).setWarned(true);
                            connection2.processConnectionEvent(new ConnectionEvent(connection2, 100));
                        }
                    }
                }
                ++n2;
            }
        }
    }

    public void registerClosedConnection(Connection connection) {
        if (this.m_Stopping) {
            return;
        }
        this.process(2, connection);
    }

    public void run() {
        try {
            do {
                this.checkOpenConnections();
                Thread.sleep(this.m_HousekeepingInterval);
            } while (!this.m_Stopping);
        }
        catch (Exception exception) {}
        this.done = true;
    }

    public void run(String string) {
        this.run();
    }

    public void setConnectionFilter(ConnectionFilter connectionFilter) {
        this.m_Filter = connectionFilter;
    }

    public void stop() {
        this.m_Stopping = true;
        int n = 0;
        while (n < 10 && !this.done) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
            ++n;
        }
        n = 0;
        while (n < this.ov.size()) {
            try {
                Connection connection = (Connection)this.ov.elementAt(n);
                connection.close();
            }
            catch (Exception exception) {}
            ++n;
        }
        this.ov = new Vector();
    }
}

