/*
 * Decompiled with CFR 0.152.
 */
package efclient.bin.si.net.sid.net;

import efclient.bin.si.net.sid.BootException;
import efclient.bin.si.net.sid.net.ConnectionManager;
import eforward.util.Mt;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Properties;

public class PortListener {
    Mt iMt = null;
    boolean done = false;
    private String m_Name;
    private int m_Port;
    private String m_THost;
    private int m_FloodProtection;
    private ServerSocket m_ServerSocket = null;
    private ConnectionManager m_ConnectionManager;
    private boolean m_Stopping = false;
    private boolean m_Available;
    private static final String logmsg = "Listening to Port {0,number,integer} with a connectivity queue size of {1,number,integer}.";

    private PortListener(String string, int n, String string2, int n2, Mt mt) {
        this.m_Name = string;
        this.m_Available = false;
        this.m_Port = n;
        this.m_THost = string2;
        this.m_FloodProtection = n2;
        this.iMt = mt;
    }

    public static PortListener createPortListener(String string, Properties properties, Mt mt) throws BootException {
        PortListener portListener = null;
        try {
            int n = Integer.parseInt(properties.getProperty(String.valueOf(string) + ".port"));
            String string2 = properties.getProperty(String.valueOf(string) + ".thost");
            int n2 = Integer.parseInt(properties.getProperty(String.valueOf(string) + ".floodprotection"));
            new Boolean(properties.getProperty(String.valueOf(string) + ".secure")).booleanValue();
            portListener = new PortListener(string, n, string2, n2, mt);
        }
        catch (Exception exception) {
            throw new BootException("Failure while creating PortListener instance:\n" + exception.getMessage());
        }
        if (portListener.m_ConnectionManager == null) {
            portListener.m_ConnectionManager = ConnectionManager.createConnectionManager(string, properties, mt);
            try {
                String[] stringArray = new String[]{""};
                mt.add(portListener.m_ConnectionManager, "run", "end", stringArray);
            }
            catch (Exception exception) {
                throw new BootException("Failure while starting ConnectionManager watchdog thread:\n" + exception.getMessage());
            }
        }
        return portListener;
    }

    public void end() {
    }

    public ConnectionManager getConnectionManager() {
        return this.m_ConnectionManager;
    }

    public String getName() {
        return this.m_Name;
    }

    public boolean isAvailable() {
        return this.m_Available;
    }

    public void run() {
        this.m_Available = true;
        try {
            this.m_ServerSocket = new ServerSocket(this.m_Port, this.m_FloodProtection, InetAddress.getByName(this.m_THost));
            Object[] objectArray = new Object[]{new Integer(this.m_Port), new Integer(this.m_FloodProtection)};
            do {
                try {
                    Socket socket = this.m_ServerSocket.accept();
                    if (this.m_Available) {
                        socket.setSoTimeout(60000);
                        this.m_ConnectionManager.makeConnection(socket);
                        continue;
                    }
                    socket.close();
                }
                catch (SocketException socketException) {}
            } while (!this.m_Stopping);
        }
        catch (IOException iOException) {
            System.out.println("PortListener run e:" + iOException);
        }
        this.done = true;
    }

    public void run(String string) {
        this.run();
    }

    public void setAvailable(boolean bl) {
        this.m_Available = bl;
    }

    public void stop() {
        this.m_Stopping = true;
        this.m_Available = false;
        this.m_ConnectionManager.stop();
        try {
            this.m_ServerSocket.close();
        }
        catch (IOException iOException) {}
        int n = 0;
        while (n < 10 && !this.done) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
            ++n;
        }
    }
}

