/*
 * Decompiled with CFR 0.152.
 */
package efclient.bin.si.sid.shell;

import efclient.bin.si.net.sid.io.BasicTerminalIO;
import efclient.bin.si.net.sid.io.SiIO;
import efclient.bin.si.net.sid.io.TerminalIO;
import efclient.bin.si.net.sid.net.Connection;
import efclient.bin.si.net.sid.net.ConnectionEvent;
import java.io.IOException;
import java.lang.reflect.Field;

public final class ShellIo
implements BasicTerminalIO {
    private final Connection connection;
    private final BasicTerminalIO terminalIo;
    private final SiIO siIo;
    private final int[] buffer = new int[1024];
    private int bufferPosition = 0;

    public ShellIo(Connection connection) {
        this.connection = connection;
        this.terminalIo = connection.getTerminalIO();
        try {
            Field field = this.terminalIo.getClass().getDeclaredField("m_SiIO");
            this.siIo = (SiIO)field.get(this.terminalIo);
        }
        catch (Exception exception) {
            System.out.println("ShellIo e:" + exception);
            throw new RuntimeException(exception.toString());
        }
    }

    public void bell() throws IOException {
        this.terminalIo.bell();
    }

    private int bufferedRead() throws IOException {
        int n;
        if (this.bufferPosition > 0) {
            --this.bufferPosition;
            n = this.buffer[this.bufferPosition];
        } else {
            n = this.siIo.read();
        }
        return n;
    }

    public void close() throws IOException {
        this.terminalIo.close();
    }

    public boolean defineScrollRegion(int n, int n2) throws IOException {
        return this.terminalIo.defineScrollRegion(n, n2);
    }

    public void eraseLine() throws IOException {
        this.terminalIo.eraseLine();
    }

    public void eraseScreen() throws IOException {
        this.terminalIo.eraseScreen();
    }

    public void eraseToBeginOfLine() throws IOException {
        this.terminalIo.eraseToBeginOfLine();
    }

    public void eraseToBeginOfScreen() throws IOException {
        this.terminalIo.eraseToBeginOfScreen();
    }

    public void eraseToEndOfLine() throws IOException {
        this.terminalIo.eraseToEndOfLine();
    }

    public void eraseToEndOfScreen() throws IOException {
        this.terminalIo.eraseToEndOfScreen();
    }

    public void flush() throws IOException {
        this.terminalIo.flush();
    }

    public void forceBold(boolean bl) {
        this.terminalIo.forceBold(bl);
    }

    public int getColumns() {
        return this.terminalIo.getColumns();
    }

    public int getRows() {
        return this.terminalIo.getRows();
    }

    private int handleEscapeSequence() throws IOException {
        int n = this.bufferedRead();
        if (n == 91) {
            int n2 = 0;
            while ((n = this.bufferedRead()) >= 0 && n < 256 && Character.isDigit((char)n)) {
                n2 = n2 * 10 + n - 48;
            }
            if (n2 == 0) {
                n2 = 1;
            }
            switch (n) {
                case 65: {
                    this.putBuffer(1001, --n2);
                    return 1001;
                }
                case 66: {
                    this.putBuffer(1002, --n2);
                    return 1002;
                }
                case 67: {
                    this.putBuffer(1003, --n2);
                    return 1003;
                }
                case 68: {
                    this.putBuffer(1004, --n2);
                    return 1004;
                }
                case 80: {
                    this.putBuffer(1302, --n2);
                    return 1302;
                }
                case 126: {
                    if (n2 != 3) break;
                    this.putBuffer(1302);
                }
            }
        }
        return 1202;
    }

    public void homeCursor() throws IOException {
        this.terminalIo.homeCursor();
    }

    public boolean isAutoflushing() {
        return this.terminalIo.isAutoflushing();
    }

    public boolean isLineWrapping() throws IOException {
        return this.terminalIo.isLineWrapping();
    }

    public boolean isSignalling() {
        return this.terminalIo.isSignalling();
    }

    public void moveCursor(int n, int n2) throws IOException {
        this.terminalIo.moveCursor(n, n2);
    }

    public void moveDown(int n) throws IOException {
        this.terminalIo.moveDown(n);
    }

    public void moveLeft(int n) throws IOException {
        this.terminalIo.moveLeft(n);
    }

    public void moveRight(int n) throws IOException {
        this.terminalIo.moveRight(n);
    }

    public void moveUp(int n) throws IOException {
        this.terminalIo.moveUp(n);
    }

    private void putBuffer(int n) {
        this.buffer[this.bufferPosition++] = n;
    }

    private void putBuffer(int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.putBuffer(n);
            ++n3;
        }
    }

    public int read() throws IOException {
        int n = this.bufferedRead();
        n = ((TerminalIO)this.terminalIo).getTerminal().translateControlCharacter(n);
        if (n == 1306) {
            this.connection.processConnectionEvent(new ConnectionEvent(this.connection, 102));
            n = 1305;
        } else if (n > 256 && n == 1200) {
            n = this.handleEscapeSequence();
        }
        return n;
    }

    public void resetAttributes() throws IOException {
        this.terminalIo.resetAttributes();
    }

    public void resetTerminal() throws IOException {
        this.terminalIo.resetTerminal();
    }

    public void restoreCursor() throws IOException {
        this.terminalIo.restoreCursor();
    }

    public void setAutoflushing(boolean bl) {
        this.terminalIo.setAutoflushing(bl);
    }

    public void setBackgroundColor(int n) throws IOException {
        this.terminalIo.setBackgroundColor(n);
    }

    public void setBlink(boolean bl) throws IOException {
        this.terminalIo.setBlink(bl);
    }

    public void setBold(boolean bl) throws IOException {
        this.terminalIo.setBold(bl);
    }

    public void setCursor(int n, int n2) throws IOException {
        this.terminalIo.setCursor(n, n2);
    }

    public void setDefaultTerminal() throws IOException {
        this.terminalIo.setDefaultTerminal();
    }

    public void setForegroundColor(int n) throws IOException {
        this.terminalIo.setForegroundColor(n);
    }

    public void setItalic(boolean bl) throws IOException {
        this.terminalIo.setItalic(bl);
    }

    public void setLinewrapping(boolean bl) throws IOException {
        this.terminalIo.setLinewrapping(bl);
    }

    public void setSignalling(boolean bl) {
        this.terminalIo.setSignalling(bl);
    }

    public void setTerminal(String string) throws IOException {
        this.terminalIo.setTerminal(string);
    }

    public void setUnderlined(boolean bl) throws IOException {
        this.terminalIo.setUnderlined(bl);
    }

    public void storeCursor() throws IOException {
        this.terminalIo.storeCursor();
    }

    public void write(byte by) throws IOException {
        this.terminalIo.write(by);
    }

    public void write(char c) throws IOException {
        this.terminalIo.write(c);
    }

    public void write(String string) throws IOException {
        this.terminalIo.write(string);
    }

    public void write(byte[] byArray) throws IOException {
        this.siIo.write(byArray);
        if (this.terminalIo.isAutoflushing()) {
            this.terminalIo.flush();
        }
    }
}

