/*
 * Decompiled with CFR 0.152.
 */
package efclient.bin.si.sid.startup;

import efclient.bin.si.net.sid.BootException;
import efclient.bin.si.net.sid.io.terminal.TerminalManager;
import efclient.bin.si.net.sid.net.PortListener;
import efclient.bin.si.net.sid.shell.ShellManager;
import efclient.bin.si.net.sid.util.StringUtil;
import eforward.util.Mt;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class Sid {
    Mt iMt = null;
    boolean runmt = false;
    private static Sid instance = null;
    Vector pv = new Vector();
    private ShellManager shellManager;

    private Sid() {
    }

    public Sid(String[] stringArray) {
        this.iMt = new Mt();
        this.runmt = true;
        String string = stringArray[0];
        try {
            if (string.indexOf("-p") == 0) {
                Properties properties = new Properties();
                ((Hashtable)properties).put("terminals", "vt100,ansi,windoof,xterm");
                ((Hashtable)properties).put("term.vt100.class", "efclient.bin.si.net.sid.io.terminal.vt100");
                ((Hashtable)properties).put("term.vt100.aliases", "default,vt100-am,vt102,dec-vt100");
                ((Hashtable)properties).put("term.ansi.class", "efclient.bin.si.net.sid.io.terminal.ansi");
                ((Hashtable)properties).put("term.ansi.aliases", "color-xterm,xterm-color,vt320,vt220,linux,screen");
                ((Hashtable)properties).put("term.windoof.class", "efclient.bin.si.net.sid.io.terminal.Windoof");
                ((Hashtable)properties).put("term.windoof.aliases", "");
                ((Hashtable)properties).put("term.xterm.class", "efclient.bin.si.net.sid.io.terminal.xterm");
                ((Hashtable)properties).put("term.xterm.aliases", "");
                ((Hashtable)properties).put("listeners", "std");
                String string2 = "51621";
                if (string.length() > 2) {
                    string2 = string.substring(2, string.length());
                }
                ((Hashtable)properties).put("std.port", string2);
                ((Hashtable)properties).put("std.floodprotection", "5");
                ((Hashtable)properties).put("std.maxcon", "25");
                ((Hashtable)properties).put("std.time_to_warning", "3600000");
                ((Hashtable)properties).put("std.time_to_timedout", "60000");
                ((Hashtable)properties).put("std.housekeepinginterval", "1000");
                ((Hashtable)properties).put("std.inputmode", "character");
                ((Hashtable)properties).put("std.loginshell", "sts");
                ((Hashtable)properties).put("std.connectionfilter", "none");
                ((Hashtable)properties).put("shells", "sts");
                ((Hashtable)properties).put("shell.sts.class", "efclient.bin.si.sid.shell.Sts");
                this.createSid(properties);
            }
        }
        catch (Exception exception) {
            System.out.println("Failed to load configuration from given URL. " + exception);
        }
    }

    public static Sid createSid() throws BootException {
        return null;
    }

    public void createSid(Properties properties) {
        try {
            this.prepareShellManager(properties);
            this.prepareTerminals(properties);
            String[] stringArray = StringUtil.split(properties.getProperty("listeners"), ",");
            int n = 0;
            while (n < stringArray.length) {
                this.prepareListener(stringArray[n], properties);
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("createSid e:" + exception);
        }
    }

    public void end() {
    }

    public static synchronized Sid getInstance() {
        if (instance != null) {
            return instance;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        Sid sid = new Sid(stringArray);
        String[] stringArray2 = new String[]{""};
        sid.iMt.add(sid, "run", "end", stringArray2);
    }

    private void prepareListener(String string, Properties properties) throws BootException {
        Object object;
        int n = 0;
        try {
            n = Integer.parseInt(properties.getProperty(String.valueOf(string) + ".port"));
            object = new ServerSocket(n);
            ((ServerSocket)object).close();
        }
        catch (NumberFormatException numberFormatException) {
            throw new BootException("Failure while parsing port number for \"" + string + ".port\": " + numberFormatException.getMessage());
        }
        catch (IOException iOException) {
            throw new BootException("Failure while starting listener for port number " + n + ": " + iOException.getMessage());
        }
        object = PortListener.createPortListener(string, properties, this.iMt);
        try {
            this.pv.addElement(object);
        }
        catch (Exception exception) {
            throw new BootException("Failure while starting PortListener thread: " + exception.getMessage());
        }
    }

    private void prepareShellManager(Properties properties) throws BootException {
        this.shellManager = ShellManager.createShellManager(properties, this.iMt);
        if (this.shellManager == null) {
            System.exit(1);
        }
    }

    private void prepareTerminals(Properties properties) throws BootException {
        TerminalManager.createTerminalManager(properties, this.iMt);
    }

    public void run() {
        int n = 0;
        while (n < this.pv.size()) {
            PortListener portListener = (PortListener)this.pv.elementAt(n);
            String[] stringArray = new String[]{""};
            this.iMt.add(portListener, "run", "end", stringArray);
            ++n;
        }
    }

    public void run(String string) {
        this.run();
    }

    public void stop() {
        int n = 0;
        while (n < this.pv.size()) {
            PortListener portListener = (PortListener)this.pv.elementAt(n);
            portListener.stop();
            ++n;
        }
    }
}

