/*
 * Decompiled with CFR 0.152.
 */
package eforward.util;

import eforward.util.Array;
import eforward.util.Ascii;
import eforward.util.Copy;
import eforward.util.EdiTag;
import eforward.util.Io;
import eforward.util.Txt;
import eforward.util.Util;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.util.Vector;

public class FileTypes
implements EdiTag {
    int ityp = 20;
    String[] n = new String[]{"X12", "CAMIR", "EDIFACT", "TXT", "EDI", "HTML", "CSV", "XML", "XML", "PACK", "PDF", "XLS", "DOC", "TIF", "XLSX", "ZIP", "BMP", "GIF", "JPG", "BIN", "UNK"};
    Txt tX = new Txt();
    Array iAr = new Array();
    byte[] dat = null;

    public FileTypes() {
    }

    public FileTypes(String string, String string2) {
        this.getType(string, string2);
    }

    public FileTypes(String string, String string2, byte[] byArray) {
        this.dat = new Copy().arrayCopy(byArray);
        this.getType(string, string2);
    }

    public int getType(String string, String string2) {
        this.ityp = 20;
        if (this.dat == null) {
            this.dat = this.readTop(string);
        }
        if (this.isX12(this.dat)) {
            this.ityp = 0;
        } else if (this.isCamir(this.dat)) {
            this.ityp = 1;
        } else if (this.isEdifact(this.dat)) {
            this.ityp = 2;
        } else if (this.isTxt(string2)) {
            this.ityp = 3;
        } else if (this.isXml(this.dat, true)) {
            this.ityp = 7;
        } else if (this.isHtml(string2, this.dat)) {
            this.ityp = 5;
        } else if (this.isCsv(string2, this.dat)) {
            this.ityp = 6;
        } else if (this.isXml(this.dat, false)) {
            this.ityp = 8;
        } else if (this.isPack(this.dat)) {
            this.ityp = 9;
        }
        if (this.ityp == 20) {
            if (this.isPdf(string2, this.dat)) {
                this.ityp = 10;
            } else if (this.isXls(string2, this.dat)) {
                this.ityp = 11;
            } else if (this.isMagic(string2, this.dat, 53455)) {
                this.ityp = 12;
            } else if (this.isTiff(string2, this.dat)) {
                this.ityp = 13;
            } else if (this.isXlsx(string2, this.dat)) {
                this.ityp = 14;
            } else if (this.isZip(string2, this.dat)) {
                this.ityp = 15;
            } else if (this.isBmp(string2, this.dat)) {
                this.ityp = 16;
            } else if (this.isGif(string2, this.dat)) {
                this.ityp = 17;
            } else if (this.isJpg(string2, this.dat)) {
                this.ityp = 18;
            }
        }
        if (this.ityp == 20) {
            this.ityp = this.isBinary(this.dat) ? 19 : (this.isEdi(this.dat) ? 4 : 3);
        }
        return this.ityp;
    }

    public String getTypeName() {
        return this.n[this.ityp];
    }

    public int getTypeNumber() {
        return this.ityp;
    }

    public boolean isBinary(byte[] byArray) {
        int n = byArray.length;
        int n2 = n > 512 ? 512 : n;
        byte[] byArray2 = new Copy().arrayCopy(byArray, 0, n2);
        boolean bl = true;
        try {
            float f;
            float f2;
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                if ((byArray2[n4] & 0xFF) == 13 || (byArray2[n4] & 0xFF) == 10 || (byArray2[n4] & 0xFF) == 9 || (byArray2[n4] & 0xFF) == 133) {
                    ++n3;
                } else if ((byArray2[n4] & 0xFF) > 31 && (byArray2[n4] & 0xFF) < 128) {
                    ++n3;
                }
                ++n4;
            }
            float f3 = new Double(Integer.toString(n3)).floatValue();
            if (f3 / (f2 = new Double(Integer.toString(n2)).floatValue()) > (f = new Double(".7").floatValue())) {
                bl = false;
            }
        }
        catch (Exception exception) {}
        return bl;
    }

    public boolean isBmp(String string, byte[] byArray) {
        String string2;
        if (string != null && string.length() > 4 && (string2 = string.substring(string.length() - 4, string.length())).equalsIgnoreCase(".bmp")) {
            return true;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (byArray == null || byArray.length < 10) {
            return bl;
        }
        if ((byArray[0] & 0xFF) == 66 && (byArray[1] & 0xFF) == 77) {
            bl2 = true;
        }
        if (bl2) {
            bl = true;
            try {
                float f;
                float f2;
                int n = byArray.length;
                int n2 = n > 512 ? 512 : n;
                byte[] byArray2 = new Copy().arrayCopy(byArray, 0, n2);
                int n3 = 0;
                int n4 = 0;
                while (n4 < n2) {
                    if ((byArray2[n4] & 0xFF) == 13 || (byArray2[n4] & 0xFF) == 10 || (byArray2[n4] & 0xFF) == 9 || (byArray2[n4] & 0xFF) == 133) {
                        ++n3;
                    } else if ((byArray2[n4] & 0xFF) > 31 && (byArray2[n4] & 0xFF) < 128) {
                        ++n3;
                    }
                    ++n4;
                }
                float f3 = new Double(Integer.toString(n3)).floatValue();
                if (f3 / (f2 = new Double(Integer.toString(n2)).floatValue()) > (f = new Double(".7").floatValue())) {
                    bl = false;
                }
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    public boolean isCamir(byte[] byArray) {
        boolean bl = false;
        if (byArray.length > 3 && this.iAr.isSubEqual(EdiTag.ACR, byArray)) {
            bl = true;
        }
        return bl;
    }

    public boolean isCsv(String string, byte[] byArray) {
        Object object;
        if (string != null && string.length() > 4 && ((String)(object = string.substring(string.length() - 4, string.length()))).equalsIgnoreCase(".csv")) {
            return true;
        }
        object = new Io();
        Util util = new Util();
        boolean bl = false;
        if (byArray == null || byArray.length < 10) {
            return bl;
        }
        try {
            int n;
            int n2 = byArray.length;
            int n3 = n = n2 > 512 ? 512 : n2;
            if (n2 > 10) {
                byte[] byArray2 = new Copy().arrayCopy(byArray, 0, n);
                Vector vector = new Vector();
                ((Io)object).readInput(byArray2, vector);
                String[][] stringArray = new String[][]{new String[0], new String[0], new String[0]};
                int n4 = vector.size();
                int n5 = 0;
                while (n5 < n4 && n5 < 3) {
                    String string2 = (String)vector.elementAt(n5);
                    stringArray[n5] = util.getCsv(string2);
                    ++n5;
                }
                if (n4 == 1) {
                    if (stringArray[0].length > 4) {
                        bl = true;
                    }
                } else if (stringArray[0].length > 3 && stringArray[1].length == stringArray[0].length) {
                    if (n4 > 2) {
                        if (stringArray[2].length == stringArray[1].length) {
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                }
            }
        }
        catch (Exception exception) {}
        return bl;
    }

    public boolean isEdi(byte[] byArray) {
        int n = byArray.length;
        if (n < 20) {
            return false;
        }
        if (this.iAr.isSubEqual(EdiTag.IH, byArray)) {
            return true;
        }
        if (this.iAr.isSubEqual(EdiTag.ISA, byArray)) {
            return true;
        }
        if (this.iAr.isSubEqual(EdiTag.BG, byArray)) {
            return true;
        }
        if (this.iAr.isSubEqual(EdiTag.GS, byArray)) {
            return true;
        }
        if (this.iAr.isSubEqual(EdiTag.STX, byArray)) {
            return true;
        }
        if (this.iAr.isSubEqual(EdiTag.ICS, byArray)) {
            return true;
        }
        if (this.iAr.isSubEqual(Ascii._PN, byArray)) {
            return true;
        }
        if (this.iAr.isSubEqual(EdiTag.UNA, byArray)) {
            return true;
        }
        if (this.iAr.isSubEqual(EdiTag.UNB, byArray)) {
            return true;
        }
        if (this.iAr.isSubEqual(EdiTag.GES, byArray)) {
            return true;
        }
        if (this.iAr.isSubEqual(EdiTag.CLM, byArray)) {
            return true;
        }
        if (this.iAr.isSubEqual(EdiTag.ACR, byArray)) {
            return true;
        }
        if (this.iAr.isSubEqual(EdiTag.VS, byArray)) {
            return true;
        }
        return this.iAr.isSubEqual(EdiTag.SEIM, byArray);
    }

    public boolean isEdifact(byte[] byArray) {
        boolean bl = false;
        if (byArray.length > 3) {
            if (this.iAr.isSubEqual(EdiTag.UNA, byArray)) {
                bl = true;
            } else if (this.iAr.isSubEqual(EdiTag.UNB, byArray)) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isGif(String string, byte[] byArray) {
        String string2;
        if (string != null && string.length() > 4 && (string2 = string.substring(string.length() - 4, string.length())).equalsIgnoreCase(".gif")) {
            return true;
        }
        boolean bl = false;
        if (byArray == null || byArray.length < 10) {
            return bl;
        }
        if ((byArray[0] & 0xFF) == 71 && (byArray[1] & 0xFF) == 73 && (byArray[2] & 0xFF) == 70 && (byArray[3] & 0xFF) == 56 && (byArray[4] & 0xFF) == 55 && (byArray[5] & 0xFF) == 97) {
            bl = true;
        }
        if ((byArray[0] & 0xFF) == 71 && (byArray[1] & 0xFF) == 73 && (byArray[2] & 0xFF) == 70 && (byArray[3] & 0xFF) == 56 && (byArray[4] & 0xFF) == 57 && (byArray[5] & 0xFF) == 97) {
            bl = true;
        }
        return bl;
    }

    public boolean isHtml(String string, byte[] byArray) {
        String string2;
        if (string != null && string.length() > 5 && (string2 = string.substring(string.length() - 5, string.length())).equalsIgnoreCase(".html")) {
            return true;
        }
        if (string != null && string.length() > 4 && (string2 = string.substring(string.length() - 4, string.length())).equalsIgnoreCase(".htm")) {
            return true;
        }
        boolean bl = false;
        byte[] byArray2 = new Copy().arrayCopy(byArray, 0, 256);
        this.iAr.textToUpper(byArray2);
        try {
            String[] stringArray = new String[]{"<!DOCTYPE", "<HTML", "<HEAD"};
            String string3 = new String(byArray2).trim();
            int n = 0;
            while (n < stringArray.length) {
                if (string3.indexOf(stringArray[n]) > -1) {
                    bl = true;
                }
                ++n;
            }
        }
        catch (Exception exception) {}
        return bl;
    }

    public boolean isJpg(String string, byte[] byArray) {
        return this.isMagic(string, byArray, 65496);
    }

    public boolean isMagic(String string, byte[] byArray, int n) {
        byte[] byArray2 = new Copy().arrayCopy(byArray);
        boolean bl = false;
        if (byArray2 == null || byArray2.length < 10) {
            return bl;
        }
        try {
            if (n == 9552 || n == 15423) {
                if (byArray2.length > 19) {
                    if (n == 9552) {
                        bl = this.isPdf(string, byArray2);
                    }
                    if (n == 15423) {
                        bl = this.isXml(byArray2, true);
                    }
                }
            } else {
                int n2 = ((byArray2[0] & 0xFF) << 8) + (byArray2[1] & 0xFF);
                if (n2 == n) {
                    bl = true;
                }
            }
        }
        catch (Exception exception) {}
        return bl;
    }

    public boolean isPack(byte[] byArray) {
        byte[] byArray2 = new byte[]{63, 83, 69, 73, 77, 58};
        boolean bl = false;
        if (this.iAr.isEqual(byArray2, 0, byArray2.length, byArray, 0)) {
            bl = true;
        }
        return bl;
    }

    public boolean isPdf(String string, byte[] byArray) {
        String string2;
        if (string != null && string.length() > 4 && (string2 = string.substring(string.length() - 4, string.length())).equalsIgnoreCase(".pdf")) {
            return true;
        }
        boolean bl = false;
        if (byArray == null || byArray.length < 10) {
            return bl;
        }
        this.iAr.textToUpper(byArray);
        if ((byArray[0] & 0xFF) == 37 && (byArray[1] & 0xFF) == 80 && (byArray[2] & 0xFF) == 68 && (byArray[3] & 0xFF) == 70) {
            bl = true;
        }
        return bl;
    }

    public boolean isTiff(String string, byte[] byArray) {
        String string2;
        if (string != null && string.length() > 4 && (string2 = string.substring(string.length() - 4, string.length())).equalsIgnoreCase(".tif")) {
            return true;
        }
        boolean bl = false;
        if (byArray == null || byArray.length < 10) {
            return bl;
        }
        boolean bl2 = false;
        if ((byArray[0] & 0xFF) == 73 && (byArray[1] & 0xFF) == 73 && (byArray[2] & 0xFF) == 42 && (byArray[3] & 0xFF) == 0) {
            bl2 = true;
        }
        if ((byArray[0] & 0xFF) == 77 && (byArray[1] & 0xFF) == 77 && (byArray[2] & 0xFF) == 0 && (byArray[3] & 0xFF) == 42) {
            bl2 = true;
        }
        if (bl2) {
            bl = true;
            try {
                float f;
                float f2;
                int n = byArray.length;
                int n2 = n > 512 ? 512 : n;
                byte[] byArray2 = new Copy().arrayCopy(byArray, 0, n2);
                int n3 = 0;
                int n4 = 0;
                while (n4 < n2) {
                    if ((byArray2[n4] & 0xFF) == 13 || (byArray2[n4] & 0xFF) == 10 || (byArray2[n4] & 0xFF) == 9 || (byArray2[n4] & 0xFF) == 133) {
                        ++n3;
                    } else if ((byArray2[n4] & 0xFF) > 31 && (byArray2[n4] & 0xFF) < 128) {
                        ++n3;
                    }
                    ++n4;
                }
                float f3 = new Double(Integer.toString(n3)).floatValue();
                if (f3 / (f2 = new Double(Integer.toString(n2)).floatValue()) > (f = new Double(".7").floatValue())) {
                    bl = false;
                }
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    public boolean isTxt(String string) {
        String string2;
        boolean bl = false;
        if (string != null && string.length() > 5 && (string2 = string.substring(string.length() - 5, string.length())).equalsIgnoreCase(".txt")) {
            bl = true;
        }
        return bl;
    }

    public boolean isX12(byte[] byArray) {
        int n = byArray.length;
        if (n < 20) {
            return false;
        }
        if (this.iAr.isSubEqual(EdiTag.IH, byArray)) {
            return true;
        }
        if (this.iAr.isSubEqual(EdiTag.ISA, byArray)) {
            return true;
        }
        if (this.iAr.isSubEqual(EdiTag.BG, byArray)) {
            return true;
        }
        return this.iAr.isSubEqual(EdiTag.GS, byArray);
    }

    public boolean isXls(String string, byte[] byArray) {
        String string2;
        if (string.length() < 5) {
            return false;
        }
        if (string != null && string.length() > 4 && (string2 = string.substring(string.length() - 4, string.length())).equalsIgnoreCase(".doc")) {
            return false;
        }
        if (string != null && string.length() > 3 && (string2 = string.substring(string.length() - 3, string.length())).equalsIgnoreCase(".db")) {
            return false;
        }
        return this.isMagic(string, byArray, 53455);
    }

    public boolean isXlsx(String string, byte[] byArray) {
        boolean bl = false;
        bl = this.isMagic(string, byArray, 20555);
        if (bl) {
            String string2;
            bl = false;
            if (string != null && string.length() > 5 && (string2 = string.substring(string.length() - 5, string.length())).equalsIgnoreCase(".xlsx")) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isXml(byte[] byArray, boolean bl) {
        boolean bl2 = false;
        byte[] byArray2 = new Copy().arrayCopy(byArray, 0, 256);
        try {
            this.iAr.textToUpper(byArray2);
            String[] stringArray = new String[]{"<?XML"};
            String string = new String(byArray2);
            int n = 0;
            while (n < stringArray.length) {
                if (string.indexOf(stringArray[n]) > -1) {
                    bl2 = true;
                }
                ++n;
            }
            if (!bl2 && bl) {
                String[] stringArray2 = new String[]{"<"};
                string = new String(byArray2).trim();
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    if (string.indexOf(stringArray2[n2]) == 0) {
                        bl2 = true;
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {}
        return bl2;
    }

    public boolean isZip(String string) {
        if (this.dat == null) {
            this.dat = this.readTop(string);
        }
        return this.isZip(string, this.dat);
    }

    public boolean isZip(String string, byte[] byArray) {
        String string2;
        boolean bl = false;
        bl = this.isMagic(string, byArray, 20555);
        if (bl && string != null && string.length() > 5 && (string2 = string.substring(string.length() - 5, string.length())).equalsIgnoreCase(".xlsx")) {
            bl = false;
        }
        return bl;
    }

    public byte[] readTop(String string) {
        FilterInputStream filterInputStream = null;
        FileInputStream fileInputStream = null;
        byte[] byArray = new byte[]{};
        try {
            if (!new File(string).isFile()) {
                this.tX.text("readTop file not found " + string, true, null);
                return new byte[0];
            }
            File file = new File(string);
            if (file.length() > 2L) {
                int n = file.length() > 512L ? 512 : (int)file.length();
                fileInputStream = new FileInputStream(string);
                filterInputStream = new DataInputStream(new BufferedInputStream(fileInputStream));
                byArray = new byte[n];
                ((DataInputStream)filterInputStream).readFully(byArray);
            }
        }
        catch (Exception exception) {}
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
        catch (Exception exception) {}
        return new Copy().arrayCopy(byArray);
    }
}

