/*
 * Decompiled with CFR 0.152.
 */
package eforward.util;

import eforward.util.Copy;
import eforward.util.Rfile;
import eforward.util.Util;
import java.io.File;
import java.io.RandomAccessFile;

public class MemFile {
    boolean rw = true;
    int bsz = 1024;
    int flen = 0;
    int fp = 0;
    byte[] mb = new byte[this.bsz];
    String fname = "";

    public MemFile() {
    }

    public MemFile(String string) {
        this.open(string, "rw");
    }

    public MemFile(String string, String string2) {
        this.open(string, string2);
    }

    public void close() {
        if (this.fname.length() == 0) {
            return;
        }
        this.save();
        this.flen = 0;
        this.fp = 0;
        this.mb = new byte[this.bsz];
    }

    public long getFilePointer() {
        return this.fp;
    }

    public long length() {
        return this.flen;
    }

    private void open(String string, String string2) {
        if (string2.equals("r")) {
            this.rw = false;
        }
        this.flen = 0;
        this.fp = 0;
        this.mb = new byte[this.bsz];
        Rfile rfile = new Rfile();
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = rfile.openRfile(string, string2);
            byte[] byArray = null;
            while ((byArray = rfile.read(randomAccessFile, this.bsz * 3)) != null) {
                this.write(byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            System.out.println("load:" + exception);
        }
        if (randomAccessFile != null) {
            rfile.closeRfile(randomAccessFile);
        }
        this.fp = 0;
        this.fname = string;
    }

    public int read() {
        byte[] byArray = new byte[1];
        this.read(byArray, 0, 1);
        byte by = byArray[0];
        return by;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, 1);
    }

    public int read(byte[] byArray, int n, int n2) {
        if (this.fp + n2 > this.flen) {
            n2 = this.flen - this.fp;
            if (n2 < 1) {
                return -1;
            }
            n2 = this.flen - this.fp;
        }
        int n3 = 0;
        while (n3 < n2) {
            byArray[n + n3] = this.mb[this.fp++];
            ++n3;
        }
        return n2;
    }

    public boolean readBoolean() throws Exception {
        int n = this.read();
        if (n < 0) {
            throw new Exception();
        }
        return n != 0;
    }

    public byte readByte() throws Exception {
        int n = this.read();
        if (n < 0) {
            throw new Exception();
        }
        return (byte)n;
    }

    public char readChar() throws Exception {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new Exception();
        }
        return (char)((n2 << 8) + (n << 0));
    }

    public double readDouble() throws Exception {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() throws Exception {
        return Float.intBitsToFloat(this.readInt());
    }

    public void readFully(byte[] byArray) throws Exception {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws Exception {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.read(byArray, n + n3, n2 - n3);
            if (n4 < 0) {
                throw new Exception();
            }
            n3 += n4;
        }
    }

    public int readInt() throws Exception {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new Exception();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    public String readLine() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.read()) != -1 && n != 10) {
            stringBuffer.append((char)n);
        }
        if (n == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public long readLong() throws Exception {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public short readShort() throws Exception {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new Exception();
        }
        return (short)((n2 << 8) + (n << 0));
    }

    public int readUnsignedByte() throws Exception {
        int n = this.read();
        if (n < 0) {
            throw new Exception();
        }
        return n;
    }

    public int readUnsignedShort() throws Exception {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new Exception();
        }
        return (n2 << 8) + (n << 0);
    }

    public String readUTF() throws Exception {
        byte[] byArray = new byte[2];
        this.read(byArray, 0, 2);
        int n = (byArray[0] << 8) + (byArray[1] & 0xFF);
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byArray = new byte[1];
            this.read(byArray, 0, 1);
            int n4 = byArray[0] & 0xFF;
            switch (n4 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    cArray[n3++] = (char)n4;
                    break;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n) {
                        throw new Exception();
                    }
                    this.read(byArray, 0, 1);
                    int n5 = byArray[0] & 0xFF;
                    if ((n5 & 0xC0) != 128) {
                        throw new Exception();
                    }
                    cArray[n3++] = (char)((n4 & 0x1F) << 6 | n5 & 0x3F);
                    break;
                }
                case 14: {
                    if ((n2 += 3) > n) {
                        throw new Exception();
                    }
                    this.read(byArray, 0, 1);
                    int n5 = byArray[0] & 0xFF;
                    this.read(byArray, 0, 1);
                    int n6 = byArray[0] & 0xFF;
                    if ((n5 & 0xC0) != 128 || (n6 & 0xC0) != 128) {
                        throw new Exception();
                    }
                    cArray[n3++] = (char)((n4 & 0xF) << 12 | (n5 & 0x3F) << 6 | (n6 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new Exception();
                }
            }
        }
        return new String(cArray, 0, n3);
    }

    public void save() {
        if (!this.rw) {
            return;
        }
        new Util().rmFile(new File(this.fname));
        Rfile rfile = new Rfile();
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = rfile.openRfile(this.fname);
            byte[] byArray = new byte[this.bsz];
            int n = 0;
            this.seek(0L);
            while ((n = this.read(byArray, 0, byArray.length)) > -1) {
                randomAccessFile.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            System.out.println("close:" + exception);
        }
        if (randomAccessFile != null) {
            rfile.closeRfile(randomAccessFile);
        }
    }

    public void seek(long l) {
        this.fp = (int)l;
    }

    public void setName(String string) {
        this.fname = string;
    }

    public int skipBytes(int n) {
        this.seek(this.fp + n);
        return n;
    }

    public void write(int n) {
        byte[] byArray = new byte[]{(byte)(n >>> 0 & 0xFF)};
        this.write(byArray, 0, 1);
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) {
        int n3 = this.mb.length;
        if (this.fp + n2 > n3) {
            while (n3 < this.fp + n2) {
                n3 += this.bsz;
            }
            byte[] byArray2 = new byte[n3];
            int n4 = 0;
            while (n4 < this.flen) {
                byArray2[n4] = this.mb[n4];
                ++n4;
            }
            this.mb = new Copy().arrayCopy(byArray2);
        }
        int n5 = 0;
        while (n5 < n2) {
            this.mb[this.fp++] = byArray[n + n5];
            ++n5;
        }
        if (this.fp > this.flen) {
            this.flen = this.fp;
        }
    }

    public void writeBoolean(boolean bl) {
        this.write(bl ? 1 : 0);
    }

    public void writeBytes(String string) {
        int n = string.length();
        byte[] byArray = string.getBytes();
        this.write(byArray, 0, n);
    }

    public void writeChar(int n) {
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    public void writeChars(String string) {
        int n = string.length();
        int n2 = 2 * n;
        byte[] byArray = new byte[n2];
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            byArray[n4++] = (byte)(cArray[n3] >>> 8);
            byArray[n4++] = (byte)(cArray[n3] >>> 0);
            ++n3;
        }
        this.write(byArray, 0, n2);
    }

    public void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeInt(int n) {
        this.write(n >>> 24 & 0xFF);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    public void writeLong(long l) {
        this.write((int)(l >>> 56) & 0xFF);
        this.write((int)(l >>> 48) & 0xFF);
        this.write((int)(l >>> 40) & 0xFF);
        this.write((int)(l >>> 32) & 0xFF);
        this.write((int)(l >>> 24) & 0xFF);
        this.write((int)(l >>> 16) & 0xFF);
        this.write((int)(l >>> 8) & 0xFF);
        this.write((int)(l >>> 0) & 0xFF);
    }

    public void writeShort(int n) {
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    public void writeUTF(String string) throws Exception {
        char c;
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            c = string.charAt(n3);
            n2 = c >= '\u0001' && c <= '\u007f' ? ++n2 : (c > '\u07ff' ? (n2 += 3) : (n2 += 2));
            ++n3;
        }
        if (n2 > 65535) {
            throw new Exception();
        }
        this.write(n2 >>> 8 & 0xFF);
        this.write(n2 >>> 0 & 0xFF);
        n3 = 0;
        while (n3 < n) {
            c = string.charAt(n3);
            if (c >= '\u0001' && c <= '\u007f') {
                this.write(c);
            } else if (c > '\u07ff') {
                this.write(0xE0 | c >> 12 & 0xF);
                this.write(0x80 | c >> 6 & 0x3F);
                this.write(0x80 | c >> 0 & 0x3F);
            } else {
                this.write(0xC0 | c >> 6 & 0x1F);
                this.write(0x80 | c >> 0 & 0x3F);
            }
            ++n3;
        }
    }
}

