package efclient.receiver.req;

import java.io.*;
import java.util.*;
/**
 * Mv.java
 * Move received file to new location (-r"j,mv target_path")
 * Corvedia Inc. - 3/20/2002
 * @author: Greg Pringle
 */
public class Mv implements eforward.util.EdiTag {
	eforward.util.Mt iMt = null;
	boolean runmt = false;
	eforward.util.Array iAr = new eforward.util.Array();
	eforward.util.Util iUtil = new eforward.util.Util();
	eforward.util.Txt tX = new eforward.util.Txt();
	eforward.util.EdiMbg eMbg = new eforward.util.EdiMbg(iUtil);
	eforward.util.Io iO = new eforward.util.Io();
	String[][] clist = new String[1][];
	byte[] NUM = {_0, _1, _2, _3, _4, _5, _6, _7, _8, _9, SP};
	byte[] DEL = {CR, NL};
	byte[] HDR = {H, D, R};
	byte[] nHDR = {NL, H, D, R};
	/*
	private class M implements Runnable {
	String n = null, f = null, t = null, h = null, s = null, c = null;
	public M(String n, String f, String t, String h, String s, String c) {
	this.n = n;
	this.f = f;
	this.t = t;
	this.h = h;
	this.s = s;
	this.c = c;
	}
	public void run() {
	boolean a = (n != null && (new File(n).isFile())) ? true : false;
	boolean m = (c != null && (c.length() > 0)) ? true : false;
	try {
	int ka = 0;
	int km = 0;
	if (t.length() > 0) {
	int k = 4;
	if (a) {
	ka = k;
	k++;
	}
	if (m) {
	km = k;
	k++;
	}
	String[] cmd = new String[k];
	cmd[0] = "-f" + f;
	cmd[1] = "-t" + t;
	cmd[2] = "-s" + s;
	cmd[3] = "-h" + h;
	if (m)
	cmd[km] = "-c" + c;
	if (a)
	cmd[ka] = "-m" + n;
	new eforward.util.MailTxt(new eforward.util.Copy().arrayCopy(cmd));
	}
	} catch (Exception e) {
	}
	if (a)
	iUtil.rmFile(new File(n));
	}
	}
	*/
/**
 * Insert the method's description here.
 * Creation date: (07-04-28 7:02:23 pm)
 */
public Mv() {
	super();
}
/**
 * @param st java.lang.String[]
 * @param eMsg eforward.client.EdiSendEMsg
 */
public Mv(String[] st, eforward.client.EdiSendEMsg eMsg) {
	mv(st, eMsg, false);
}
/**
 * Insert the method's description here.
 * Creation date: (01/28/18 7:43:13 am)
 * @param st java.lang.String[]
 * @param eMsg eforward.client.EdiSendEMsg
 * @param iMt eforward.util.Mt
 */
public Mv(String[] st, eforward.client.EdiSendEMsg eMsg, eforward.util.Mt iMt) {
	this.iMt = iMt;
	mv(st, eMsg, false);
}
/**
 * Insert the method's description here.
 * Creation date: (07-04-26 7:59:30 am)
 * @param st java.lang.String[]
 * @param eMsg eforward.client.EdiSendEMsg
 * @param ebc boolean
 */
public Mv(String[] st, eforward.client.EdiSendEMsg eMsg, boolean ebc) {
	mv(st, eMsg, ebc);
}
/**
 * Insert the method's description here.
 * Creation date: (01/28/18 7:42:03 am)
 * @param st java.lang.String[]
 * @param eMsg eforward.client.EdiSendEMsg
 * @param ebc boolean
 * @param iMt eforward.util.Mt
 */
public Mv(String[] st, eforward.client.EdiSendEMsg eMsg, boolean ebc, eforward.util.Mt iMt) {
	this.iMt = iMt;
	mv(st, eMsg, ebc);
}
/**
 * Insert the method's description here.
 * Creation date: (07-04-26 7:54:45 am)
 * @param st java.lang.String[]
 * @param eMsg eforward.client.EdiSendEMsg
 * @param ebc boolean
 */
public void mv(String[] st, eforward.client.EdiSendEMsg eMsg, boolean ebc) {
	//eMsg.setMsgText("====================================================================");
	//String eMsg.getInboundFilename()	// queue file name
	//String eMsg.getOriginalFilename()	// file name
	//String eMsg.getDestination()      // sender	
	//String eMsg.getOrigin()           // receiver
	//String eMsg.getQname()	        // rf name (receive Qname)
	//String eMsg.getRqname()	        // ef name (send Qname)
	//st:test\rf553609659^test2^-u^-s13,10
	//System.out.println("mv: "+iUtil.appnd(st,"^"));	
	String filename = st[0];
	String inbfile = eMsg.getInboundFilename(); // queue file name
	String orgfile = eMsg.getOriginalFilename(); // file name
	String sndr = eMsg.getDestination(); // sender	
	String rcvr = eMsg.getOrigin(); // receiver
	String qname = eMsg.getQname();
	String rqname = eMsg.getRqname();
	String newpath, spath, sname;
	boolean append = false;
	boolean type = false;
	boolean nl = false;
	boolean seg = false;
	boolean x12 = false;
	boolean copy = false;
	boolean copyf = false;
	boolean splt = false;
	boolean pspl = false;
	boolean cmb = false;
	boolean crlf = false;
	boolean unpack = true;
	boolean update = true;
	boolean trim = false;
	boolean detail = false;
	String allow = "";
	String dtl = "";
	String nlc = "";
	String pseq = "";
	String pelm = "";
	String aname = "";
	String testdir = "";
	String subs = "";
	String edfsegt = "";
	String segt = "";
	String unique = "";
	String filespec = "";
	String[] cpath = new String[0];
	String mvcopy = "";
	String mvbin = "";
	String mvedi = "";
	String mapfile = "";
	String ext = "";
	String chid = "";
	String email = "";
	String emailhost = "";
	String mailque = "";
	String version = null;
	String rpc = null;
	String logfile = null;
	String specname = null;
	String orig = sndr;
	String dest = rcvr;
	boolean isairs = false;
	String irs = "";
	Hashtable hcmb = null;
	Vector vcmb = null;
	String dparm = eMsg.getDProcessParameters();
	String[] pi = null;
	if (iMt == null) {
		iMt = new eforward.util.Mt();
		runmt = true;
	} else {
		if (dparm.length() > 0) {
			pi = new eforward.util.Copy().arrayCopy(iUtil.stringToArray(dparm, ',', 4, true));
			if (pi[0].equals("Si") && sndr.equals("CORVEDIA")) {
				String clsname = "efclient.bin.si.Si";
				String[] jars = {"si.jar"};
				String[] argsz = {"-wsi.properties", "-lfalse", "-jsi.jar"};
				eforward.util.Proc iProc = new eforward.util.Proc(iMt);
				iProc.runMtMethod(clsname, jars, argsz, "run", "end");
				return;
			}
		}
	}
	int tc = -1;
	//eMsg.getAliasD(clist);
	if (!runmt) {
		String clst = eMsg.getAliasD();
		clist[0] = new eforward.util.Copy().arrayCopy(iUtil.setClistc(clst));
	}
	if (clist != null && clist[0] == null)
		clist[0] = new String[0];
	int icmb = 0;
	eforward.util.MailQue mQ = null;
	eforward.util.Log lG = null;
	iUtil.separatePath(filename);
	sname = iUtil.fileName;
	spath = iUtil.filePath;
	newpath = iUtil.filePath;
	if (st.length > 1 && st[1].charAt(0) != '-') {
		newpath = st[1];
	}
	if (newpath.length() > 0) {
		newpath = iUtil.tranDir(newpath, clist);
		newpath = iUtil.setPath(newpath);
		newpath = iUtil.mkdirs(newpath);
	}
	try {
		for (int x = 1; x < st.length; x++) {
			if (st[x].length() > 1 && st[x].charAt(0) == '-') {
				char cp = st[x].charAt(1);
				String s = st[x].substring(2, st[x].length());
				switch (cp) {
					case 'a' :
						append = true;
						aname = s;
						break;
					case 'b' :
						splt = true;
						String[] elm = new eforward.util.Copy().arrayCopy(iUtil.stringToArray(s, ',', 3, true));
						if (elm[0].equals("c")) {
							cmb = true;
							hcmb = new Hashtable();
							vcmb = new Vector();
						}
						if (elm[0].equals("p")) {
							pspl = true;
							pseq = iUtil.setPath(elm[1]);
							pseq = iUtil.mkdirs(pseq);
							pelm = elm[2];
						}
						if (elm[0].equals("f")) {
							pseq = iUtil.setPath(elm[1]);
							pseq = iUtil.mkdirs(pseq);
							filespec = elm[2];
						}
						break;
					case 'c' :
						//copy = true;
						elm = iUtil.stringToArray(s, ',', 0, false);
						if (elm.length > 1 && elm[0].equals("f")) {
							copyf = true;
							mvcopy = elm[1];
						} else {
							copy = true;
							cpath = new String[elm.length];
							for (int ic = 0; ic < elm.length; ic++) {
								if (elm[ic].length() > 0) {
									String cpth = iUtil.tranDir(elm[ic], clist);
									cpth = iUtil.setPath(cpth);
									cpath[ic] = iUtil.mkdirs(cpth);
								}
							}
						}
						break;
					case 'd' :
						elm = iUtil.stringToArray(s, ',', 1, true);
						if (elm[0].equals("n")) {
							update = false;
						}
						break;
					case 'e' :
						seg = true;
						edfsegt = s;
						break;
					case 'f' :
						ext = s;
						break;
					case 'l' :
						if (s.length() > 0) {
							logfile = iUtil.setPath(s);
							iUtil.separatePath(logfile);
							String lp = iUtil.filePath;
							String lf = iUtil.fileName;
							logfile = iUtil.mkdirs(lp) + lf;
						} else {
							crlf = true;
						}
						break;
					case 'i' :
						isairs = true;
						irs = s;
						break;
					case 'm' :
						elm = iUtil.stringToArray(s, ',', 5, true);
						if (elm[0].equals("v")) {
							if (elm[1].length() > 0) {
								mvbin = iUtil.setPath(elm[1]);
								iUtil.separatePath(mvbin);
								String fd = iUtil.filePath;
								String fn = iUtil.fileName;
								fd = iUtil.tranDir(fd, clist);
								fd = iUtil.mkdirs(fd);
								mvbin = fd + fn;
							}
						} else
							if (elm[0].equals("e")) {
								if (elm[1].length() > 0) {
									mvedi = iUtil.setPath(elm[1]);
									iUtil.separatePath(mvedi);
									String fd = iUtil.filePath;
									String fn = iUtil.fileName;
									fd = iUtil.tranDir(fd, clist);
									fd = iUtil.mkdirs(fd);
									mvedi = fd + fn;
								}
							} else {
								// original way
								mapfile = iUtil.setPath(elm[0]);
							}
						if (elm[2].equals("e")) {
							ebc = true;
						}
						if (elm[3].length() > 0) {
							mapfile = iUtil.setPath(elm[3]);
						}
						if (elm[4].length() > 0 && (elm[4].charAt(0) == 't')) {
							trim = true;
							if (elm[4].length() > 1) {
								nlc = elm[4].substring(1, elm[4].length());
							}
						}
						break;
					case 'n' :
						nl = true;
						break;
					case 'p' :
						chid = s;
						seg = true;
						break;
					case 'q' :
						detail = true;
						break;
					case 'r' :
						elm = iUtil.stringToArray(s, ',', 2, true);
						if (elm[0].length() > 0) {
							rpc = elm[0];
							if ((iUtil.getInt(rpc)) > 0)
								rpc = new String(eMbg.setSegTerm(rpc));
						}
						if (elm[1].length() > 0)
							version = elm[1];
						break;
					case 's' :
						seg = true;
						segt = s;
						int t = s.indexOf("d"); // -s126d42,58
						if (t > 0) {
							segt = s.substring(0, t).trim();
							subs = s.substring(t + 1, s.length()).trim();
						}
						break;
					case 't' :
						elm = iUtil.stringToArray(s, ',', 0, false);
						if (elm.length > 1) {
							if (elm[0].equals("t")) {
								type = true;
							}
							testdir = iUtil.tranDir(elm[1], clist);
							testdir = iUtil.setPath(testdir);
							testdir = iUtil.mkdirs(testdir);
						} else {
							type = true;
						}
						break;
					case 'u' :
						unique = s;
						if (s.length() == 0)
							unique = qname + "_";
						break;
					case 'v' :
						elm = iUtil.stringToArray(s, ',', 1, true);
						if (elm.length > 2) {
							mailque = elm[0];
							emailhost = elm[1];
							email = elm[2];
							mQ = new eforward.util.MailQue(mailque);
						}
						break;
					case 'w' :
						allow = s;
						break;
					case 'x' :
						x12 = true;
						break;
					case 'z' :
						if (s.length() == 1 && s.equals("p"))
							unpack = false;
						break;
					default :
				}
			}
		}
		boolean cont = true;
		boolean rc = sndr.equals("CORVEDIA");
		boolean ra = (allow.length() > 0 && (sndr.equals(allow))) ? true : false;
		if (pi != null) {
			boolean z = (pi[0].equals("uz")) ? true : false;
			if (rc || ra || z) {
				String of = eMsg.getOriginalFilename();
				if (update)
					cont = iO.moveInFile(filename, of, qname, eMsg.getOrigin(), pi, unpack, z, eMsg.getLog(), iMt);
			}
		}
		if (cont) {
			if (logfile != null && logfile.length() > 0) {
				iUtil.separatePath(logfile);
				lG = new eforward.util.Log(iUtil.filePath, iUtil.fileName + "_mv");
			}
			if (lG != null) {
				lG.writeLog("st parm:" + iUtil.appnd(st, "^") + " " + qname + " " + rqname);
				lG.writeLog("infile:" + orgfile + " size:" + new File(filename).length() + " " + qname + " " + rqname);
			}
			if (mvbin.length() > 0) {
				tc = iMt.setTrans(mvbin);
				boolean m = true;
				byte[] top = eMbg.readTop(filename);
				eforward.util.FileTypes iFt = new eforward.util.FileTypes(filename, orgfile);
				int ityp = iFt.getTypeNumber();
				if (ityp > 9 && (ityp < 20)) { // Binary
					if (pi != null) {
						if (pi[0].equals("d")) {
							String[] cd = eMbg.getMatch(filename, orgfile, mvbin, "mvbin_type", "sender_dir_xml", pi[1], iMt);
							if (cd != null && (cd.length > 0) && (cd[0].length() > 0)) {
								String ppa = iUtil.tranDir(cd[0], clist);
								ppa = iUtil.setPath(ppa);
								newpath = iUtil.mkdirs(ppa);
								m = false;
							}
						}
					}
					if (m) {
						String[] cd = eMbg.getMatch(filename, orgfile, mvbin, "mvbin_type", "sender_dir_xml", rcvr, iMt);
						if (cd != null && (cd.length > 0) && (cd[0].length() > 0)) {
							String ppa = iUtil.tranDir(cd[0], clist);
							ppa = iUtil.setPath(ppa);
							newpath = iUtil.mkdirs(ppa);
							m = false;
						}
					}
					if (m) {
						String[] cd = eMbg.getMatch(filename, orgfile, mvbin, "mvbin_type", "sender_dir_xml", "", iMt);
						if (cd != null && (cd.length > 0) && (cd[0].length() > 0)) {
							String ppa = iUtil.tranDir(cd[0], clist);
							ppa = iUtil.setPath(ppa);
							newpath = iUtil.mkdirs(ppa);
							m = false;
						}
					}
				}
				if (m && pi != null) {
					if (pi[0].equals("d")) {
						//sndr is the sender iBox
						String[] dir = new eforward.util.Copy().arrayCopy(iMt.getTrans(tc, "mvbin", sndr, pi[1]));
						if (dir.length > 0) {
							newpath = (dir.length > 2) ? (iUtil.tranDir(dir[2], clist)) : newpath;
							newpath = iUtil.setPath(newpath);
							newpath = iUtil.mkdirs(newpath);
							m = false;
						} else {
							dir = iMt.getTrans(tc, "mvbin", pi[1]);
							if (dir.length > 0) {
								newpath = (dir.length > 1) ? (iUtil.tranDir(dir[1], clist)) : newpath;
								newpath = iUtil.setPath(newpath);
								newpath = iUtil.mkdirs(newpath);
								m = false;
							}
						}
					}
				}
				if (m) {
					String[] dir = new eforward.util.Copy().arrayCopy(iMt.getTrans(tc, "mvbin", sndr, rcvr));
					if (dir.length > 0) {
						newpath = (dir.length > 2) ? (iUtil.tranDir(dir[2], clist)) : newpath;
						newpath = iUtil.setPath(newpath);
						newpath = iUtil.mkdirs(newpath);
					} else {
						dir = iMt.getTrans(tc, "mvbin", sndr);
						if (dir.length > 1) {
							newpath = (dir.length > 0) ? (iUtil.tranDir(dir[1], clist)) : newpath;
							newpath = iUtil.setPath(newpath);
							newpath = iUtil.mkdirs(newpath);
						}
					}
				}
			}
			boolean pk = iO.isPack(filename);
			if (!unpack)
				pk = false;
			Vector vf = new Vector();
			String pre = "";
			if (!pk)
				vf.addElement(sname);
			else {
				pre = qname;
				vf = iO.getPack(spath, sname, spath + pre, orgfile, eMsg.getLog());
			}
			if (splt) {
				Vector nvf = new Vector();
				String name = inbfile;
				iUtil.separatePath(name);
				name = iUtil.fileName;
				for (int fx = 0; fx < vf.size(); fx++) {
					String fnm = (String) vf.elementAt(fx);
					String sfile = spath + pre + fnm;
					if (pk)
						name = fnm;
					if (pspl) {
						iUtil.separatePath(pseq);
						String seqd = iUtil.filePath;
						String seqn = iUtil.fileName;
						iO.initSeq(seqd, seqn, "");
						psplit(nvf, sfile, spath, name, pelm);
					} else {
						if (filespec.length() > 0) {
							iUtil.separatePath(pseq);
							String seqd = iUtil.filePath;
							String seqn = iUtil.fileName;
							iO.initSeq(seqd, seqn, "");
						}
						// splits multiple ISA... into individual ISA files.
						split(nvf, sfile, spath, orgfile, filespec);
					}
				}
				if (nvf.size() > 0) {
					pre = "";
					vf = nvf;
				}
			}
			if (newpath.length() > 0) {
				newpath = iUtil.tranDir(newpath, clist);
				newpath = iUtil.setPath(newpath);
				newpath = iUtil.mkdirs(newpath);
			}
			for (int fx = 0; fx < vf.size(); fx++) {
				String np = newpath;
				String fnm = (String) vf.elementAt(fx);
				String sfile = spath + pre + fnm;
				specname = null;
				if (lG != null)
					lG.writeLog("split file:" + pre + fnm + " size:" + new File(sfile).length() + " " + qname + " " + rqname);
				if (copy && !splt) {
					String f = orgfile;
					if (pk)
						f = fnm;
					for (int ic = 0; ic < cpath.length; ic++) {
						iUtil.separatePath(cpath[ic]);
						String fp = iUtil.filePath;
						String fn = iUtil.fileName;
						boolean cp = true;
						if (fn.length() > 0) {
							eforward.util.NameFilter nf = new eforward.util.NameFilter();
							if (nf.match(f, fn, false)) {
								//System.out.println("copy split A:" + sfile + ":" + fp + f);
								cp = false;
								iUtil.copyFile(sfile, fp + f, true, false, 0, 0); // append
							}
						}
						if (cp) {
							String nfi = fp + qname + "_" + f;
							String extn = "";
							if (new File(nfi).isFile())
								extn = "_" + Integer.toString(fx);
							//System.out.println("copy split B:" + sfile + ":" + nfi + extn);
							iUtil.copyFile(sfile, nfi + extn);
						}
					}
				}
				if (isairs) {
					Vector[] tv = eMbg.getFilesRecSt(sfile);
					if (tv.length > 0) {
						boolean isx12 = false;
						eforward.util.FileVect fv = new eforward.util.FileVect();
						fv.create(sfile + "_tempfv", 1);
						for (int tvx = 0; tvx < tv.length; tvx++) {
							Vector sv = (Vector) tv[tvx];
							if (sv.size() > 1) {
								for (int z = 0; z < sv.size();) {
									byte[] rec = new eforward.util.Copy().arrayCopy((byte[]) sv.elementAt(z++));
									byte[] rs = new eforward.util.Copy().arrayCopy((byte[]) sv.elementAt(z++));
									if (rec.length > 3 && (iAr.isEqual(rec, 0, 3, ISA, 0))) {
										isx12 = true;
										int len = rec.length;
										rec[len - 1] = (eMbg.setSegTerm(irs))[0];
									}
									fv.write(rec, 0, rec.length, 0);
									fv.write(rs, 0, rs.length, 0);
								}
							}
						}
						if (isx12) {
							iO.writeFileVectBytes(sfile + "_temp", fv, 0);
						}
						fv.clear();
						if (isx12) {
							iUtil.rmFile(new File(sfile));
							iUtil.renameFile(new File(sfile + "_temp"), sfile);
						}
					}
				}
				if (seg) {
					if (segt.length() == 0) {
						byte[] top = eMbg.readTop(sfile);
						segt = eMbg.getSegTerm(top);
					}
					if (edfsegt.length() == 0) {
						edfsegt = "39";
					}
					byte[] rs = eMbg.setSegTerm(segt);
					byte[] edfrs = eMbg.setSegTerm(edfsegt);
					byte[] sb = eMbg.setSegTerm(subs);
					String tfil = sfile + "_temp";
					String[] stringa = {sfile, tfil, chid, version, rpc};
					byte[][] byteaa = {rs, edfrs, sb};
					boolean[] r = eMbg.setFileSt(stringa, byteaa, x12, null);
					if (testdir.length() > 0 && r[1]) {
						np = testdir;
					}
					File tf = new File(tfil);
					if (tf.exists() && tf.length() > 0) {
						iUtil.rmFile(new File(sfile));
						iUtil.renameFile(tf, sfile);
					} else {
						iUtil.rmFile(tf);
					}
				}
				if (copy && splt) {
					String f = orgfile;
					if (splt)
						f = pre + fnm;
					if (pk)
						f = fnm;
					for (int ic = 0; ic < cpath.length; ic++) {
						iUtil.separatePath(cpath[ic]);
						String fp = iUtil.filePath;
						String fn = iUtil.fileName;
						if (fn.length() > 0) {
							eforward.util.NameFilter nf = new eforward.util.NameFilter();
							if (nf.match(f, fn, false)) {
								iUtil.copyFile(sfile, fp + f, true, false, 0, 0); // append
							}
						} else {
							String nfi = fp + qname + "_" + f;
							if (splt)
								nfi = fp + f;
							String extn = "";
							if (new File(nfi).isFile())
								extn = "_" + Integer.toString(fx);
							iUtil.copyFile(sfile, nfi + extn);
						}
					}
				}
				if (type) {
					Vector[] vx = eMbg.getEdiFiles(sfile);
					int vc = vx[1].size() / 2;
					boolean d = true;
					if (vc > 0) {
						byte[] dat = new eforward.util.Copy().arrayCopy(eMbg.getEdiFiles(sfile, vx, 1));
						Vector[] v = eMbg.getEdiRecs(dat, false, true);
						if (v[3].size() > 1) {
							unique = "st" + (String) v[3].elementAt(1) + "_" + unique;
							d = false;
						}
					}
					if (d)
						unique = "st000" + "_" + unique;
				}
				String name = inbfile;
				if (pk || splt)
					name = fnm;
				if (ext.length() > 0) {
					name = setExt(name, unique, ext);
					unique = "";
				}
				if (nl) {
					String tfil = sfile + "_tmpn";
					eMbg.setFileStNL(sfile, tfil, (byte) 13);
					File tf = new File(tfil);
					if (tf.exists() && tf.length() > 0) {
						iUtil.rmFile(new File(sfile));
						iUtil.renameFile(tf, sfile);
					} else {
						iUtil.rmFile(tf);
					}
				}
				if (crlf) {
					String tfil = sfile + "_tmpn";
					Vector v = new Vector();
					iO.readInputFile(sfile, v);
					if (v.size() > 0) {
						if (iO.writeInputFile(tfil, v)) {
							File tf = new File(tfil);
							if (tf.exists() && tf.length() > 0) {
								iUtil.rmFile(new File(sfile));
								iUtil.renameFile(tf, sfile);
							} else {
								iUtil.rmFile(tf);
							}
						}
					}
				}
				if (mvedi.length() > 0) {
					String[] grp = new eforward.util.Copy().arrayCopy(eMbg.getMatch(sfile, orgfile, mvedi, "mvedi", "mvxml", orig, iMt));
					if (grp != null && grp.length > 2 && (grp[2].length() > 0)) {
						np = iUtil.tranDir(grp[2], clist);
						np = iUtil.setPath(np);
						np = iUtil.mkdirs(np);
						if (grp[7].length() > 0)
							specname = grp[7];
						if (grp[8].length() > 0)
							orig = grp[8];
						if (grp[9].length() > 0)
							dest = grp[9];
					}
				}
				if (trim) {
					eforward.util.Io iO = new eforward.util.Io();
					eforward.util.FileVect fv = new eforward.util.FileVect();
					fv.open(sfile + "_tmp", 3);
					iO.readFile(sfile, fv, 0, 0);
					if (fv.size(0) > 0) {
						String n = fv.readString(0, 1);
						if (n.length() > 0) {
							byte[] eol = n.getBytes();
							if (nlc.length() > 0) {
								eol = eMbg.setSegTerm(nlc);
							}
							for (int fvx = 0; fvx < fv.size(0); fvx++) {
								String dat = fv.readString(fvx, 0).trim();
								byte[] line = iAr.append(dat.getBytes(), eol);
								fv.write(line, 0, line.length, 2);
							}
							if (fv.size(2) > 0)
								iO.writeFileVectBytes(sfile, fv, 2);
						}
					}
					fv.clear();
				}
				if (ebc) {
					eforward.util.Ebcdic eBcd = new eforward.util.Ebcdic(iUtil);
					String tfil = sfile + "_tmpn";
					if (mapfile.length() > 0)
						eBcd.toEbcdic(sfile, tfil, mapfile);
					else {
						eBcd.toEbcdic(sfile, tfil);
					}
					iUtil.rmFile(new File(sfile));
					iUtil.renameFile(new File(tfil), sfile);
				}
				if (mQ != null) {
					String sub = "SeIM " + sndr + " " + rcvr + " " + qname;
					mQ.sendMail(sfile, email, emailhost, sub, new String[0], name, false);
				}
				if (append) {
					if (aname.length() == 0)
						aname = orgfile;
					iUtil.separatePath(np);
					String pnm = iUtil.filePath + aname;
					iUtil.appendFile(sfile, pnm);
					if (lG != null)
						lG.writeLog("append:" + aname + " size:" + new File(pnm).length() + " " + qname + " " + rqname);
				} else {
					if (cmb) {
						int ix = name.lastIndexOf("_");
						if (ix < 0)
							ix = name.length();
						name = name.substring(0, ix);
						Integer i = (Integer) hcmb.get(name + np);
						if (i == null) {
							i = new Integer(++icmb);
							hcmb.put(name + np, i);
						}
						String ns = name + "_0" + i.toString();
						String n = spath + ns;
						String[] c = {n, name, np};
						iUtil.appendFile(sfile, n);
						if (lG != null)
							lG.writeLog("combine:" + ns + " size:" + new File(n).length() + " " + qname + " " + rqname);
						if (vcmb.size() < icmb)
							vcmb.addElement(new eforward.util.Copy().arrayCopy(c));
					} else {
						if (lG != null)
							lG.writeLog("mvf:" + name + " size:" + new File(sfile).length() + " " + qname + " " + rqname);
						if (detail) {
							String[] d = {inbfile, orgfile, sndr, rcvr, qname, rqname};
							dtl = iUtil.setCsv(d);
						}
						if (copyf) {
							String[] dir = new eforward.util.Copy().arrayCopy(eMbg.getMatch(sfile, orgfile, mvcopy, "copyf", "mvxml", orig, iMt));
							if (dir.length > 0) {
								String[] dirs = iUtil.stringToArray(dir[2], '!', 0, false);
								for (int ic = 0; ic < dirs.length; ic++) {
									if (dirs[ic].length() > 0) {
										String cpth = dirs[ic];
										cpth = iUtil.setPath(cpth);
										cpth = iUtil.mkdirs(cpth);
										iUtil.separatePath(iUtil.mkpath(name));
										String cname = iUtil.fileName;
										if (specname != null) {
											cname = specname;
										}
										iUtil.copyFile(sfile, cpth + cname);
									}
								}
							}
						}
						if (specname != null) {
							mvf(sfile, specname, np, unique, dtl);
						} else {
							mvf(sfile, name, np, unique, dtl);
						}
					}
				}
			}
			if (cmb) {
				for (int x = 0; x < vcmb.size(); x++) {
					String[] c = new eforward.util.Copy().arrayCopy((String[]) vcmb.elementAt(x));
					if (lG != null)
						lG.writeLog("mvc:" + c[1] + " size:" + new File(c[0]).length() + " " + qname + " " + rqname);
					if (detail) {
						String[] d = {inbfile, orgfile, sndr, rcvr, qname, rqname};
						dtl = iUtil.setCsv(d);
					}
					mvf(c[0], c[1], c[2], unique, dtl);
				}
			}
			if (pk)
				iUtil.rmFile(new File(filename));
		}
	} catch (Exception e) {
		String err = e.toString();
		if (lG != null) {
			lG.writeLog("mv:" + filename + ":" + qname + ":" + rqname + ":" + err);
		} else {
			tX.text("mv:" + filename + ":" + orgfile + ":" + err + ":" + rqname + ":" + new java.util.Date().toString(), true, null);
		}
	}
	if (mQ != null)
		mQ.stopQue();
	if (lG != null)
		lG.close();
	if (tc > -1) {
		iMt.closeTrans(tc);
	}
	if (runmt) {
		iMt.end();
	}
	return;
}
/**
 * Insert the method's description here.
 * Creation date: (04/11/02 9:27:35 am)
 * @param qfile java.lang.String
 * @param filename java.lang.String
 * @param newpath java.lang.String
 * @param unique java.lang.String
 * @param dtl java.lang.String
 */
public void mvf(String qfile, String filename, String newpath, String unique, String dtl) {
	iUtil.separatePath(iUtil.mkpath(filename));
	String name = iUtil.fileName;
	//String path = iUtil.filePath;
	iUtil.separatePath(iUtil.mkpath(newpath));
	String newname = iUtil.filePath;
	newname = newname + unique + name;
	//System.out.println("Mv.mvf renameFile:" + qfile + ":" + newname);
	if (dtl.length() > 0) {
		File f = new File(filename + "_detail");
		eforward.util.Base64.writeBytes(f, (dtl + "\r\n").getBytes());
		iUtil.renameFile(f, newname + "_detail");
	}
	iUtil.renameFile(new File(qfile), newname);
	return;
}
/**
 * Insert the method's description here.
 * Creation date: (11-03-01 9:17:44 am)
 * @return byte[][]
 * @param file java.lang.String
 */
public byte[][] pshdr(String file) {
	int off = 0, loff = 0;
	File f = new File(file);
	int len = (int) (f.length());
	Vector sub = new Vector();
	sub.addElement(new Integer(loff));
	byte[] dat = eforward.util.Base64.readBytes(f);
	while (off > -1) {
		off = iAr.indexOf(dat, nHDR, loff + 1);
		if (off > -1) {
			sub.addElement(new Integer(++off));
			sub.addElement(new Integer(off));
			loff = off;
		}
	}
	sub.addElement(new Integer(len));
	byte[][] hdr = new byte[sub.size() / 2][];
	int y = 0;
	for (int x = 0; x < sub.size();) {
		off = ((Integer) sub.elementAt(x++)).intValue();
		loff = ((Integer) sub.elementAt(x++)).intValue();
		hdr[y++] = iAr.append(iUtil.stripByte(iAr.subarray(dat, off, loff), DEL), DEL);
	}
	return new eforward.util.Copy().arrayCopy(hdr);
}
/**
 * Insert the method's description here.
 * Creation date: (10-02-26 9:07:24 am)
 * @param v java.util.Vector
 * @param file java.lang.String
 * @param path java.lang.String
 * @param name java.lang.String
 * @param elem java.lang.String
 */
public void psplit(Vector v, String file, String path, String name, String elem) {
	String[] elm = iUtil.stringToArray(elem, '/', 1, false);
	byte[] iss = new byte[0];
	byte[] isr = new byte[0];
	byte[] gss = new byte[0];
	byte[] gsr = new byte[0];
	byte[] typ = new byte[0];
	String zro = "";
	String ext = "";
	String sep = "_";
	for (int k = 0; k < elm.length; k++) {
		if (elm[k].charAt(0) == 'Z') {
			int c = iUtil.getInt(elm[k]);
			zro = iUtil.padInt("", c);
		}
		if (elm[k].charAt(0) == 'X') {
			ext = elm[k].substring(1, elm[k].length());
		}
		if (elm[k].charAt(0) == 'S') {
			sep = elm[k].substring(1, 2);
		}
	}
	byte[] top = new eforward.util.Copy().arrayCopy(eMbg.readTop(file));
	if (iAr.isSubEqual(HDR, top)) {
		byte[][] hdr = pshdr(file);
		String fnm = "";
		for (int x = 0; x < hdr.length; x++) {
			if (x == 0) {
				byte[] del = new eforward.util.Copy().arrayCopy(hdr[x], 3, 1);
				byte[][] st = iAr.arrayToArrays(hdr[x], del[0], 20, true);
				gss = iUtil.stripByte(((name + "        ").substring(3, 8)).getBytes(), NUM);
				if (gss.length > 4 && gss[0] == I)
					gss = iAr.subarray(gss, 1, gss.length);
				gsr = new eforward.util.Copy().arrayCopy(st[1]);
				if (gsr.length > 4 && gsr[0] == I)
					gsr = iAr.subarray(gsr, 1, gsr.length);
				typ = (name.substring(0, 3)).getBytes();
				//
				String nm = iO.setName("tmp");
				String date = eMbg.getDate("yyMMdd") + nm.substring(1, 8);
				//
				for (int k = 0; k < elm.length; k++) {
					if (elm[k].charAt(0) == 'S' || elm[k].charAt(0) == 'X');
					else {
						if (fnm.length() > 0)
							fnm = fnm + sep;
						if (elm[k].equals("IS") || elm[k].equals("GS"))
							fnm = fnm + new String(gss);
						if (elm[k].equals("IR") || elm[k].equals("GR"))
							fnm = fnm + new String(gsr);
						if (elm[k].equals("T"))
							fnm = fnm + new String(typ);
						if (elm[k].charAt(0) == 'Z') {
							if (zro.length() == 0)
								fnm = fnm + nm.substring(1, 8);
							else {
								fnm = fnm + zro;
							}
						}
					}
				}
				if (ext.length() > 0)
					fnm = fnm + "." + ext;
				else {
					fnm = fnm + "." + date;
				}
				v.addElement(fnm);
			}
			eforward.util.Base64.writeBytes(new File(path + fnm + "_temp"), hdr[x]);
			iUtil.appendFile(path + fnm + "_temp", path + fnm);
		}
		iUtil.rmFile(new File(file));
	} else {
		Vector[] vx = eMbg.getEdiFiles(file);
		int vc = vx[1].size() / 2;
		int q = 0;
		for (int w = 0; w < vc;) {
			byte[] dat = new eforward.util.Copy().arrayCopy(eMbg.getEdiFiles(file, vx, ++w));
			byte[] isa = new eforward.util.Copy().arrayCopy(dat);
			if (iAr.isEqual(isa, 0, 3, ISA, 0)) {
				String[] p = new eforward.util.Copy().arrayCopy(eMbg.getPartnerType(isa));
				iss = new eforward.util.Copy().arrayCopy(p[1].getBytes());
				isr = new eforward.util.Copy().arrayCopy(p[3].getBytes());
				typ = new eforward.util.Copy().arrayCopy(p[10].getBytes());
			}
			Vector[] vf = eMbg.getFilesRecSt(dat);
			Vector sv = (Vector) vf[0];
			byte[] gs = new byte[0];
			if (sv.size() > 5) {
				gs = new eforward.util.Copy().arrayCopy(iAr.append((byte[]) sv.elementAt(2), (byte[]) sv.elementAt(3), (byte[]) sv.elementAt(4), (byte[]) sv.elementAt(5)));
			} else {
				gs = new eforward.util.Copy().arrayCopy(new eforward.util.Copy().arrayCopy(dat));
			}
			if (iAr.isEqual(gs, 0, 2, GS, 0)) {
				String[] p = new eforward.util.Copy().arrayCopy(eMbg.getPartnerType(gs));
				gss = new eforward.util.Copy().arrayCopy(p[1].getBytes());
				gsr = new eforward.util.Copy().arrayCopy(p[3].getBytes());
				typ = new eforward.util.Copy().arrayCopy(p[10].getBytes());
			}
			if (gss.length == 0)
				gss = new eforward.util.Copy().arrayCopy(iss);
			if (gsr.length == 0)
				gsr = new eforward.util.Copy().arrayCopy(isr);
			if (iss.length == 0)
				iss = new eforward.util.Copy().arrayCopy(gss);
			if (isr.length == 0)
				isr = new eforward.util.Copy().arrayCopy(gsr);
			//
			String nm = iO.setName("tmp");
			String date = eMbg.getDate("yyMMdd") + nm.substring(1, 8);
			//
			String fnm = "";
			for (int k = 0; k < elm.length; k++) {
				if (elm[k].charAt(0) == 'S' || elm[k].charAt(0) == 'X');
				else {
					if (fnm.length() > 0)
						fnm = fnm + sep;
					if (elm[k].equals("IS"))
						fnm = fnm + new String(iss);
					if (elm[k].equals("IR"))
						fnm = fnm + new String(isr);
					if (elm[k].equals("GS"))
						fnm = fnm + new String(gss);
					if (elm[k].equals("GR"))
						fnm = fnm + new String(gsr);
					if (elm[k].equals("T"))
						fnm = fnm + new String(typ);
					if (elm[k].charAt(0) == 'Z') {
						if (zro.length() == 0)
							fnm = fnm + nm.substring(1, 8);
						else {
							fnm = fnm + zro;
						}
					}
				}
			}
			if (ext.length() > 0)
				fnm = fnm + "." + ext;
			else {
				fnm = fnm + "." + date;
			}
			//
			eforward.util.Base64.writeBytes(new File(path + fnm), dat);
			v.addElement(fnm);
		}
		if (v.size() == 0) {
			iUtil.separatePath(file);
			String fnm = iUtil.fileName + "_1";
			iUtil.renameFile(new File(file), path + fnm);
			v.addElement(fnm);
		} else {
			iUtil.rmFile(new File(file));
		}
	}
	return;
}
/**
 * Insert the method's description here.
 * Creation date: (04/14/03 8:48:36 pm)
 * @return java.lang.String
 * @param name java.lang.String
 * @param unique java.lang.String
 * @param ext java.lang.String
 */
public String setExt(String name, String unique, String ext) {
	iUtil.separatePath(name);
	String n = iUtil.fileName.replace('.', '_');
	if (unique.length() > 0)
		n = iUtil.stripChar(unique, '_');
	return iUtil.filePath + n + "." + ext;
}
/**
 * Insert the method's description here.
 * Creation date: (10-02-26 9:07:24 am)
 * @param v java.util.Vector
 * @param file java.lang.String
 * @param path java.lang.String
 * @param name java.lang.String
 * @param filespec java.lang.String
 */
public void split(Vector v, String file, String path, String name, String filespec) {
	Vector[] vx = eMbg.getEdiFiles(file);
	int vc = vx[1].size() / 2;
	int q = 0;
	for (int w = 0; w < vc;) {
		byte[] dat = new eforward.util.Copy().arrayCopy(eMbg.getEdiFiles(file, vx, ++w));
		//String fnm = name + "_" + Integer.toString(w);
		String fnm = name + "_" + iUtil.padInt(w, 3);
		if (filespec.length() > 0) {
			String tnm = file + "_unq";
			eforward.util.Base64.writeBytes(new File(tnm), dat);
			fnm = iO.setUniqueName(tnm, name, filespec);
			iUtil.rmFile(new File(tnm));
		}
		eforward.util.Base64.writeBytes(new File(path + fnm), dat);
		v.addElement(fnm);
	}
	if (v.size() == 0) {
		iUtil.separatePath(file);
		//String fnm = iUtil.fileName + "_1";
		String fnm = iUtil.fileName + "_001";
		iUtil.renameFile(new File(file), path + fnm);
		v.addElement(fnm);
	} else {
		iUtil.rmFile(new File(file));
	}
	return;
}
}
