package efclient.bin;

import java.io.*;
import java.util.*;
/**
 * Switches:
 * -b{sequence_dir_base_path[,sequence_name("properties")]}
 * -d{directory listing output file(option 1)}
 * -f{read file names[,sequence_file]}
 * -i[delay]
 * -j[archive directory]
 * -k{output path}
 * -l{logfile}
 * -n{file_extension(option 2)}
 * -o(use original name)
 * -p{name prefix}
 * -t{(use type)[include sender and or receiver(s/r/b)](option 3)}
 * -s{name separator character}
 * -u(use sequence number)
 * -v(verbose)
 * -w{filespec} see below
 * -x{trans file("UniqueNameSpec",sender,receiver = filespec}
 *
 * 0) prefix
 * 1) date spec
 * 2) separator char
 * 3) file extension or ORIG=use orignial
 * 4) ORIG=use original file name
 * 5) X=replace period with underscore
 * 6-13) order name parts using:
 * P=prefix,D=date,C=sequence,F=suffix,O=original name,G=gs_control_no
 * T=type,S=sender,R=receiver,E=control_no,M=message_date,L=lowercase
 * parts [0]= sndr
 * parts [1]= rcvr
 * parts [2]= ctrl
 * parts [3]= type
 * parts [4]= mdate
 * parts [5]= st_count 
 * example:
 * name="this.is.it" filespec="b*yyyyMMdd*-*ORIG*ORIG*X"
 * b-this_is_it-20120922-0000025.it
 * name="RYDER_01211330.TST" filespec="EDI_SCAC_210*yyyyMMddHHmmss*_*.edi***P*D*F"
 * EDI_SCAC_210_20120927114801.edi
 * example2:
 * String file = "\\tmp\\rf239998107_17772194b.MSG";
 * String outdir = "\\Eforward\\send\\";
 * String filespec = "*yyyyMMddHHmmss*_*.edi***S*R*E*T*D*F";
 * String[] cmd = {"-f" + file, "-k" + outdir, "-i0", "-w" + filespec};
 * eforward.util.Proc iProc = new eforward.util.Proc();
 * iProc.runJ("efclient.bin.UniqueName", cmd);
 * VITUSB_MAEU_26939_322_20130821182247.edi
 *
 * ex2:    *MMddyyHHmmss*_*.edi***D*C*S*T*F
 *
 * Corvedia Inc. - 9/4/2001
 * @author: Greg Pringle
 */
public class UniqueName {
	eforward.util.Mt iMt = null;
	boolean runmt = false;
	int thc = 400;
	boolean verbose = false;
	boolean orig = false;
	boolean unq = false;
	boolean dir = false;
	boolean unk = false;
	boolean type = false;
	boolean sndr = false;
	boolean rcvr = false;
	boolean lck = true;
	boolean counts = false;
	String pseq = "unique";
	String[] base = null;
	String fext = "";
	String arc = "";
	String pre = "";
	String spchar = "_";
	String split = null;
	String splitp = null;
	String file = null;
	String path = null;
	String logfile = null;
	String dirfile = null;
	String filespec = "";
	String dirspec = "";
	String spectran = "";
	int sec = 3;
	Hashtable hc = new Hashtable();
	eforward.util.Util iUtil = new eforward.util.Util();
	eforward.util.Txt tX = new eforward.util.Txt();
	eforward.util.Io iO = new eforward.util.Io();
	eforward.util.Plock iP = new eforward.util.Plock();
	long[] k4 = new long[2];
	eforward.util.EdiMbg eMbg = new eforward.util.EdiMbg(iUtil);
/**
 * UniqueName constructor.
 */
public UniqueName() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (03/10/17 9:01:36 pm)
 * @param args java.lang.String[]
 * @param iMt eforward.util.Mt
 */
public UniqueName(String[] args, eforward.util.Mt iMt) {
	this.iMt = iMt;
	if (!setParms(args))
		return;
	if (dir) {
		writeDir();
	} else {
		makeUnique();
	}
}
/**
 * Creation date: (02/01/01 11:35:20 am)
 * @param args java.lang.String[]
 */
public static void main(String[] args) {
	efclient.bin.UniqueName u = new efclient.bin.UniqueName();
	if (!u.setParms(args))
		return;
	if (u.dir) {
		u.writeDir();
	} else {
		u.makeUnique();
	}
}
/**
 * Creation date: (06/13/01 1:39:16 pm)
 */
public void makeUnique() {
	//System.out.println("makeUnique");
	if (lck)
		iP.getVlock(4, k4);
	if (base == null && (split != null)) {
		iUtil.mkdirs(splitp + "properties");
		base = iO.initSeq(splitp, split, "properties");
	}
	if (base == null) {
		String ldir = iUtil.mkparent(file);
		iUtil.mkdirs(ldir + "properties");
		base = iO.initSeq(ldir, pseq + ".seq", "properties");
	}
	iUtil.separatePath(file);
	String fname = iUtil.fileName;
	String fpath = iUtil.filePath;
	if (sec == 0)
		iO.clearEmpty(fpath, fname, null);
	String[] exc = {"clearf.lst", "_idx", "_vct", "_detail"};
	//Vector f = new Vector();
	eforward.util.FileVect fv = new eforward.util.FileVect();
	fv.open(fpath + "z" + Long.toString(System.currentTimeMillis()), 1);
	eMbg.sortCtrl(fpath, fname, exc, 2200, fv);
	if (verbose)
		tX.text("Number of Files (Unique):" + fv.size(0) + " path:" + fpath + " name:" + fname, verbose, null);
	boolean log = false;
	eforward.util.Rfile rfi = new eforward.util.Rfile();
	RandomAccessFile logIn = null;
	String crlf = iUtil.getCrnl();
	String name = "";
	try {
		if (logfile.length() > 0) {
			String date = new eforward.util.EdiMbg(iUtil).getDate("yyMMdd");
			name = logfile + spchar + date + spchar + "log";
			logIn = rfi.getRaf(name, true);
			log = true;
		}
	} catch (Exception ee) {
	}
	boolean frdy = false;
	//eforward.util.Trans iT = null;
	int tc = -1;
	for (int i = 0; i < fv.size(0); i++) {
		String ef = (String) fv.readString(i, 0);
		file = fpath + ef;
		if (verbose)
			tX.text("in file:" + file, verbose, null);
		String ext = "";
		String edir = "";
		if (!frdy && iUtil.isFileReady(file))
			frdy = true;
		if (frdy && iUtil.isFileReady(file, sec)) {
			if (filespec.length() > 0 || (spectran.length() > 0)) {
				if (verbose)
					tX.text("filespec:" + filespec, verbose, null);
				if (spectran.length() > 0) {
					filespec = "***ORIG*ORIG**O";
					if (new File(spectran).isFile()) {
						//if (iT == null)
						//iT = new eforward.util.Trans(spectran);
						if (tc < 0) {
							tc = iMt.setTrans(spectran);
						}
						try {
							Vector[] vx = eMbg.getEdiFiles(file);
							int vc = vx[1].size() / 2;
							boolean d = true;
							if (vc > 0) {
								byte[] dat = new eforward.util.Copy().arrayCopy(eMbg.getEdiFiles(file, vx, 1));
								Vector[] v = eMbg.getEdiRecs(dat, false, true);
								String[] partner = new eforward.util.Copy().arrayCopy(eMbg.getPartner(dat, false, false));
								if (v[3].size() > 1) {
									String sndr = partner[1];
									String rcvr = partner[3];
									String type = (String) v[3].elementAt(1);
									//String[] spc = iT.getTrans("UnqNameSpec", sndr + "_" + rcvr, type);
									String[] spc = iMt.getTrans(tc, "UnqNameSpec", sndr + "_" + rcvr, type);
									if (spc.length > 0) {
										filespec = spc[2];
									}
								}
							}
						} catch (Exception e) {
						}
						iMt.closeTrans(tc);
						tc = -1;
					}
				}
				String[] parts = iUtil.initStr(6);
				ext = iO.setUniqueName(file, ef, filespec, parts);
				if (counts) {
					// parts [0]= sndr
					// parts [1]= rcvr
					// parts [2]= ctrl
					// parts [3]= type
					// parts [4]= mdate
					// parts [5]= st_count 
					String key = parts[0] + "_" + parts[1] + "_" + parts[3];
					long[] fc = new eforward.util.Copy().arrayCopy((long[]) hc.get(key));
					if (fc.length == 0) {
						fc = new long[2];
						fc[0] = 0;
						fc[1] = 0;
					}
					fc[0] = fc[0] + iUtil.getInt(parts[5]);
					fc[1] = fc[1] + new File(file).length();
					hc.put(key, new eforward.util.Copy().arrayCopy(fc));
				}
				if (dirspec.length() > 0) {
					edir = iO.setUniqueName(file, ef, dirspec);
					edir = iUtil.setPath(edir + "/");
					iUtil.mkdirs(path + edir);
				}
				if (verbose)
					tX.text("filespec ext:" + ext, verbose, null);
			} else {
				if (type) {
					iUtil.separatePath(path);
					path = iUtil.filePath;
					Vector[] vx = eMbg.getEdiFiles(file);
					int vc = vx[1].size() / 2;
					boolean d = true;
					String st = "st";
					if (pre.length() > 0)
						st = pre;
					String end = ef;
					if (!orig)
						end = iO.getSeq(2, 7);
					if (vc > 0) {
						byte[] dat = new eforward.util.Copy().arrayCopy(eMbg.getEdiFiles(file, vx, 1));
						Vector[] v = eMbg.getEdiRecs(dat, false, true);
						String[] partner = new eforward.util.Copy().arrayCopy(eMbg.getPartner(dat, false, false));
						if (v[3].size() > 1) {
							String prt = "";
							if (sndr)
								prt = prt + spchar + partner[1];
							if (rcvr)
								prt = prt + spchar + partner[3];
							ext = pre + (String) v[3].elementAt(1) + prt + spchar + end + fext;
							d = false;
						}
					}
					if (d)
						ext = pre + "000" + spchar + end + fext;
				} else
					if (unk) {
						ext = iO.setName(fext, 1, "u", 7);
					} else {
						if (orig) {
							String t = ef;
							if (unq) {
								ext = iO.getSeq(2, 7);
								t = ext + t;
							}
							ext = spchar + t;
						}
					}
			}
			if (log) {
				try {
					logIn.seek(logIn.length());
					logIn.writeBytes(file + ":" + path + ext + crlf);
				} catch (Exception ee) {
				}
			}
			if (arc.length() > 0) {
				iUtil.copyFile(file, arc + ef);
			}
			if (verbose)
				tX.text("rename file:" + file + " : " + path + ext, verbose, null);
			File df = new File(file + "_detail");
			if (df.isFile()) {
				iUtil.renameFile(df, path + ext + "_detail");
			}
			iUtil.moveFile(file, path + edir + ext);
			try {
				if (i % 100 == 0)
					Thread.sleep(20);
			} catch (Exception e) {
			}
		}
	}
	if (lck)
		iP.rmVlock(4, k4);
	if (logIn != null)
		rfi.closeRfile(logIn, name);
	fv.clear();
	if (counts) {
		String[][] dat = new String[hc.size()][];
		int y = 0;
		for (Enumeration z = hc.keys(); z.hasMoreElements();) {
			String key = (String) z.nextElement();
			long[] fc = new eforward.util.Copy().arrayCopy((long[]) hc.get(key));
			String[] k = new String[5];
			String[] s = iUtil.stringToArray(key, '_', 3, true);
			k[0] = s[0];
			k[1] = s[1];
			k[2] = s[2];
			k[3] = Long.toString(fc[0]);
			k[4] = Long.toString(fc[1]);
			dat[y++] = new eforward.util.Copy().arrayCopy(k);
		}
		hc.clear();
		int[] sort = {0, 1, 2};
		int[] out = new int[dat.length];
		new eforward.util.Sdat().sortArrayM(dat, sort, null, out);
		for (int x = 0; x < out.length; x++) {
			String[] s = new eforward.util.Copy().arrayCopy(dat[out[x]]);
			tX.text(iUtil.padStr(s[0], 17) + iUtil.padStr(s[1], 17) + iUtil.padStr(s[2], 5) + iUtil.padStrRgt(s[3], 8) + iUtil.padStrRgt(s[4], 10), true, null);
		}
	}
}
/**
 * Creation date: (02/01/01 11:37:05 am)
 * @return boolean
 * @param args java.lang.String[]
 */
public boolean setParms(String[] args) {
	eforward.util.Parameters p = new eforward.util.Parameters(iUtil);
	java.util.Vector v = p.getParms(args);
	boolean ok = false;
	String bs = "";
	String bsdir = "properties";
	dir = false;
	file = "";
	path = "";
	logfile = "";
	dirfile = "";
	filespec = "";
	dirspec = "";
	spectran = "";
	String err = "usage: -f{file} -k{new path/root_name} [-i[delay]] [-o(use original)]\n";
	err = err + "[-u(unique)] [-n[unique only](extension)] [-l{logfile}] [-d{file(list file)}] -v";
	if (v == null) {
		tX.text(err, true, null);
		return ok;
	}
	if (iMt == null) {
		iMt = new eforward.util.Mt(thc);
		runmt = true;
	}
	String alias_sub = "";
	String aliasd = "";
	String[][] clist = new String[1][];
	clist[0] = new String[0];
	for (int x = 0; x < v.size();) {
		char cp = ((Character) v.elementAt(x++)).charValue();
		String s = (String) v.elementAt(x++);
		switch (cp) {
			case 'A' :
				String[] elm = iUtil.stringToArray(s, ',', 2, true);
				alias_sub = elm[0];
				aliasd = elm[1];
				if (aliasd.length() > 0 && new File(aliasd).isFile()) {
					int tc = iMt.setTrans(aliasd);
					String clst = iMt.getTransLstC(tc, "alias", alias_sub);
					clist[0] = new eforward.util.Copy().arrayCopy(iUtil.setClistc(clst));
					iMt.closeTrans(tc);
				}
				x = v.size();
				break;
			default :
		}
	}
	for (int x = 0; x < v.size();) {
		char cp = ((Character) v.elementAt(x++)).charValue();
		String s = (String) v.elementAt(x++);
		switch (cp) {
			case 'A' :
				break;
			case 'b' :
				//bs = s;
				String[] elm = iUtil.stringToArray(s, ',', 3, true);
				elm[0] = iUtil.setPath(elm[0]);
				bs = iUtil.mkdirs(elm[0]);
				if (elm[1].length() > 0) {
					bsdir = elm[1];
					bsdir = iUtil.setPath(bsdir);
					iUtil.mkdirs(bs + bsdir);
				} else {
					iUtil.mkdirs(bs + "properties");
				}
				if (elm[2].length() > 0) {
					pseq = elm[2];
					lck = false;
				}
				break;
			case 'c' :
				counts = true;
				break;
			case 'd' :
				dirfile = iUtil.setPath(s);
				iUtil.separatePath(dirfile);
				String lp = iUtil.filePath;
				String lf = iUtil.fileName;
				if (lp.length() > 0) {
					lp = iUtil.tranDir(lp, clist);
					dirfile = iUtil.mkdirs(lp) + lf;
				}
				dir = true;
				break;
			case 'f' :
				file = s;
				int t = s.indexOf(",");
				if (t > 0) {
					file = s.substring(0, t).trim();
					split = s.substring(t + 1, s.length()).trim();
				}
				file = iUtil.setPath(file);
				iUtil.separatePath(file);
				lp = iUtil.filePath;
				lf = iUtil.fileName;
				if (lp.length() > 0) {
					lp = iUtil.tranDir(lp, clist);
					file = iUtil.mkdirs(lp) + lf;
				}
				break;
			case 'i' :
				sec = iUtil.getInt(s);
				break;
			case 'j' :
				//arc = iUtil.setPath(s);
				arc = iUtil.tranDir(s, clist);
				arc = iUtil.setPath(arc);
				arc = iUtil.mkdirs(arc);
				break;
			case 'k' :
				//path = iUtil.setPath(s);
				path = iUtil.tranDir(s, clist);
				path = iUtil.setPath(path);
				path = iUtil.mkdirs(path);
				break;
			case 'l' :
				logfile = iUtil.setPath(s);
				iUtil.separatePath(logfile);
				lp = iUtil.filePath;
				lf = iUtil.fileName;
				if (lp.length() > 0) {
					logfile = iUtil.mkdirs(lp) + lf;
				}
				break;
			case 'n' :
				fext = s;
				unk = true;
				break;
			case 'o' :
				orig = true;
				break;
			case 'p' :
				pre = s;
				break;
			case 't' :
				elm = iUtil.stringToArray(s, ',', 2, true);
				if (elm[0].equals("s")) {
					sndr = true;
				} else
					if (elm[0].equals("r")) {
						rcvr = true;
					} else
						if (elm[0].equals("b")) {
							sndr = true;
							rcvr = true;
						}
				type = true;
				break;
			case 's' :
				spchar = s;
				break;
			case 'u' :
				unq = true;
				break;
			case 'v' :
				verbose = true;
				break;
			case 'w' :
				filespec = s;
				break;
			case 'x' :
				spectran = s;
				break;
			case 'y' :
				dirspec = s;
				break;
			default :
				tX.text(err, true, null);
				if (runmt)
					iMt.end();
				return ok;
		}
	}
	if (file.equals("")) {
		tX.text(err, true, null);
	} else {
		if (filespec.length() > 0 || spectran.length() > 0) {
			if (arc.length() > 0) {
				arc = iUtil.setPath(arc);
				arc = iUtil.mkdirs(arc);
			}
			if (path.length() > 0) {
				path = iUtil.setPath(path);
				path = iUtil.mkdirs(path);
				ok = true;
			}
		} else {
			File f = new File(file);
			if (dir) {
				if (iUtil.separatePath(file)) {
					ok = true;
					path = iUtil.filePath;
					file = iUtil.fileName;
				} else {
					tX.text("error: file path:" + file, true, null);
				}
			} else {
				try {
					String root = "ef";
					if (f.isFile()) {
						iUtil.separatePath(file);
						root = iUtil.fileName;
					} else
						if (file.indexOf("*") < 0) {
							tX.text("error: cannot find file:" + file, true, null);
						} else
							ok = true;
					if (path.charAt(path.length() - 1) != f.separatorChar) {
						String tf = path + f.separator;
						iUtil.separatePath(tf);
						f = new File(iUtil.filePath);
						if (f.isDirectory() && iUtil.filePath.equals(tf)) {
							path = tf + root;
						}
					}
					//if (iUtil.separatePath(path)) {
					iUtil.separatePath(path);
					f = new File(iUtil.filePath);
					if (f.isDirectory()) {
						ok = true;
					} else {
						tX.text("error: path is missing:" + path, true, null);
					}
				} catch (Exception e) {
					tX.text(e.toString(), true, null);
				}
			}
		}
	}
	if (bs.length() > 0) {
		base = iO.initBase(bs, pseq + ".seq", bsdir);
		if (bsdir.length() > 0)
			base = iO.initSeq(base[0], pseq + ".seq", bsdir);
		else {
			base = iO.initSeq(base[0], pseq + ".seq");
		}
	}
	if (split != null) {
		iUtil.separatePath(iUtil.setPath(split));
		split = iUtil.fileName;
		splitp = iUtil.filePath;
		if (splitp.length() > 0) {
			splitp = iUtil.tranDir(splitp, clist);
			splitp = iUtil.mkdirs(splitp);
		}
		if (splitp.length() == 0)
			split = null;
	}
	if (!ok) {
		if (runmt)
			iMt.end();
	}
	return ok;
}
/**
 * Insert the method's description here.
 * Creation date: (06-09-18 10:04:19 pm)
 */
public void writeDir() {
	String outfile = dirfile + "_tmp";
	String[] s = {file, outfile, null};
	String[] a = {"_idx","_vct"};
	int[] i = {500, 0, 0, -1};
	boolean[] b = {true, false, false};
	Vector vf = new Vector();
	iUtil.getFiles(path, s, a, i, b, vf);
	//Vector vf = iUtil.getFiles(path, file, null, 500, false, 0, true, 0, outfile, false);
	iUtil.renameFile(new File(outfile), dirfile);
}
}
