package efclient.bin;

import java.io.*;
/**
 * usage: -f{file} -d{dayes} -l{clear_dat_path} [-c{loop minutes}] 
 *        [-r{recursive}] [-s{subdirs}]
 *
 * sample: (this clears all files older than 90 days in \arc )
 * efclient.bin.Clear -d90 -f\arc\* -l\logs\c8
 * sample: (this recursively clears all files older than 90 days 
 *          and rotates files to weekly subdirs)
 * efclient.bin.Clear -d90 -r -sw -f\arc\* -l\logs\c9
 * -s (days), -sh (hours), -sw (weeks) 
 * sample: (this removes all files and files in subdirs of tmp2)
 * efclient.bin.Clear -f/tmp/tmp2/* -d0 -rf
 * sample: (this removes all files and subdirs of tmp2)
 * efclient.bin.Clear -f/tmp/tmp2/* -d0 -rd
 *
 * Insert the type's description here.
 * Creation date: (11/25/04 8:53:22 am)
 * @author: greg
 */
public class Clear {
	eforward.util.Mt iMt = null;
	boolean runmt = false;
	boolean verbose = false;
	boolean recursive = false;
	boolean subdirs = false;
	boolean hour = false;
	boolean week = false;
	boolean subarc = true;
	boolean log = false;
	boolean lshr = false;
	boolean rmdirs = false;
	boolean rmfiles = false;
	boolean sysout = false;
	int semc = 0;
	int thc = 400;
	int min = 15;
	String path = "";
	String file = "";
	String dfile = "clear.dat";
	String ldir = "";
	String stop = "";
	String pre = "c";
	String iodir = "";
	String ionm = "";
	String lshr_file = "";
	int fdays = 0;
	int rdays = 0;
	boolean cont = false;
	eforward.util.Util iUtil = new eforward.util.Util();
	eforward.util.Txt tX = new eforward.util.Txt();
	eforward.util.EdiMbg eMbg = new eforward.util.EdiMbg();
	eforward.util.Io iO = new eforward.util.Io();
/**
 * Clear constructor comment.
 */
public Clear() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (03/10/17 9:04:59 pm)
 * @param args java.lang.String[]
 * @param iMt eforward.util.Mt
 */
public Clear(String[] args, eforward.util.Mt iMt) {
	this.iMt = iMt;
	if (!setParms(args))
		return;
	run();
}
/**
 * Insert the method's description here.
 * Creation date: (11/25/04 9:00:52 am)
 * @param args java.lang.String[]
 */
public static void main(String[] args) {
	efclient.bin.Clear c = new efclient.bin.Clear();
	if (!c.setParms(args))
		return;
	c.run();
}
/**
 * Insert the method's description here.
 * Creation date: (11/25/04 9:01:05 am)
 */
public void run() {
	eforward.util.Sem iS = new eforward.util.Sem();
	eforward.util.IoCap iOc = null;
	eforward.util.IoCap iOe = null;
	if (sysout) {
		iOc = new eforward.util.IoCap();
		iOe = new eforward.util.IoCap();
		iOc.startOutByteArray(iodir, ionm, false, false, null, iMt);
		iOe.startOutByteArray(iodir, ionm + "e", true, false, null, iMt);
	}
	if (lshr) {
		iS.startSem(lshr_file, iMt, semc);
	}
	try {
		if (lshr) {
			Thread.sleep(100);
			int c = 0;
			while (iS.isSleep() && c < 20) {
				try {
					Thread.sleep(2000);
				} catch (Exception e) {
				}
				c++;
			}
		}
	} catch (Exception e) {
	}
	boolean sem = true;
	if (lshr) {
		sem = iS.isSem();
	}
	boolean loop = true;
	boolean stp = false;
	while (loop && sem) {
		try {
			loop = cont;
			if (rmfiles || rmdirs) {
				if (!verbose)
					iUtil.rmRecursive(path, file, rmdirs);
				if (verbose)
					iUtil.rmRecursive(path, file, rmdirs, tX);
			} else {
				String fmt = (week) ? "yyMM_W" : "yyMMdd";
				fmt = (hour) ? "yyMMddHH" : fmt;
				try {
					boolean clear = true;
					String dat = ldir + dfile;
					long tm = 0;
					try {
						if (log)
							if (new File(dat).isFile()) {
								java.util.Vector v = new java.util.Vector();
								iO.readInputFile(dat, v);
								if (v.size() > 0) {
									String time = (String) v.elementAt(0);
									if (time.length() > 0) {
										tm = new Long(time).longValue();
									}
								}
							}
					} catch (Exception ee) {
					}
					eforward.util.Rfile rfi = new eforward.util.Rfile();
					RandomAccessFile rf = null;
					try {
						if (log) {
							long tc = (new java.util.Date().getTime());
							String cur = eMbg.getDate(tc, fmt);
							String old = eMbg.getDate((tm * 1000L), fmt);
							if (!(cur.equals(old))) {
								rf = rfi.getRaf(dat, true);
								rf.writeBytes((new Long(tc / 1000L).toString()) + "\r\n");
							} else {
								clear = false;
							}
						}
					} catch (Exception ee) {
					}
					if (rf != null) {
						rfi.closeRfile(rf, dat);
					}
					if (stop.length() > 0 && (new File(stop).isFile()))
						stp = true;
					if (clear && !stp) {
						if (subdirs) {
							//String[] s = {filter, outfile, trans};
							//String[] a = extent; // exclude extension list
							//int[] i = {max, days, minLength, maxLength};
							//boolean[] b = {fileOnly, canWrite, dirOnly, countsOnly};							
							String df = ldir + "clear_" + dfile + "_" + Long.toString(System.currentTimeMillis()) + "_ebcx";
							String[] s = {file, df, null};
							String[] a = {"_ebcx"};
							int[] i = {-1, rdays, -1, -1};
							boolean[] b = {true, false, false, false};
							iUtil.getFiles(path, s, a, i, b, null);
							File f = new File(df);
							if (f.isFile()) {
								Thread.sleep(2000);
								eforward.util.IoFile iof = null;
								try {
									long[] of = iO.getOffL(df);
									iof = iO.openIoFile(df);
									String name = null;
									int cc = 0;
									while ((name = iO.readLineFile(iof, of)) != null) {
										if (name.length() > 0) {
											long wk = new File(path + name).lastModified();
											String day = eMbg.getDate(wk, fmt);
											String dir = iUtil.mkdirs(path + pre + day);
											iUtil.renameFile(new File(path + name), dir + name);
										}
										if (cc++ > 400) {
											cc = 0;
											Thread.sleep(50);
											if (stop.length() > 0 && (new File(stop).isFile())) {
												stp = true;
												break;
											}
										}
									}
								} catch (Exception ee) {
								}
								if (iof != null)
									iof.close();
								iUtil.rmFile(new File(df));
							}
						}
						if (!recursive && !stp) {
							String df = ldir + "clear_" + dfile + "_" + Long.toString(System.currentTimeMillis()) + "_ebcx";
							String[] s = {file, df, null};
							String[] a = {"_ebcx"};
							int[] i = {-1, fdays, -1, -1};
							boolean[] b = {true, false, false, false};
							iUtil.getFiles(path, s, a, i, b, null);
							File f = new File(df);
							if (f.isFile()) {
								eforward.util.IoFile iof = null;
								try {
									long[] of = iO.getOffL(df);
									iof = iO.openIoFile(df);
									String name = null;
									int cc = 0;
									while ((name = iO.readLineFile(iof, of)) != null) {
										if (name.length() > 0) {
											if (verbose) {
												long wk = new File(path + name).lastModified();
												String day = eMbg.getDate(wk, "MM/dd/yyyy HH:mm");
												tX.text("rm1 " + day + " " + path + name, true, null);
											}
											iUtil.rmFile(new File(path + name));
										}
										if (cc++ > 400) {
											cc = 0;
											Thread.sleep(50);
											if (stop.length() > 0 && (new File(stop).isFile())) {
												stp = true;
												break;
											}
										}
									}
								} catch (Exception ee) {
								}
								if (iof != null)
									iof.close();
								iUtil.rmFile(new File(df));
							}
						}
						if (recursive && !stp) {
							RandomAccessFile wf = null;
							String wfile = null;
							try {
								wfile = ldir + "clear_" + Long.toString(System.currentTimeMillis()) + "_lst_ebcx";
								wf = rfi.getRaf(wfile, true);
								String[] subdir = null;
								String[] exts = {"_ebcx", "_idx", "_vct", "_plst", "_rename"};
								String[] notdir = {"properties", "jbin", "java", "bin", "svc", "xmc", "Eforward"};
								iUtil.getFilesRecursive(path, true, false, wf, ldir, 0, subdir, fdays, exts, notdir);
								if (wf != null)
									rfi.closeRfile(wf, wfile);
								wf = null;
								long[] of = iO.getOffL(wfile);
								eforward.util.IoFile iof = iO.openIoFile(wfile);
								String name = null;
								int cc = 0;
								while ((name = iO.readLineFile(iof, of)) != null) {
									if (name.length() > 0) {
										if (verbose) {
											long wk = new File(path + name).lastModified();
											String day = eMbg.getDate(wk, "MM/dd/yyyy HH:mm");
											tX.text("rm2 " + day + " " + name, true, null);
										}
										iUtil.rmFile(new File(name));
										if (cc++ > 400) {
											cc = 0;
											Thread.sleep(50);
											if (stop.length() > 0 && (new File(stop).isFile())) {
												stp = true;
												break;
											}
										}
									}
								}
								if (iof != null)
									iof.close();
							} catch (Exception e) {
							}
							try {
								if (wf != null)
									rfi.closeRfile(wf, wfile);
							} catch (Exception e) {
							}
							if (wfile != null) {
								iUtil.rmFile(new File(wfile));
							}
						}
						if (subdirs && recursive && !stp) {
							RandomAccessFile wf = null;
							String wfile = null;
							try {
								wfile = ldir + "clear_" + Long.toString(System.currentTimeMillis()) + "_lst_ebcx";
								wf = rfi.getRaf(wfile, true);
								String[] subdir = null;
								String[] exts = {"_ebcx", "_idx", "_vct", "_plst", "_rename"};
								String[] notdir = {"properties", "jbin", "java", "bin", "svc", "xmc", "Eforward"};
								iUtil.getFilesRecursive(path, false, true, wf, ldir, 0, subdir, fdays, exts, notdir);
								if (wf != null)
									rfi.closeRfile(wf, wfile);
								wf = null;
								long[] of = iO.getOffL(wfile);
								eforward.util.IoFile iof = iO.openIoFile(wfile);
								String name = null;
								long ck = fdays * 86400000L;
								long fdate = System.currentTimeMillis();
								int cc = 0;
								String sc = File.separator;
								while ((name = iO.readLineFile(iof, of)) != null) {
									if (name.length() > 0) {
										long t = new File(name).lastModified();
										boolean empty = false;
										boolean dir = false;
										if (new File(name).isDirectory()) {
											String s = name.substring(path.length(), name.length());
											int i = s.indexOf(sc);
											if (i > 0)
												s = s.substring(0, i);
											String c = (s.length() > 0) ? s.substring(0, pre.length()) : "";
											if (c.equals(pre)) {
												String date = s.substring(pre.length(), s.length());
												long d = eMbg.getDateLong(date, fmt);
												long lday = 86400000L;
												long now = System.currentTimeMillis();
												if (d > 0) {
													if (d < (now - (fdays * lday))) {
														dir = true;
														long[] counts = new long[3];
														iUtil.getFilesCounts(name, "*", counts);
														if (counts[0] == 0 || counts[2] == 0) {
															empty = true;
														}
													}
												}
											}
										}
										if (fdate > t && t > 0 && fdate - t > ck || (dir && empty)) {
											if (subarc && (new File(name).isDirectory())) {
												if (empty) {
													if (verbose) {
														long wk = new File(name).lastModified();
														String day = eMbg.getDate(wk, "MM/dd/yyyy HH:mm");
														tX.text("rd1 " + day + " " + name, true, null);
													}
													new File(new File(name + "xxxxx").getParent()).delete();
												}
											} else {
												if (!dir) {
													if (verbose) {
														long wk = new File(name).lastModified();
														String day = eMbg.getDate(wk, "MM/dd/yyyy HH:mm");
														tX.text("rd2 " + day + " " + name, true, null);
													}
													new File(name).delete();
												}
											}
										}
										if (cc++ > 400) {
											cc = 0;
											Thread.sleep(50);
											if (stop.length() > 0 && (new File(stop).isFile())) {
												stp = true;
												break;
											}
										}
									}
								}
								if (iof != null)
									iof.close();
							} catch (Exception e) {
							}
							try {
								if (wf != null) {
									rfi.closeRfile(wf, wfile);
								}
							} catch (Exception e) {
							}
							if (wfile != null) {
								iUtil.rmFile(new File(wfile));
							}
						}
					}
				} catch (Exception e) {
					tX.text("clear:" + e.toString(), true, null);
				}
			}
			if (cont) {
				if (iUtil.checkStop(stop, min, false))
					System.exit(0);
			}
		} catch (Exception e) {
			try {
				if (loop)
					Thread.sleep(60000);
			} catch (Exception ee) {
			}
		}
	}
	if (lshr) {
		iS.stopSem();
	}
	if (sysout) {
		//iO.stopOut();
		iOc.stopOut();
		iOe.stopOut();
	}
	if (runmt)
		iMt.end();
}
/**
 * Creation date: (02/01/01 11:37:05 am)
 * @return boolean
 * @param args java.lang.String[]
 */
public boolean setParms(String[] args) {
	eforward.util.Parameters p = new eforward.util.Parameters(iUtil);
	java.util.Vector v = p.getParms(args);
	boolean ok = false;
	boolean ve = false;
	verbose = false;
	recursive = false;
	subdirs = false;
	hour = false;
	week = false;
	subarc = true;
	log = false;
	min = 15;
	path = "";
	file = "";
	dfile = "clear.dat";
	ldir = "";
	stop = "xxxx";
	fdays = 0;
	rdays = 0;
	pre = "c";
	String err = "usage: -f{file} -d{dayes} -l{clear_dat_path} [-c{loop minutes}] [-r{recursive}] [-s{subdirs}]";
	if (v == null) {
		tX.text(err, true, null);
		return ok;
	}
	for (int x = 0; x < v.size();) {
		char cp = ((Character) v.elementAt(x++)).charValue();
		String s = (String) v.elementAt(x++);
		switch (cp) {
			case 'L' :
				String[] elm = iUtil.stringToArray(s, ',', 2, true);
				elm[0] = iUtil.setPath(elm[0]);
				String fl = iUtil.setPath(elm[0]); // semaphore file
				iUtil.separatePath(fl);
				String lp = iUtil.filePath;
				String lf = iUtil.fileName;
				if (lp.length() > 0) {
					lshr_file = iUtil.mkdirs(lp) + lf;
					lshr = true;
				}
				semc = iUtil.getInt(elm[1]); // how many tries to gain control before exit
				// 0 = unlimited
				break;
			case 'T' :
				thc = iUtil.getInt(s);
				if (thc < 300) {
					thc = 300;
				}
				break;
			default :
				break;
		}
	}
	if (iMt == null) {
		iMt = new eforward.util.Mt();
		runmt = true;
	}
	for (int x = 0; x < v.size();) {
		char cp = ((Character) v.elementAt(x++)).charValue();
		String s = (String) v.elementAt(x++);
		switch (cp) {
			case 'c' :
				cont = true;
				try {
					min = new Integer(s).intValue();
				} catch (NumberFormatException e) {
					min = 15;
				}
				if (min < 5)
					min = 5;
				break;
			case 'd' :
				try {
					fdays = iUtil.getInt(s);
				} catch (NumberFormatException e) {
					tX.text("clear -d:" + e.toString(), true, null);
					fdays = 5;
				}
				if (fdays < 1)
					fdays = 1;
				break;
			case 'f' :
				file = iUtil.setPath(s);
				iUtil.separatePath(file);
				String lp = iUtil.filePath;
				String lf = iUtil.fileName;
				if (lp.length() > 0) {
					file = iUtil.mkdirs(lp) + lf;
				}
				break;
			case 'L' :
				break;
			case 'l' :
				ldir = iUtil.setPath(s);
				iUtil.separatePath(ldir);
				lp = iUtil.filePath;
				lf = iUtil.fileName;
				if (lp.length() > 0) {
					ldir = iUtil.mkdirs(lp) + lf;
					log = true;
				}
				break;
			case 'q' :
				stop = iUtil.setPath(s);
				java.io.File f = new java.io.File(stop);
				if (f.isFile()) {
					iUtil.rmFile(f);
				}
				break;
			case 'r' :
				recursive = true;
				if (s.length() > 0) {
					if (s.equals("f")) {
						rmfiles = true;
					} else
						if (s.equals("d")) {
							rmdirs = true;
						} else {
							try {
								rdays = iUtil.getInt(s);
							} catch (NumberFormatException e) {
								rdays = 1;
							}
						}
				}
				break;
			case 's' :
				subdirs = true;
				String[] elm = iUtil.stringToArray(s, ',', 3, true);
				if (elm[0].length() > 0 && (s.equals("w")))
					week = true;
				if (elm[0].length() > 0 && (s.equals("h")))
					hour = true;
				if (elm[1].length() > 0 && (s.equals("a")))
					subarc = false;
				if (elm[2].length() > 0) {
					pre = elm[2];
					if (elm[2].equals("all"))
						pre = "";
				}
				break;
			case 'T' :
				break;
			case 'u' :
				sysout = true;
				iodir = iUtil.setPath(s);
				iUtil.separatePath(iodir);
				String fp = iUtil.filePath;
				String fn = iUtil.fileName;
				iodir = iUtil.mkdirs(fp);
				if (fn.length() > 0)
					ionm = fn;
				break;
			case 'v' :
				int i = iUtil.getInt(s);
				if (i == 9)
					verbose = true;
				ve = true;
				break;
			default :
				tX.text(err, true, null);
				return ok;
		}
	}
	if (file.equals("") || fdays < 1) {
		tX.text(err, true, null);
	} else {
		try {
			iUtil.separatePath(file);
			file = iUtil.fileName;
			path = iUtil.filePath;
			File f = new File(path);
			if (f.isDirectory()) {
				if (ve)
					tX.text("Clear path :" + path + " file:" + file, true, null);
				ok = true;
			} else {
				tX.text("error: Clear path is missing:" + path, true, null);
			}
			if (log) {
				iUtil.separatePath(ldir);
				ldir = iUtil.filePath;
				if (iUtil.fileName.length() > 0)
					dfile = iUtil.fileName;
			}
		} catch (Exception e) {
			tX.text("Clear.setParms" + e.toString(), true, null);
		}
	}
	return ok;
}
}
