package efclient.bin;

import java.io.*;
import java.util.*;
import efclient.bin.nt.*;
/**
 * efclient.bin.Send.java, part of the eforward.client suite.
 *
 * Batch sending and receiving of Eforward clients using a
 * single Java VM. Call the main() method after
 * creating a send.properties file with the command switches.
 * Corvedia Inc. - 9/4/2001
 * @author: Greg Pringle
 */
public class Send implements efclient.bin.nt.SCMEventListener {
	//String properties ="/usr/local/Eforward/java/send.properties";
	eforward.util.Mt iMt = null;
	boolean runmt = false;
	boolean sysout = false;
	boolean runit = true;
	boolean debug = false;
	int semc = 0;
	int thc = 400;
	String iodir = "";
	String ionm = "send";
	String prop = "";
	String altprop = "send.properties";
	String stop = "";
	String[] cb = {"", "", ""};
	String alias_sub = "";
	String aliasd = "";
	boolean verbose = false;
	boolean lk = false;
	boolean lshr = false;
	String lshr_file = "";
	Vector cli = new Vector();
	eforward.util.Util iUtil = new eforward.util.Util();
	eforward.util.Txt tX = new eforward.util.Txt(true, 50);
	eforward.util.Properties pUtil = new eforward.util.Properties(iUtil);
	eforward.client.EdiSendListenNotify eNotify = null;
	eforward.util.Io iO = new eforward.util.Io();
	eforward.util.Plock iP = new eforward.util.Plock();
	long[] k6 = new long[2];
	public eforward.client.EdiSendMsg vMsg = null;
	efclient.bin.nt.Sv service = null;
/**
 * Default constructor.
 */
public Send() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (08/08/16 8:56:56 am)
 * @param args java.lang.String[]
 * @param iMt eforward.util.Mt
 */
public Send(String args[], eforward.util.Mt iMt) {
	this.iMt = iMt;
	if (!setup(args))
		return;
	run();
}
/**
 * Insert the method's description here.
 * Creation date: (10/23/16 8:12:56 am)
 * @param args java.lang.String[]
 * @param iMt eforward.util.Mt
 * @param vMsg eforward.client.EdiSendMsg
 */
public Send(String[] args, eforward.util.Mt iMt, eforward.client.EdiSendMsg vMsg) {
	this.iMt = iMt;
	this.vMsg = vMsg;
	if (!setup(args))
		return;
	run();
}
/**
 * Insert the method's description here.
 * Creation date: (12/22/16 12:08:33 pm)
 */
public void end() {}
/**
 * Creation date: (06/22/01 10:01:04 am)
 * @param event efclient.bin.nt.SCMEvent
 */
public void handleSCMEvent(SCMEvent event) {
	//if (event.getID() == SCMEvent.SERVICE_STOPPED) {
	if (event.getID() == SCMEvent.JS_SERVICE_STOPPED) {
		tX.text("Eforward Client service stopped", verbose, null);
		try {
			for (int x = 0; x < cli.size();) {
				//String c = ((String[]) cli.elementAt(x++))[0];
				x++;
				ISend t = (ISend) cli.elementAt(x++);
				t.stopClient();
				eforward.client.EdiSendMsg eMsg = t.eMsg;
				while (t.eMsg != null && t.eMsg.isTextAvailable()) {
					String s = t.eMsg.getMsgText();
				}
				t.clear();
			}
			Thread.sleep(1000);
			System.exit(0);
		} catch (Exception e) {
		}
	}
}
/**
 * efclient.bin.Send main() starts batch send and receives in a single VM
 * using send.properties.
 *
 * @param args java.lang.String[]
 */
public static void main(String args[]) {
	efclient.bin.Send s = new efclient.bin.Send();
	if (!s.setup(args))
		return;
	s.run();
}
/**
 * Creation date: (06/21/01 10:26:56 am)
 */
public void run() {
	boolean kill = false;
	eforward.util.Sem iS = new eforward.util.Sem();
	SCMEventManager scm = SCMEventManager.getInstance();
	scm.addSCMEventListener(this);
	eforward.util.IoCap iOc = null;
	eforward.util.IoCap iOe = null;
	if (sysout) {
		iOc = new eforward.util.IoCap();
		iOe = new eforward.util.IoCap();
		iOc.startOutByteArray(iodir, ionm, false, false, null, iMt);
		iOe.startOutByteArray(iodir, ionm + "e", true, false, null, iMt);
	}
	if (lshr) {
		iS.startSem(lshr_file, iMt, semc);
	}
	try {
		boolean active = (service != null) ? (service.getActive()) : runit;
		if (lshr && iS.isSleep()) {
			Thread.sleep(100);
			while (iS.isSleep() && active) {
				Thread.sleep(2000);
				active = (service != null) ? (service.getActive()) : runit;
			}
		}
		boolean sem = true;
		if (lshr) {
			sem = iS.isSem();
			if (!sem && semc > 0) {
				runit = false;
			}
		}
		if (active && runit && sem) {
			Vector v = new Vector();
			active = (service != null) ? (service.getActive()) : runit;
			while (active) {
				//newJar();
				setCmds(v);
				//System.out.println("Send A cli.size():" + cli.size());
				for (int x = 0; x < cli.size();) {
					String[] c2 = new eforward.util.Copy().arrayCopy((String[]) cli.elementAt(x));
					//System.out.println("Send check A c2:"+x+" " + iUtil.appnd(c2,"^"));
					String c = (new eforward.util.Copy().arrayCopy((String[]) cli.elementAt(x++)))[0];
					//System.out.println("Send check A c:"+x+" " + c);
					ISend t = (ISend) cli.elementAt(x++);
					boolean ag = true;
					for (int y = 0; y < v.size() && ag; y++) {
						String s = (new eforward.util.Copy().arrayCopy((String[]) v.elementAt(y)))[0];
						if (c.equals(s)) {
							//System.out.println("Send check A match");
							ag = false;
						}
					}
					if (ag) {
						//System.out.println("Send check A stop");
						t.stopClient();
						iUtil.pause(10);
						//
						eforward.client.EdiSendMsg eMsg = t.eMsg;
						while (t.eMsg != null && t.eMsg.isTextAvailable()) {
							tX.text(t.eMsg.getMsgText(), verbose, vMsg);
						}
						t.clear();
						//
						cli.removeElementAt(--x);
						cli.removeElementAt(--x);
					}
				}
				//System.out.println("Send B v.size():" + v.size());
				for (int x = 0; x < v.size();) {
					String[] c2 = new eforward.util.Copy().arrayCopy((String[]) v.elementAt(x));
					//System.out.println("Send check B c2:"+x+" " + iUtil.appnd(c2,"^"));
					String[] z = new eforward.util.Copy().arrayCopy((String[]) v.elementAt(x++));
					//System.out.println("Send check B z:"+x+" " + iUtil.appnd(z,"^"));
					String s = z[0];
					boolean ag = true;
					for (int y = 0; y < cli.size() && ag; y++) {
						c2 = new eforward.util.Copy().arrayCopy((String[]) cli.elementAt(y));
						String c = (new eforward.util.Copy().arrayCopy((String[]) cli.elementAt(y++)))[0];
						if (s.equals(c)) {
							//System.out.println("Send check B match");
							ag = false;
						}
					}
					if (ag) {
						//System.out.println("Send check B start z");
						ISend t = new ISend(z, this, iMt);
						String[] parmst = {""};
						int ct = iMt.add((Object) t, "run", "end", parmst);
						cli.addElement(new eforward.util.Copy().arrayCopy(z));
						cli.addElement(t);
						for (int i = 0; i < 30; i++) {
							iUtil.pause(1);
							if (eNotify != null)
								break;
						}
						iUtil.pause(1);
					}
				}
				active = (service != null) ? (service.getActive()) : runit;
				/*
				if (sysout) {
				iO.checkOut();
				}
				*/
				int ya = 0;
				//if (debug) {
				int[] mx = iMt.getMax();
				if ((mx[1] - mx[0]) < 20)
					tX.text("Mt max:" + Integer.toString(mx[0]) + " thc:" + Integer.toString(mx[1]), verbose, vMsg);
				//}
				for (int a = 0; a < 700 && active; a++) {
					//for (int a = 0; a < 5 && active; a++) {
					ya++;
					if (ya > 5)
						for (int c = 0; c < cli.size(); c++) {
							ya = 0;
							ISend t = (ISend) cli.elementAt(++c);
							eforward.client.EdiSendMsg eMsg = t.eMsg;
							while (t.eMsg.isTextAvailable()) {
								tX.text(t.eMsg.getMsgText(), verbose, vMsg);
							}
						}
					if (active && iUtil.checkStop(stop, 1, true)) {
						kill = true;
						active = false;
						runit = false;
					}
					if (active) {
						active = (service != null) ? (service.getActive()) : runit;
					}
					if (!active) {
						for (int x = 0; x < cli.size();) {
							x++;
							ISend t = (ISend) cli.elementAt(x++);
							t.stopClient();
							t.clear();
							cli.removeElementAt(--x);
							cli.removeElementAt(--x);
						}
					}
				}
				if (active) {
					//System.gc();
					iUtil.pause(20);
				}
			}
		}
	} catch (Exception e) {
		tX.text("Send.run " + e.toString(), verbose, vMsg);
	}
	if (lshr) {
		iS.stopSem();
	}
	if (sysout) {
		//iO.stopOut();
		iOc.stopOut();
		iOe.stopOut();
	}
	if (service != null) {
		service.setDone();
		service.setActive(false);
	}
	if (runmt)
		iMt.end();
	if (lk)
		iP.rmVlock(6, k6);
	if (kill) {
		System.exit(0);
	}
}
/**
 * Insert the method's description here.
 * Creation date: (12/22/16 12:08:09 pm)
 * @param dummy java.lang.String
 */
public void run(String dummy) {
	run();
}
/**
 * Insert the method's description here.
 * Creation date: (05/08/12 3:50:44 pm)
 * @param v java.util.Vector
 */
public void setCmds(Vector v) {
	if (!pUtil.openPropFile(prop, altprop)) {
		if (v.size() == 0) {
			tX.text("Failed to open Send properties file", verbose, null);
		}
		return;
	}
	v.setSize(0);
	try {
		Vector cmds = pUtil.setPairs();
		int port = iUtil.getInt(cb[1]);
		for (int x = 0; x < cmds.size();) {
			String[] arg = new eforward.util.Copy().arrayCopy((String[]) cmds.elementAt(x++));
			if (arg[0].equals("cmd")) {
				String[] cmd = new String[1];
				cmd[0] = arg[1];
				if (aliasd.length() > 0) {
					cmd[0] = arg[1] + " \"-A" + alias_sub + "," + aliasd + "\"";
				}
				if (cb[0].length() > 0) {
					eforward.util.Parameters p = new eforward.util.Parameters(iUtil);
					java.util.Vector pv = p.getParms(cmd);
					String c = "";
					String a = "";
					boolean t = false;
					String[] elm = null;
					String h = "";
					for (int z = 0; z < pv.size() && !t;) {
						char[] cp = new char[1];
						cp[0] = ((Character) pv.elementAt(z++)).charValue();
						String s = (String) pv.elementAt(z++);
						switch (cp[0]) {
							case 'h' :
								t = true;
								elm = iUtil.stringToArray(s, ',', 1, true);
								h = elm[0];
								break;
							default :
						}
					}
					if (h.equals(cb[0])) {
						t = false;
						for (int z = 0; z < pv.size();) {
							char[] cp = new char[1];
							cp[0] = ((Character) pv.elementAt(z++)).charValue();
							String s = (String) pv.elementAt(z++);
							switch (cp[0]) {
								case 't' :
									t = true;
									elm = iUtil.stringToArray(s, ',', 3, true);
									if (port > 0) {
										elm[1] = Integer.toString(port++);
									}
									elm[2] = cb[2];
									s = iUtil.appnd(elm, ",");
									break;
								default :
							}
							String qt = ((s.indexOf(" ")) > -1) ? "\"" : "";
							String y = (qt.length() > 0) ? " " : "";
							c = c + a + qt + "-" + new String(cp) + s + y + qt;
							a = " ";
						}
						if (!t) {
							String pt = (port > 0) ? Integer.toString(port++) : "";
							c = c + " -t," + pt + "," + cb[2];
						}
						cmd[0] = c;
					}
				}
				v.addElement(new eforward.util.Copy().arrayCopy((String[]) cmd));
			}
		}
		cmds.setSize(0);
	} catch (Exception e) {
	}
	pUtil.closePropFile();
}
/**
 * Creation date: (02/01/01 11:37:05 am)
 * @return boolean
 * @param args java.lang.String[]
 */
public boolean setParms(String[] args) {
	eforward.util.Parameters p = new eforward.util.Parameters(iUtil);
	java.util.Vector v = p.getParms(args);
	boolean ok = false;
	if (v == null) {
		return true;
	}
	alias_sub = "";
	aliasd = "";
	stop = "xxxx";
	for (int x = 0; x < v.size();) {
		char cp = ((Character) v.elementAt(x++)).charValue();
		String s = (String) v.elementAt(x++);
		switch (cp) {
			case 'A' :
				String[] elm = iUtil.stringToArray(s, ',', 2, true);
				alias_sub = elm[0];
				aliasd = elm[1];
				break;
			case 'L' :
				elm = iUtil.stringToArray(s, ',', 2, true);
				elm[0] = iUtil.setPath(elm[0]);
				String fl = iUtil.setPath(elm[0]);
				iUtil.separatePath(fl);
				String lp = iUtil.filePath;
				String lf = iUtil.fileName;
				if (lp.length() > 0) {
					lshr_file = iUtil.mkdirs(lp) + lf;
					lshr = true;
				}
				semc = iUtil.getInt(elm[1]);
				break;
			case 'T' :
				thc = iUtil.getInt(s);
				if (thc < 300) {
					thc = 300;
				}
				break;
			default :
				break;
		}
	}
	if (iMt == null) {
		iMt = new eforward.util.Mt(thc);
		runmt = true;
		if (debug)
			iMt.setDebug(true);
	}
	for (int x = 0; x < v.size();) {
		char cp = ((Character) v.elementAt(x++)).charValue();
		String s = (String) v.elementAt(x++);
		switch (cp) {
			case 'A' :
				break;
			case 'c' :
				// host to match in send cmd, local answer port, local host to bind to
				// -cefw.corvedia.net,46020,192.168.239.104
				cb = iUtil.stringToArray(s, ',', 3, true);
				break;
			case 'L' :
				break;
			case 'p' :
				prop = iUtil.setPath(s);
				iUtil.separatePath(prop);
				String lp = iUtil.filePath;
				String lf = iUtil.fileName;
				if (lp.length() > 0) {
					prop = iUtil.mkdirs(lp) + lf;
					if (lf.length() == 0)
						lf = "sndtmp.properties";
					prop = iUtil.mkdirs(lp) + lf;
					if (!(new java.io.File(prop).isFile())) {
						Vector text = new Vector();
						text.addElement("# place holder for actual snd properties file");
						iO.writeInputFile(prop, text);
					}
				}
				break;
			case 'q' :
				stop = iUtil.setPath(s);
				java.io.File f = new java.io.File(stop);
				if (f.isFile()) {
					iUtil.rmFile(f);
				}
				break;
			case 'T' :
				break;
			case 'w' :
				int i = iUtil.getInt(s);
				if (i > 0) {
					lk = true;
				}
				break;
			case 'u' :
				sysout = true;
				iodir = iUtil.setPath(s);
				iUtil.separatePath(iodir);
				iodir = iUtil.filePath;
				if (iUtil.fileName.length() > 0)
					ionm = iUtil.fileName;
				break;
			case 'v' :
				verbose = true;
				String[] elm = iUtil.stringToArray(s, ',', 1, true);
				if (elm[0].equals("d"))
					debug = true;
				break;
			case 'S' :
				service = new efclient.bin.nt.Sv();
				if (s.length() > 0)
					service.setPort(s);
				(new Thread((Runnable) service)).start();
				break;
			default :
				tX.text("usage: -v(verbose) [-q{stop file}] [-p{properties file}][-w{lock port}]", verbose, null);
				if (runmt)
					iMt.end();
				return ok;
		}
	}
	ok = true;
	if (ok && lk) {
		ok = iP.getVlock(6, k6);
		//iO.rmLock(lock);
	}
	return ok;
}
/**
 * Creation date: (08/22/01 4:39:44 am)
 * @return boolean
 * @param args java.lang.String[]
 */
public boolean setup(String[] args) {
	if (!setParms(args)) {
		tX.text("Failed to read Send command line", true, null);
		return false;
	}
	if (!pUtil.openPropFile(prop, altprop)) {
		tX.text("Failed first open of Send properties file", true, null);
		return false;
	}
	pUtil.closePropFile();
	return true;
}
/**
 * Insert the method's description here.
 * Creation date: (04/23/14 10:59:20 am)
 */
public void stoprun() {
	runit = false;
}
}
