package efclient.bin;

import java.io.*;
import java.util.*;
/**
 * Corvedia Inc. - 9/4/2001
 * @author: Greg Pringle
 */
public class SplitDests {
	eforward.util.Mt iMt = null;
	boolean runmt = false;
	boolean append = false;
	boolean debug = false;
	boolean remove = false;
	boolean partial = false;
	boolean sysout = false;
	boolean arc = false;
	boolean rmnl = false;
	boolean rmcrnl = false;
	boolean verbose = false;
	boolean group = false;
	boolean spth = false;
	boolean xcldg = false;
	boolean ebcout = false;
	boolean cont = false;
	boolean unblock = false;
	boolean seg = false;
	boolean x12 = false;
	boolean s7 = false;
	boolean lk = false;
	boolean orig = false;
	boolean list = false;
	boolean mail_notice = false;
	boolean buffered_write = false;
	int thc = 400;
	String pseq = "split";
	String[] base = null;
	String lock = "";
	int min = 0;
	int sec = 3;
	String stop = null;
	String ebcmap = null;
	String split = null;
	String splitp = null;
	String file = null;
	String path = null;
	String tran = null;
	String chid = null;
	String arcp = null;
	String subs = null;
	String edfsegt = null;
	String segt = null;
	String email = null;
	String emailhost = null;
	String notice_email = null;
	String notice_emailhost = null;
	String notice_trans = null;
	String version = null;
	String fext = null;
	String listdir = "";
	String listtmp = "";
	String iodir = "";
	String ionm = "";
	String mdir = "";
	int block = 132;
	String seq_dir = "";
	String seq_file = "";
	String seq_prop = "";
	//String[][] clist = new String[1][];
	String clst = "";
	String crlf = System.getProperties().getProperty("line.separator");
	eforward.util.Util iUtil = new eforward.util.Util();
	eforward.util.Txt tX = new eforward.util.Txt(true, 50);
	eforward.util.Io iO = new eforward.util.Io();
	eforward.util.Ebcdic eBcd = new eforward.util.Ebcdic(iUtil);
	eforward.util.EdiMbg eMbg = new eforward.util.EdiMbg(iUtil);
	eforward.util.Array iAr = new eforward.util.Array();
	eforward.util.Plock iP = new eforward.util.Plock();
	eforward.util.MailQue mQ = null;
	long[] k5 = new long[2];
	eforward.util.Log lG = null;
	String logfile = null;
/**
 * SplitDests constructor.
 */
public SplitDests() {
	super();
	//System.out.println("SplitDests A " + System.currentTimeMillis());
	//clist[0] = new String[0];
}
/**
 * Insert the method's description here.
 * Creation date: (12/22/16 12:00:10 pm)
 * @param args java.lang.String[]
 * @param iMt eforward.util.Mt
 */
public SplitDests(String[] args, eforward.util.Mt iMt) {
	this.iMt = iMt;
	//System.out.println("SplitDests B " + System.currentTimeMillis());
	//clist[0] = new String[0];
	if (!setParms(args))
		return;
	//System.out.println("SplitDests C " + System.currentTimeMillis());
	run();
}
/**
 * Insert the method's description here.
 * Creation date: (05/21/21 11:12:11 am)
 */
public void list() {
	lG.writeLog("start list");
	eforward.util.Util iUtil = new eforward.util.Util();
	eforward.util.Io iO = new eforward.util.Io();
	eforward.util.Rfile rfi = new eforward.util.Rfile();
	java.io.RandomAccessFile rf = null;
	String path = listdir;
	java.io.RandomAccessFile wf = null;
	String wfile = null;
	String ldir = listtmp;
	int fdays = -1;
	int err = 0;
	try {
		if (lG != null)
			lG.clear();
		err = 1;
		wfile = ldir + "flst_" + Long.toString(System.currentTimeMillis()) + "_lst_ebcx";
		wf = rfi.getRaf(wfile, true);
		String[] subdir = null;
		String[] exts = {"_ebcx", "_idx", "_vct", "_plst", "_rename"};
		String[] notdir = {"ebcx"};
		err = 2;
		iUtil.getFilesRecursive(path, false, false, wf, ldir, 0, subdir, fdays, exts, notdir);
		err = 3;
		if (wf != null)
			rfi.closeRfile(wf, wfile);
		wf = null;
		long[] of = iO.getOffL(wfile);
		eforward.util.IoFile iof = iO.openIoFile(wfile);
		err = 4;
		String name = null;
		int cc = 0;
		while ((name = iO.readLineFile(iof, of)) != null) {
			if (name.length() > 0) {
				if (lG != null) {
					lG.writeLog(name);
				} else {
					System.out.println(name);
				}
			}
		}
		if (iof != null)
			iof.close();
	} catch (Exception e) {
		System.out.println(e);
		lG.writeLog("err:" + e.toString());
	}
	try {
		if (wf != null)
			rfi.closeRfile(wf, wfile);
	} catch (Exception e) {
	}
	if (wfile != null)
		iUtil.rmFile(new java.io.File(wfile));
}
/**
 * Creation date: (02/01/01 11:35:20 am)
 * @param args java.lang.String[]
 */
public static void main(String[] args) {
	efclient.bin.SplitDests u = new efclient.bin.SplitDests();
	if (!u.setParms(args))
		return;
	u.run();
}
/**
 * Creation date: (06/13/01 1:39:16 pm)
 */
public void run() {
	if (iMt == null) {
		iMt = new eforward.util.Mt(thc);
		runmt = true;
	}
	eforward.util.IoCap iOc = null;
	eforward.util.IoCap iOe = null;
	if (sysout) {
		iOc = new eforward.util.IoCap();
		iOe = new eforward.util.IoCap();
		iOc.startOutByteArray(iodir, ionm, false, false, null, iMt);
		iOe.startOutByteArray(iodir, ionm + "e", true, false, null, iMt);
	}
	if (email.length() > 0 && emailhost.length() > 0 || mail_notice) {
		mQ = new eforward.util.MailQue(mdir, iMt);
	}
	if (logfile != null && (logfile.length() > 0)) {
		iUtil.separatePath(logfile);
		String log = iUtil.fileName;
		String logdir = iUtil.mkdirs(iUtil.setPath(iUtil.filePath));
		lG = new eforward.util.Log(logdir, log + "_", false, false, iMt);
		lG.setFmt("yyyyMMdd.HH:mm:ss");
	}
	if (list) {
		list();
	} else {
		split();
	}
	if (lG != null)
		lG.close();
	if (mQ != null)
		mQ.stopQue();
	if (sysout) {
		//iO.stopOut();
		iOc.stopOut();
		iOe.stopOut();
	}
	if (runmt)
		iMt.end();
}
/**
 * Insert the method's description here.
 * Creation date: (01/04/14 7:57:26 am)
 * @param file java.lang.String
 * @param comment java.lang.String
 * @param text java.lang.String[]
 * @param notice boolean
 */
public void sendMail(String file, String comment, String[] text, boolean notice) {
	try {
		if (notice) {
			mQ.sendMail(file, notice_email, notice_emailhost, comment, new eforward.util.Copy().arrayCopy(text), file, false);
		} else {
			if (email.length() > 0 && emailhost.length() > 0) {
				mQ.sendMail(file, email, emailhost, comment, new eforward.util.Copy().arrayCopy(text), file, false);
			}
		}
	} catch (Exception e) {
	}
}
/**
 * Insert the method's description here.
 * Creation date: (01/17/06 9:37:38 pm)
 * @return byte[]
 * @param en byte[]
 * @param partner byte[][]
 */
public byte[] set7(byte[] en, byte[][] partner) {
	ByteArrayOutputStream bo = new ByteArrayOutputStream();
	byte[] b = iAr.append(partner[5], partner[6], partner[8]);
	try {
		for (int x = 0; x < en.length; x++) {
			int c = en[x] & 0xFF;
			if (c > 127 || c < 32) {
				for (int y = 0; y < b.length; y++)
					if (b[y] == en[x]) {
						bo.write(en, x, 1);
					}
			} else {
				bo.write(en, x, 1);
			}
		}
		en = bo.toByteArray();
	} catch (Exception e) {
	}
	try {
		bo.close();
	} catch (Exception e) {
	}
	return new eforward.util.Copy().arrayCopy(en);
}
/**
 * Creation date: (02/01/01 11:37:05 am)
 * @return boolean
 * @param args java.lang.String[]
 */
public boolean setParms(String[] args) {
	eforward.util.Parameters p = new eforward.util.Parameters(iUtil);
	java.util.Vector v = p.getParms(args);
	boolean ok = false;
	String bs = "";
	String bsdir = "properties";
	String grp = "";
	append = false;
	remove = false;
	partial = false;
	arc = false;
	rmnl = false;
	rmcrnl = false;
	verbose = false;
	group = false;
	spth = false;
	xcldg = false;
	ebcout = false;
	cont = false;
	unblock = false;
	seg = false;
	x12 = false;
	s7 = false;
	version = null;
	min = 0;
	sec = 3;
	stop = "xxxx";
	ebcmap = "";
	file = "";
	path = "";
	tran = "";
	chid = "";
	arcp = "";
	subs = "";
	edfsegt = "";
	segt = "";
	email = "";
	emailhost = "";
	fext = "";
	block = 132;
	String err = "usage: -f{file} -k{destination path[,trans_file]} [-j{archive path}] [-r(remove orginal)] [-i[delay]]\n";
	err = err + "[-b(remove CR/NL pairs)] [-s{segterm}] [-d{edifact segterm}] [-n(remove new line)]\n";
	err = err + "[-e(ebcdic to asci)] [-u(unblock)[size]] [-c(continuous)] [-a(append)] [-l{logfile}]-v\n";
	err = err + "Sample trans_file:\n";
	err = err + "tr1=sender_dir-def,default,\\Eforward\\recv2\\,,,,,,*MMddyyHHmmss*_*.edi***D*C*S*T*F# SplitDests";
	err = err + "[-p{chgid_trans_file} (or partial)] [-m{email host,to}]";
	if (v == null) {
		tX.text(err, true, null);
		return ok;
	}
	if (iMt == null) {
		iMt = new eforward.util.Mt(thc);
		runmt = true;
	}
	String alias_sub = "";
	String aliasd = "";
	String[][] clist = new String[1][];
	clist[0] = new String[0];
	for (int x = 0; x < v.size();) {
		char cp = ((Character) v.elementAt(x++)).charValue();
		String s = (String) v.elementAt(x++);
		switch (cp) {
			case 'A' :
				String[] elm = iUtil.stringToArray(s, ',', 2, true);
				alias_sub = elm[0];
				aliasd = elm[1];
				if (aliasd.length() > 0 && new File(aliasd).isFile()) {
					int tc = iMt.setTrans(aliasd);
					clst = iMt.getTransLstC(tc, "alias", alias_sub);
					clist[0] = new eforward.util.Copy().arrayCopy(iUtil.setClistc(clst));
					iMt.closeTrans(tc);
				}
				x = v.size();
				break;
			default :
		}
	}
	for (int x = 0; x < v.size();) {
		char cp = ((Character) v.elementAt(x++)).charValue();
		String s = (String) v.elementAt(x++);
		switch (cp) {
			case 'A' :
				break;
			case 'a' :
				append = true;
				break;
			case 'B' :
				buffered_write = true;
				break;
			case 'b' :
				rmcrnl = true;
				String[] elm = iUtil.stringToArray(s, ',', 3, true);
				if (elm[0].length() > 0) {
					rmcrnl = false;
					bs = iUtil.mkdirs(iUtil.setPath(elm[0]));
					if (elm[1].length() > 0) {
						bsdir = elm[1];
						bsdir = iUtil.setPath(bsdir);
						iUtil.mkdirs(bs + bsdir);
					} else {
						iUtil.mkdirs(bs + "properties");
					}
				}
				if (elm[2].length() > 0) {
					rmcrnl = false;
					pseq = elm[2];
					//lck = false;
				}
				break;
			case 'c' :
				cont = true;
				try {
					min = new Integer(s).intValue();
				} catch (NumberFormatException e) {
					min = 5;
				}
				if (min < 1)
					min = 1;
				break;
			case 'd' :
				if (s.length() > 0) {
					edfsegt = s;
					seg = true;
				}
				break;
			case 'e' :
				ebcout = true;
				ebcmap = s;
				break;
			case 'f' :
				elm = iUtil.stringToArray(s, ',', 2, true);
				file = elm[0];
				if (elm[1].length() > 0) {
					split = elm[1];
				}
				file = iUtil.setPath(file);
				iUtil.separatePath(file);
				String lp = iUtil.filePath;
				String lf = iUtil.fileName;
				if (lp.length() > 0) {
					lp = iUtil.tranDir(lp, clist);
					file = iUtil.mkdirs(lp) + lf;
				}
				break;
			case 'g' :
				elm = iUtil.stringToArray(s, ',', 2, true);
				if (elm[0].equals("x")) {
					xcldg = true;
					grp = iUtil.setPath(elm[1]);
					iUtil.separatePath(grp);
					lp = iUtil.filePath;
					lf = iUtil.fileName;
					if (lp.length() > 0) {
						lp = iUtil.tranDir(lp, clist);
						grp = iUtil.mkdirs(lp) + lf;
					}
				} else {
					grp = iUtil.setPath(elm[0]);
					iUtil.separatePath(grp);
					lp = iUtil.filePath;
					lf = iUtil.fileName;
					if (lp.length() > 0) {
						lp = iUtil.tranDir(lp, clist);
						grp = iUtil.mkdirs(lp) + lf;
					}
				}
				group = true;
				break;
			case 'h' :
				// directory listing instead of split
				elm = iUtil.stringToArray(s, ',', 2, true);
				if (elm[0].length() > 0) {
					String d = iUtil.setPath(elm[0]);
					iUtil.separatePath(d);
					d = iUtil.filePath;
					if (d.length() > 0) {
						listdir = d;
						list = true;
						if (elm[1].length() > 0) {
							d = iUtil.setPath(elm[1]);
							iUtil.separatePath(d);
							d = iUtil.filePath;
							if (d.length() > 0) {
								listtmp = d;
							}
						}
					}
				}
				break;
			case 'i' :
				sec = iUtil.getInt(s);
				break;
			case 'j' :
				arc = true;
				//arcp = iUtil.setPath(s);
				arcp = iUtil.tranDir(s, clist);
				arcp = iUtil.setPath(arcp);
				arcp = iUtil.mkdirs(arcp);
				break;
			case 'k' :
				elm = iUtil.stringToArray(s, ',', 3, true);
				path = elm[0];
				if (elm[1].length() > 0) {
					tran = elm[1];
					File f = new File(tran);
					if (f.isFile()) {
						spth = true;
					}
				}
				if (elm[2].length() > 0) {
					fext = elm[2];
				}
				path = iUtil.setPath(path);
				path = iUtil.setPath(path);
				path = iUtil.mkdirs(path);
				break;
			case 'l' :
				logfile = iUtil.setPath(s);
				break;
			case 'm' :
				elm = iUtil.stringToArray(s, ',', 2, true);
				if (elm[0].equals("n")) {
					mail_notice = true;
					notice_trans = elm[1];
				} else {
					if (elm[0].length() > 0) {
						emailhost = elm[0];
					}
					if (elm[1].length() > 0) {
						email = elm[1];
					}
				}
				break;
			case 'n' :
				rmnl = true;
				break;
			case 'o' :
				orig = true;
				break;
			case 'p' :
				chid = s;
				seg = true;
				if (s.length() == 0)
					partial = true;
				break;
			case 'q' :
				stop = iUtil.setPath(s);
				java.io.File f = new java.io.File(stop);
				if (f.isFile()) {
					iUtil.rmFile(f);
				}
				break;
			case 'r' :
				remove = true;
				break;
			case 's' :
				elm = iUtil.stringToArray(s, 'd', 2, true);
				seg = true;
				segt = elm[0];
				if (elm[1].length() > 0) {
					subs = elm[1];
				}
				break;
			case 't' :
				s7 = true;
				break;
			case 'T' :
				thc = iUtil.getInt(s);
				if (thc < 300) {
					thc = 300;
				}
				break;
			case 'u' :
				unblock = true;
				try {
					if (s.length() > 0)
						block = new Integer(s).intValue();
				} catch (Exception e) {
				}
				break;
			case 'U' :
				sysout = true;
				iodir = iUtil.setPath(s);
				iUtil.separatePath(iodir);
				String fp = iUtil.filePath;
				String fn = iUtil.fileName;
				iodir = iUtil.mkdirs(fp);
				if (fn.length() > 0)
					ionm = fn;
				break;
			case 'v' :
				verbose = true;
				elm = iUtil.stringToArray(s, ',', 1, true);
				if (elm[0].equals("d"))
					debug = true;
				break;
			case 'w' :
				int i = iUtil.getInt(s);
				if (i > 0) {
					lock = Integer.toString(i);
					lk = true;
				}
				break;
			case 'x' :
				x12 = true;
				break;
			case 'y' :
				if (segt.length() == 0) {
					seg = true;
					segt = "126";
				}
				version = s;
				break;
			default :
				tX.text(err, true, null);
				if (runmt)
					iMt.end();
				return ok;
		}
	}
	if (file.equals("")) {
		tX.text(err, true, null);
	} else {
		File f = new File(file);
		try {
			if (f.isFile()) {
			} else
				if (file.indexOf("*") < 0) {
					tX.text("error: cannot find file:" + file, true, null);
				} else
					ok = true;
			if (path.charAt(path.length() - 1) != f.separatorChar)
				path = path + f.separator;
			iUtil.separatePath(path);
			f = new File(iUtil.filePath);
			if (f.isDirectory()) {
				path = iUtil.filePath;
				ok = true;
			} else {
				tX.text("error: path is missing:" + path, true, null);
			}
		} catch (Exception e) {
			tX.text(e.toString(), true, null);
		}
	}
	if (bs.length() > 0) {
		mdir = bs;
		seq_dir = bs;
		seq_file = pseq + ".seq";
		seq_prop = bsdir;
		base = iO.initBase(bs, pseq + ".seq", bsdir);
		if (bsdir.length() > 0) {
			seq_dir = bs;
			base = iO.initSeq(base[0], pseq + ".seq", bsdir);
		} else {
			seq_dir = bs;
			base = iO.initSeq(base[0], pseq + ".seq");
		}
	}
	if (mdir.length() == 0)
		mdir = iodir;
	if (mdir.length() == 0)
		mdir = iO.pwd();
	mdir = iUtil.mkdirs(iUtil.setPath(mdir + "msplt"));
	if (arc) {
		try {
			File f = new File("a");
			if (arcp.charAt(arcp.length() - 1) != f.separatorChar)
				arcp = arcp + f.separator;
			iUtil.separatePath(arcp);
			f = new File(iUtil.filePath);
			if (f.isDirectory()) {
				arcp = iUtil.filePath;
			} else {
				ok = false;
				tX.text("error: archive path not found:" + arcp, true, null);
			}
		} catch (Exception e) {
			tX.text(e.toString(), true, null);
		}
	}
	if (split != null) {
		iUtil.separatePath(iUtil.setPath(split));
		split = iUtil.fileName;
		splitp = iUtil.filePath;
		if (splitp.length() > 0) {
			splitp = iUtil.tranDir(splitp, clist);
			splitp = iUtil.mkdirs(splitp);
		}
		if (splitp.length() == 0)
			split = null;
	}
	if (group && !spth) {
		File f = new File(grp);
		if (f.isFile()) {
			tran = grp;
		} else {
			tX.text("error: (-g) group file not found:" + grp, true, null);
			group = false;
		}
	}
	if (ok && lk) {
		ok = iP.getVlock(5, k5);
		if (!ok)
			tX.text("FAILED: efclient.bin.Cmd is stopped due to port:" + lock + " already in use", true, null);
		//iO.rmLock(lock);
	}
	if (!ok) {
		if (runmt)
			iMt.end();
	}
	return ok;
}
/**
 * Insert the method's description here.
 * Creation date: (05/21/21 11:23:32 am)
 */
public void split() {
	//System.out.println("SplitDests begin");
	int err = 0;
	boolean loop = true;
	Vector ptnr = new Vector();
	Vector ppth = new Vector();
	Hashtable ptnrHash = new Hashtable();
	iUtil.separatePath(file);
	String fname = iUtil.fileName;
	String fpath = iUtil.filePath;
	err = 1;
	if (base == null && (split != null)) {
		iUtil.mkdirs(splitp + "properties");
		base = iO.initSeq(splitp, split, "properties");
		seq_dir = base[0];
		seq_file = split;
		seq_prop = "properties";
	}
	if (base == null) {
		String ldir = iUtil.mkparent(file);
		iUtil.mkdirs(ldir + "properties");
		base = iO.initSeq(ldir, pseq + ".seq", "properties");
		seq_dir = base[0];
		seq_file = split;
		seq_prop = "properties";
	}
	eMbg.initSeq(seq_dir, "split_" + seq_file, seq_prop);
	while (loop) {
		loop = cont;
		eforward.util.Rfile rfi = new eforward.util.Rfile();
		RandomAccessFile rf = null;
		try {
			err = 1;
			String[] exts = new String[] {"_ebcx", "_err", "_blck", "_temp", "_partnernotsetup", "_idx", "_vct", "_detail"};
			if (spth) {
				Vector vf = iUtil.getFiles(fpath, fname, exts, 0, true);
				boolean frdy = false;
				for (int it = 0; it < vf.size(); it++) {
					String ofl = (String) vf.elementAt(it);
					String fnm = fpath + ofl;
					if (!frdy && iUtil.isFileReady(fnm))
						frdy = true;
					if (frdy && iUtil.isFileReady(fnm, sec)) {
						if (arc) {
							iUtil.copyFile(fnm, arcp + ofl);
						}
						byte[] top = eMbg.readTop(fnm);
						err = 2;
						eforward.util.FileTypes iFt = new eforward.util.FileTypes(fnm, fnm);
						int ityp = iFt.getTypeNumber();
						if (ityp > 9 && (ityp < 20)) { // Binary
							String txt = "SplitDest isBinary " + fnm + " tran:" + tran;
							if (lG != null) {
								lG.writeLog(txt);
							} else {
								tX.text(txt, true, null);
							}
							String[] cd = eMbg.getMatch(fnm, fnm, tran, "mvbin_type", "sender_dir_xml", "", iMt);
							err = 3;
							if (cd != null && (cd.length > 0) && (cd[0].length() > 0)) {
								err = 4;
								String[][] clist = new String[1][];
								clist[0] = new eforward.util.Copy().arrayCopy(iUtil.setClistc(clst));
								String ppa = iUtil.tranDir(cd[0], clist);
								ppa = iUtil.mkdirs(ppa);
								txt = "binary file: " + ppa + ofl;
								if (lG != null) {
									lG.writeLog(txt);
								} else {
									tX.text(txt, true, null);
								}
								iUtil.moveFile(fnm, ppa + ofl);
							} else {
								if (lG != null) {
									lG.writeLog("binary dir not found: " + tran);
									lG.writeLog("file type not set: " + fnm);
								} else {
									tX.text("binary dir not found: " + tran, true, null);
									tX.text("file type not set: " + fnm, true, null);
								}
								if (arc) {
									iUtil.renameFile(new File(fnm), fnm + "_binary_err");
								}
							}
						}
					}
				}
			}
			err = 5;
			if (sec == 0)
				iO.clearEmpty(fpath, fname, exts);
			//Vector vf = new Vector();
			err = 6;
			//eMbg.sortCtrl(fpath, fname, exts, vf);

			eforward.util.FileVect fv = new eforward.util.FileVect();
			fv.open(fpath + "z" + Long.toString(System.currentTimeMillis()), 1);
			eMbg.sortCtrl(fpath, fname, exts, 2200, fv);
			err = 7;
			String txt = "SplitDests Number of files: " + new Integer(fv.size(1)).toString();
			if (lG != null) {
				lG.writeLog(txt);
			} else {
				tX.text(txt, verbose, null);
			}
			java.util.Vector list = null;
			java.util.Hashtable hash = null;
			if (group) {
				err = 8;
				int tc = iMt.setTrans(tran);
				list = new java.util.Vector();
				hash = new java.util.Hashtable();
				String[][] clist = new String[1][];
				//clist[0] = new String[0];
				//iMt.getTransLst(tc, "group", clist);
				String clstg = iMt.getTransLstC(tc, "group");
				clist[0] = new eforward.util.Copy().arrayCopy(iUtil.setClistc(clstg));
				iMt.closeTrans(tc);
				for (int y = 0; y < clist[0].length; y++) {
					String[][] csv = new String[1][];
					iUtil.getCsv(clist[0][y], csv);
					hash.put(csv[0][1], new Integer(y));
					list.addElement(new eforward.util.Copy().arrayCopy(csv[0]));
				}
			}
			err = 9;
			boolean frdy = false;
			for (int it = 0; it < fv.size(0); it++) {
				String ofl = (String) fv.readString(it, 0);
				String fnm = fpath + ofl;
				if (!frdy && iUtil.isFileReady(fnm))
					frdy = true;
				if (frdy && iUtil.isFileReady(fnm, sec)) {
					if (arc) {
						iUtil.copyFile(fnm, arcp + ofl);
					}
					if (lG != null) {
						lG.writeLog(fnm);
					} else {
						tX.text(fnm, verbose, null);
					}
					String efile = fnm;
					boolean ebcdic = ebcout;
					boolean bin = false;
					if (!ebcdic) {
						byte[] top = eMbg.readTop(fnm);
						eforward.util.FileTypes iFt = new eforward.util.FileTypes(fnm, fnm);
						int ityp = iFt.getTypeNumber();
						if (ityp > 9 && (ityp < 20)) { // Binary
							bin = true;
							txt = "SplitDest isBinary !ebcdic moved to " + fnm + "_binary_err";
							if (lG != null) {
								lG.writeLog(txt);
							} else {
								tX.text(txt, true, null);
							}
							iUtil.renameFile(new File(fnm), fnm + "_binary_err");
						}
					}
					if (!bin) {
						if (ebcdic)
							ebcdic = (eBcd.isEbcdic(fnm)) ? true : false;
						if (ebcdic) {
							efile = fnm + "_ebcx";
							eBcd.toAsci(fnm, efile, ebcmap);
						}
						err = 10;
						if (unblock) {
							unBlock(efile, efile + "_blck", block);
							if (new File(efile + "_blck").length() > 0) {
								if (new File(efile).isFile()) {
									iUtil.rmFile(new File(efile));
									iUtil.pause(1);
								}
								iUtil.renameFile(new File(efile + "_blck"), efile);
							}
						}
						err = 11;
						if (rmcrnl || rmnl) {
							byte[][] partner = eMbg.getMsgPartner(eMbg.readTop(efile), false, true);
							//System.out.println("part 1:"+iUtil.appnd(iAr.getStrings(partner),"^"));							
							if (partner[6].length > 0) {
								if (rmnl && partner[6][0] != 10 && partner[6][0] != 13)
									eMbg.stripCrNl(efile, rmnl);
								if (!rmnl && partner[6][0] != 13)
									eMbg.stripCrNl(efile, rmnl);
							} else {
								eMbg.stripCrNl(efile, rmnl);
							}
						}
						err = 12;
						Vector nv = new Vector();
						nv.addElement(efile);
						if (seg) {
							err = 13;
							if (segt.length() == 0) {
								err = 131;
								byte[] top = eMbg.readTop(efile);
								err = 132;
								eforward.util.FileTypes iFt = new eforward.util.FileTypes();
								if (iFt.isX12(top))
									segt = eMbg.getSegTerm(top);
								err = 133;
							}
							err = 140;
							if (edfsegt.length() == 0) {
								byte[] top = eMbg.readTop(efile);
								eforward.util.FileTypes iFt = new eforward.util.FileTypes();
								if (iFt.isEdifact(top))
									edfsegt = eMbg.getEdfSegTerm(top);
							}
							err = 150;
							byte[] rs = eMbg.setSegTerm(segt);
							byte[] edfrs = eMbg.setSegTerm(edfsegt);
							byte[] sb = eMbg.setSegTerm(subs);
							String tfil = efile + "_temp";
							err = 160;
							String[] stringa = {efile, tfil, chid, version, null};
							byte[][] byteaa = {rs, edfrs, sb};
							err = 170;
							eMbg.setFileSt(stringa, byteaa, x12, nv);
							if (new File(tfil).length() > 0) {
								if (new File(efile).isFile()) {
									iUtil.rmFile(new File(efile));
								}
								iUtil.renameFile(new File(tfil), efile);
							} else {
								iUtil.rmFile(new File(tfil));
							}
						}
						err = 14;
						for (int vvx = 0; vvx < nv.size(); vvx++) {
							err = 15;
							String vvf = (String) nv.elementAt(vvx);
							Vector[] vx = eMbg.getEdiFiles(vvf);
							int vc = vx[1].size() / 2;
							int q = 0;
							String ext = iO.getSeq(1, 7);
							boolean ok = true;
							if ((vx[3].size() > 0 && !partial) || vx[1].size() == 0) {
								ok = false;
								String nf = fnm + "_err";
								String[] text = new String[vx[3].size() + 2];
								text[0] = "SplitDest error processing file " + fnm;
								for (int z = 0; z < vx[3].size(); z++) {
									text[z + 1] = (String) vx[3].elementAt(z);
								}
								text[text.length - 1] = "file has been copied to " + nf;
								//System.out.println("ERRRRRR:"+iUtil.appnd(text,"|"));
								sendMail(vvf, "Seim SplitDest error", new eforward.util.Copy().arrayCopy(text), false);
								iUtil.copyFile(fnm, nf);
							}
							err = 16;
							for (int w = 0; w < vc && ok;) {
								err = 17;
								byte[] dat = new eforward.util.Copy().arrayCopy(eMbg.getEdiFiles(vvf, vx, ++w));
								Vector[] v = null;
								byte[] nrs = new byte[0];
								if (s7) {
									v = eMbg.getFilesRecSt(dat);
									if (v.length > 0)
										nrs = new eforward.util.Copy().arrayCopy((byte[]) v[0].elementAt(1));
								}
								v = eMbg.getEdiRecs(dat, false, false);
								int c = v[1].size() / 2;
								int y = 0, sy = 0;
								err = 18;
								if (c > 0) {
									for (int x = 0; x < c; x++) {
										err = 19;
										sy = y;
										int tl = 0;
										Vector gl = new Vector();
										if (group) {
											err = 20;
											int a = ((Integer) v[1].elementAt(y++)).intValue();
											int b = ((Integer) v[1].elementAt(y++)).intValue() + 1;
											byte[] en = new eforward.util.Copy().arrayCopy((byte[]) v[2].elementAt(a++));
											ByteArrayOutputStream bs = new ByteArrayOutputStream();
											int h = (a + 1 < b) ? a + 2 : a;
											for (int g = a - 1; g < h; g++) {
												byte[] f = new eforward.util.Copy().arrayCopy((byte[]) v[2].elementAt(g));
												bs.write(f, 0, f.length);
											}
											err = 21;
											byte[][] partner = new eforward.util.Copy().arrayCopy(eMbg.getMsgPartner(bs.toByteArray(), false, false));
											//System.out.println("part 2:"+iUtil.appnd(iAr.getStrings(partner),"^"));							
											bs.close();
											Integer i = (Integer) hash.get(new String(partner[3]));
											if (i != null) {
												int z = i.intValue();
												err = 22;
												String[] st = new eforward.util.Copy().arrayCopy((String[]) list.elementAt(z));
												for (int k = 3; k < st.length; k += 2) {
													err = 23;
													if (st[k].length() > 0) {
														byte[][] id = new byte[4][];
														id[0] = new byte[0];
														id[1] = new byte[0];
														id[2] = ((st[k - 1].length() > 0) ? st[k - 1] : "").getBytes();
														id[3] = ((st[k].length() > 0) ? st[k] : "").getBytes();
														byte[][] top = new byte[2][];
														boolean ag = false;
														if (ag);
														tl = a - 1;
														while (!ag && tl < 3) {
															top[0] = new eforward.util.Copy().arrayCopy((byte[]) v[2].elementAt(tl));
															ag = eMbg.setPartner(top, id);
															if (ag) {
																gl.addElement(new eforward.util.Copy().arrayCopy(top[1]));
															} else
																tl++;
														}
													}
												}
											}
										}
										err = 24;
										int z = -1;
										boolean ag = true;
										while (z < gl.size()) {
											err = 25;
											y = sy;
											if (z > -1) {
												v[2].setElementAt(new eforward.util.Copy().arrayCopy((byte[]) gl.elementAt(z)), tl);
											}
											z++;
											boolean more = true;
											if (z == 0 && xcldg && gl.size() > 0)
												more = false;
											if (more) {
												err = 26;
												int a = ((Integer) v[1].elementAt(y++)).intValue();
												int b = ((Integer) v[1].elementAt(y++)).intValue() + 1;
												byte[] en = new eforward.util.Copy().arrayCopy((byte[]) v[2].elementAt(a++));
												ByteArrayOutputStream bs = new ByteArrayOutputStream();
												int h = (a + 1 < b) ? a + 2 : a;
												for (int g = a - 1; g < h; g++) {
													byte[] f = new eforward.util.Copy().arrayCopy((byte[]) v[2].elementAt(g));
													bs.write(f, 0, f.length);
												}
												err = 27;
												byte[][] partner = new eforward.util.Copy().arrayCopy(eMbg.getMsgPartner(bs.toByteArray(), false, false));
												//System.out.println("part 3:"+iUtil.appnd(iAr.getStrings(partner),"^"));							
												bs.close();
												// moved from below
												String ttname = fnm + "_tmp";
												if (new File(ttname).isFile()) {
													iUtil.rmFile(new File(ttname));
													iUtil.pause(1);
												}
												File f = new File(ttname);
												rf = rfi.getRaf(ttname, true);
												err = 28;
												try {
													rf.write(en, 0, en.length);
													for (; a < b;) {
														en = new eforward.util.Copy().arrayCopy((byte[]) v[2].elementAt(a++));
														if (s7) {
															partner[6] = nrs;
															en = set7(en, partner);
														}
														rf.write(en, 0, en.length);
													}
												} catch (Exception ee) {
													txt = "SplitDests ee:" + ee.toString();
													if (lG != null) {
														lG.writeLog(txt);
													} else {
														tX.text(txt, true, null);
													}
												}
												rfi.closeRfile(rf, ttname);
												//
												String[] ppl = {path};
												err = 29;
												String specname = "";
												if (mail_notice) {
													eforward.util.Trans mt = new eforward.util.Trans(notice_trans);
													String sn = new String(partner[1]);
													String rn = new String(partner[3]);
													String[] mc = mt.getTrans("mail_notice", sn, rn);
													if (mc != null && mc.length > 0 && mc[2].length() > 0) {
														notice_email = mc[2];
														notice_emailhost = mc[3];
														String types = mc[4];
														boolean ms = true;
														if (mc[4].length() > 0) {
															ms = false;
															String t = "*" + mc[4] + "*";
															eforward.util.FileTypes iFt = new eforward.util.FileTypes();
															int typ = iFt.getType(fnm, fnm);
															String t2 = "*" + Integer.toString(typ) + "*";
															int ii = t.indexOf(t2);
															if (ii > -1) {
																ms = true;
															}
														}
														if (ms) {
															String[] text = new String[3];
															text[0] = "From:    " + new String(partner[1]);
															text[1] = "To:      " + new String(partner[3]);
															text[2] = "Control: " + new String(partner[4]);
															sendMail(fnm, "Seim file " + new String(partner[4]), text, true);
														}
													}
													mt.close();
												}
												if (spth) {
													String[] cd = eMbg.getMatch(ttname, fnm, tran, "sender_dir", "sender_dir_xml", "", iMt);
													if (cd != null && (cd.length > 0) && (cd[0].length() > 0)) {
														specname = cd[7];
														//ppa = iUtil.tranDir(cd[0], clist);
														ppl = iUtil.stringToArray(cd[0], '|', 1, false);
													}
												}
												err = 30;
												String oname = null;
												if (append) {
													err = 31;
													int fc = ptnrHash.size();
													String pph = ppl[0] + new String(partner[3]);
													Integer i = (Integer) ptnrHash.get(pph);
													if (i == null) {
														ptnrHash.put(pph, new Integer(fc));
														ptnr.addElement(iUtil.stripChar(new String(partner[3]), ' ') + "_" + ext + "_" + iUtil.padInt(++q, 3));
														ppth.addElement(ppl[0]);
													}
													fc = ((Integer) ptnrHash.get(pph)).intValue();
													oname = (String) ptnr.elementAt(fc);
												} else {
													oname = iUtil.stripChar(new String(partner[3]), ' ') + "_" + ext + "_" + iUtil.padInt(++q, 3);
												}
												err = 32;
												String tname = fpath + oname;
												iUtil.appendFile(ttname, tname);
												long fsz = new File(tname).length();
												for (int ppx = 0; ppx < ppl.length; ppx++) {
													String ppa = ppl[ppx];
													//iUtil.mkdirs(ppa);
													if (lG != null) {
														lG.writeLog(ppa + oname);
													} else {
														tX.text(ppa + oname, verbose, null);
													}
													if (!append) {
														err = 33;
														long len = new File(tname).length();
														String tmpf = tname + "_temp";
														if (buffered_write && len < 1048576L) {
															tmpf = tname;
														} else {
															iUtil.copyFile(tname, tmpf);
														}
														if (orig && !(new File(ppa + ofl).isFile())) {
															// use original filename
															if (buffered_write && len < 1048576L) {
																iO.writeFileBuffered(new File(tmpf), ppa + ofl);
															} else {
																iUtil.moveFile(tmpf, ppa + ofl);
															}
														} else {
															if (specname.length() > 0) {
																oname = specname;
																if (buffered_write && len < 1048576L) {
																	iO.writeFileBuffered(new File(tmpf), ppa + oname);
																} else {
																	iUtil.moveFile(tmpf, ppa + oname);
																}
															} else {
																if (buffered_write && len < 1048576L) {
																	iO.writeFileBuffered(new File(tmpf), ppa + oname + ext);
																} else {
																	iUtil.moveFile(tmpf, ppa + oname + ext);
																}
															}
														}
													}
												}
												iUtil.rmFile(new File(tname));
												if (lG != null)
													lG.writeLog(ofl + ":" + oname + ":" + fsz);
											}
										}
									}
									err = 34;
								} else {
									err = 35;
									String nf = fnm + "_msg" + w + "_err";
									String[] text = new String[4];
									text[0] = "SplitDest failed on file " + fnm;
									text[1] = "failed on message " + w;
									text[2] = "";
									if (w > 1)
										text[2] = "messages before " + w + " were sent";
									text[3] = "file has been renamed " + nf;
									sendMail(nf, "Seim SplitDest failed", new eforward.util.Copy().arrayCopy(text), false);
									iUtil.renameFile(new File(fnm), nf);
								}
								if (sec > 0)
									Thread.sleep(10);
							}
							err = 36;
							if (vvx > 0) {
								if (remove)
									iUtil.rmFile(new File(vvf));
							}
						}
						err = 37;
						if (ebcdic)
							iUtil.rmFile(new File(efile));
						if (remove)
							iUtil.rmFile(new File(fnm));
						try {
							Thread.sleep(10);
						} catch (Exception ee) {
						}
					}
				}
			}
			fv.clear();
			err = 38;
			int[] mx = iMt.getMax();
			if ((mx[1] - mx[0]) < 20) {
				txt = "Mt max:" + Integer.toString(mx[0]) + " thc:" + Integer.toString(mx[1]);
				if (lG != null) {
					lG.writeLog(txt);
				} else {
					tX.text(txt, true, null);
				}
			}
			err = 39;
			if (cont) {
				if (append) {
					err = 40;
					for (int fc = 0; fc < ptnr.size(); fc++) {
						err = 41;
						String oname = (String) ptnr.elementAt(fc);
						String ppa = (String) ppth.elementAt(fc);
						String tname = fpath + oname;
						iUtil.moveFile(tname, ppa + oname);
						ptnr = new Vector();
						ppth = new Vector();
						ptnrHash = new Hashtable();
					}
				}
				err = 42;
				for (int z = 0; z < (min * 5); z++) {
					err = 43;
					if (iUtil.checkStop(stop, 12, true)) {
						if (lk)
							iP.rmVlock(5, k5);
						System.exit(0);
					}
					//vf.setSize(0);
					//vf.trimToSize();
					//iUtil.getFiles(fpath, fname, exts, 0, true, vf);
					fv.open(fpath + "z" + Long.toString(System.currentTimeMillis()), 1);
					eMbg.sortCtrl(fpath, fname, exts, 2200, fv);
					//if (vf.size() > 0)
					if (fv.size(0) > 0) {
						z = min * 6;
					} else {
						fv.clear();
					}
				}
			}
		} catch (Exception ee) {
			String txt = "writeDests:" + Integer.toString(err) + ":" + ee.toString();
			if (lG != null) {
				lG.writeLog(txt);
			} else {
				tX.text(txt, true, null);
			}
			try {
				if (loop)
					Thread.sleep(1000);
			} catch (Exception e) {
			}
		}
	}
	if (lk)
		iP.rmVlock(5, k5);
	if (append) {
		for (int fc = 0; fc < ptnr.size(); fc++) {
			String oname = (String) ptnr.elementAt(fc);
			String ppa = (String) ppth.elementAt(fc);
			String tname = fpath + oname;
			iUtil.moveFile(tname, ppa + oname);
		}
	}
}
/**
 * Insert the method's description here.
 * Creation date: (03/22/02 12:15:31 pm)
 * @param file java.lang.String
 * @param tfile java.lang.String
 * @param block int
 */
public void unBlock(String file, String tfile, int block) {
	int len = 0;
	DataInputStream src = null;
	DataOutputStream dst = null;
	try {
		len = (int) (new File(file).length());
		byte[] odata = new byte[block];
		byte[] dat = new byte[block];
		byte[] rs = new byte[1];
		rs[0] = 10;
		FileInputStream fs = new FileInputStream(file);
		src = new DataInputStream(new BufferedInputStream(fs));
		FileOutputStream fo = new FileOutputStream(tfile);
		dst = new DataOutputStream(new BufferedOutputStream(fo));
		int k = 0, i;
		while (k < len) {
			int s = len - k;
			if (s > block)
				s = block;
			src.readFully(odata, 0, s);
			String ln = new String(odata, 0, s).trim();
			dat = ln.getBytes();
			i = dat.length;
			dst.write(new eforward.util.Copy().arrayCopy(dat), 0, i);
			dst.write(new eforward.util.Copy().arrayCopy(rs), 0, 1);
			k += s;
		}
		src.close();
		dst.flush();
		dst.close();
	} catch (Exception e) {
		try {
			src.close();
		} catch (Exception ed) {
		}
		try {
			dst.close();
		} catch (Exception ed) {
		}
	}
	return;
}
/**
 * Insert the method's description here.
 * Creation date: (12/22/16 12:03:49 pm)
 */
public void writeDests() {
	run();
}
}
