package efclient.receiver.req;

import java.io.*;
/**
 * Filresp.java
 * Filresp sends a response to the sender by first
 * checking for a properties file '"filresp." + eMsg.getDestination()'
 * and then sending back a message using the switches in the
 * properties file. The -d(destination) in the properties file is
 * optional. If not present the ID of the sender will be used to
 * return the file listed int the properties file. (-rj,filresp)
 * example file:
 * -hwww.corvedia.net
 * -p
 * -fc:\reply\to\sender\response_file.txt
 * -ld:\Eforward\log\log_file
 * -olocal_ID
 * -wpassword
 * -ddestination_ID
 *
 * Corvedia Inc. - 9/4/2001
 * @author: Greg Pringle
 */
public class Filresp {
	eforward.util.Txt tX = new eforward.util.Txt();
/**
 * @param st java.lang.String[]
 * @param eMsg eforward.client.EdiSendEMsg
 */
public Filresp(String[] st, eforward.client.EdiSendEMsg eMsg) {
	String properties = "filresp." + eMsg.getDestination();
	eforward.util.Util iUtil = new eforward.util.Util();
	boolean dest = false;
	java.util.Vector argv = new java.util.Vector();
	try {
		File prop = new File(properties);
		if (prop.isFile());
		else
			return;
		BufferedReader src = new BufferedReader(new FileReader(properties));
		String line;
		String[] pair;
		while (!((line = src.readLine()) == null)) {
			pair = iUtil.stringToArray(line, '#', 1, true);
			if (!pair[0].trim().equals("")) {
				String var = pair[0].trim();
				if (!var.equals("")) {
					String[] arg = new String[1];
					arg[0] = var;
					if (var.substring(0, 1).equals("-")) {
						argv.addElement(new eforward.util.Copy().arrayCopy(arg));
						if (var.substring(0, 2).equals("-d"))
							dest = true;
					}
				}
			}
		}
	} catch (Exception e) {
		tX.text("Filresp e:" + e.toString(), true, null);
	}
	if (argv.size() > 0) {
		String[] a = new String[1];
		a[0] = "-a";
		argv.addElement(new eforward.util.Copy().arrayCopy(a));
		if (!dest) {
			String[] arg = new String[1];
			arg[0] = "-d" + eMsg.getDestination();
			argv.addElement(new eforward.util.Copy().arrayCopy(arg));
		}
		String[] cmd = new String[argv.size()];
		for (int c = 0; c < argv.size(); c++) {
			String[] ca = new eforward.util.Copy().arrayCopy((String[]) argv.elementAt(c));
			cmd[c] = ca[0];
		}
		eforward.client.EdiSend ed = new eforward.client.EdiSend(true, eMsg.getMt());
		ed.runEdiSend(cmd);
	}
	return;
}
}
