package efclient.receiver.req;

import java.io.*;
import java.util.*;
/**
 * Regroup.java
 * Corvedia Inc. - 4/7/2002
 * @author: Greg Pringle
 */
public class Regroup {
	eforward.util.Util iUtil = new eforward.util.Util();
	eforward.util.Txt tX = new eforward.util.Txt();
	eforward.util.Io iO = new eforward.util.Io();
	eforward.util.EdiMbg eMbg = new eforward.util.EdiMbg(iUtil);
	eforward.util.Properties pUtil = new eforward.util.Properties(iUtil);
	boolean uniq = false;
	boolean seg = false;
	boolean x12 = false;
	String comment = "regroup.properties";
	String unique = "true";
	String isa_control = "0";
	String gs_control = "0";
	String logfile = "";
	String edfsegt = "";
	String segt = "";
	String mv_path = "";
	String arc_path = "";
	String x12only = "";
/**
 * @param st java.lang.String[]
 * @param eMsg eforward.client.EdiSendEMsg
 */
public Regroup(String[] st, eforward.client.EdiSendEMsg eMsg) {
	try {
		st[0] = iUtil.setPath(st[0]);
		String filename = st[0];
		iUtil.separatePath(filename);
		String sname = iUtil.fileName;
		String spath = iUtil.filePath;
		boolean pk = iO.isPack(filename);
		Vector vf = new Vector();
		String pre = "";
		if (!pk) {
			String f = eMsg.getInboundFilename();
			iUtil.separatePath(f);
			String s = iUtil.fileName;
			vf.addElement(s);
			iUtil.renameFile(new File(filename), spath + s);
		} else {
			pre = eMsg.getQname();
			vf = iO.getPack(spath, sname, spath + pre, eMsg.getOriginalFilename(), eMsg.getLog());
		}
		for (int fx = 0; fx < vf.size(); fx++) {
			String fnm = (String) vf.elementAt(fx);
			String sfile = spath + pre + fnm;
			sfile = iUtil.setPath(sfile);
			//String filename = eMsg.getInboundFilename();
			//iUtil.renameFile(new File(st[0]), filename);
			String properties = "";
			if (st.length > 1 && st[1].charAt(0) != '-') {
				st[1] = iUtil.setPath(st[1]);
				properties = iUtil.mkpath(st[1]);
			}
			File f = new File(properties);
			if (!f.isFile())
				properties = "regroup.properties";
			if (!setCrtl(properties))
				return;
			if (!getCtrl(properties))
				return;
			if (seg) {
				byte[] rs = eMbg.setSegTerm(segt);
				byte[] edfrs = eMbg.setSegTerm(edfsegt);
				String tfil = sfile + "_temp";
				eMbg.setFileSt(sfile, tfil, rs, x12, edfrs);
				if (new File(tfil).length() > 0) {
					iUtil.rmFile(new File(sfile));
					iUtil.renameFile(new File(tfil), sfile);
				} else {
					iUtil.rmFile(new File(tfil));
				}
			}
			Vector[] fn = new Vector[3];
			fn[0] = new Vector();
			fn[1] = new Vector();
			fn[2] = new Vector();
			fn[0].addElement(sfile);
			int[] ctrl = new int[2];
			ctrl[0] = new Integer(isa_control).intValue();
			ctrl[1] = new Integer(gs_control).intValue();
			eMbg.setGroups(fn, ctrl);
			isa_control = new Integer(ctrl[0]).toString();
			gs_control = new Integer(ctrl[1]).toString();
			writeCtrl(properties);
			int x = 0;
			if (fn[0].size() > 0)
				x = 1;
			iUtil.separatePath(sfile);
			String file = iUtil.fileName;
			String path = iUtil.filePath;
			for (; x < fn[0].size(); x++) {
				String fnam = (String) fn[0].elementAt(x);
				String newpath = path;
				if (mv_path.length() > 0) {
					newpath = mv_path;
				}
				String unq = "";
				if (uniq)
					unq = eMsg.getQname() + "_";
				if (fn[2].size() > x) {
					String typ = (String) fn[2].elementAt(x);
					if (typ.length() > 0)
						unq = "st" + typ + "_" + unq;
				}
				mvf(fnam, newpath, unq);
			}
			if (fn[0].size() > 1 && arc_path.length() > 0) {
				iUtil.renameFile(new File(sfile), arc_path + file);
			} else
				if (fn[0].size() > 1 && arc_path.length() == 0) {
					iUtil.rmFile(new File(sfile));
				} else
					if (fn[0].size() == 1 && mv_path.length() > 0) {
						iUtil.renameFile(new File(sfile), mv_path + file);
					}
			if (logfile.length() > 0 && fn[1].size() > 0) {
				eforward.util.Rfile ru = new eforward.util.Rfile();
				RandomAccessFile rf = ru.openRfile(logfile);
				for (x = 0; x < fn[1].size(); x++) {
					ru.writeRfile(rf, (String) fn[1].elementAt(x));
				}
				ru.closeRfile(rf);
			}
		}
		if (pk)
			iUtil.rmFile(new File(filename));
	} catch (Exception e) {
		tX.text("Regroup" + e.toString(), true, null);
	}
}
/**
 * @return boolean
 * @param control java.lang.String
 */
public boolean getCtrl(String control) {
	boolean ok = false;
	//eforward.util.Copy new eforward.util.Copy() = new eforward.util.Copy();
	try {
		if (!pUtil.openPropFile(control, "")) {
			return ok;
		}
		Vector v = pUtil.setPairs();
		for (int x = 0; x < v.size();) {
			String[] arg = new eforward.util.Copy().arrayCopy((String[]) v.elementAt(x++));
			String s = iUtil.textToLower(arg[0]);
			if (s.equals("comment"))
				comment = arg[1];
			else
				if (s.equals("unique"))
					unique = arg[1];
				else
					if (s.equals("isa_control"))
						isa_control = arg[1];
					else
						if (s.equals("gs_control"))
							gs_control = arg[1];
						else
							if (s.equals("logfile"))
								logfile = iUtil.mkpath(iUtil.setPath(arg[1]));
							else
								if (s.equals("segterm"))
									segt = arg[1];
								else
									if (s.equals("edifact_segterm"))
										edfsegt = arg[1];
									else
										if (s.equals("mv_path"))
											mv_path = iUtil.mkdirs(iUtil.setPath(arg[1]));
										else
											if (s.equals("arc_path"))
												arc_path = iUtil.mkdirs(iUtil.setPath(arg[1]));
											else
												if (s.equals("x12"))
													x12only = arg[1];
		}
		pUtil.closePropFile();
		if (unique.equals("true"))
			uniq = true;
		if (segt.length() > 0 || edfsegt.length() > 0)
			seg = true;
		if (x12only.equals("true"))
			x12 = true;
		ok = true;
	} catch (Exception e) {
	}
	return ok;
}
/**
 * Insert the method's description here.
 * Creation date: (04/11/02 9:27:35 am)
 * @param filename java.lang.String
 * @param newpath java.lang.String
 * @param unique java.lang.String
 */
public void mvf(String filename, String newpath, String unique) {
	iUtil.separatePath(iUtil.mkpath(filename));
	String name = iUtil.fileName;
	String path = iUtil.filePath;
	iUtil.separatePath(iUtil.mkpath(newpath));
	String newname = iUtil.filePath;
	if (!newname.equals(path) || unique.length() > 0) {
		newname = newname + unique + name;
		iUtil.renameFile(new File(filename), newname);
	}
	return;
}
/**
 * @return boolean
 * @param control java.lang.String
 */
public boolean setCrtl(String control) {
	String err = "error: cannot create file:" + control;
	try {
		control = iUtil.setPath(control);
		File f = new File(control);
		if (!f.isFile()) {
			writeCtrl(control);
		}
	} catch (Exception e) {
		tX.text(err, true, null);
		return false;
	}
	try {
		File f = new File(control);
		if (f.isFile() && f.canWrite())
			return true;
	} catch (SecurityException e) {
		tX.text(err, true, null);
		return false;
	}
	return true;
}
/**
 * @return boolean
 * @param file java.lang.String
 */
public boolean writeCtrl(String file) {
	boolean ok = false;
	String[] s = new String[10];
	s[0] = "comment=" + comment;
	s[1] = "unique=" + unique;
	s[2] = "isa_control=" + isa_control;
	s[3] = "gs_control=" + gs_control;
	s[4] = "logfile=" + logfile;
	s[5] = "segterm=" + segt;
	s[6] = "edifact_segterm=" + edfsegt;
	s[7] = "mv_path=" + mv_path;
	s[8] = "arc_path=" + arc_path;
	s[9] = "x12=" + x12only;
	BufferedWriter src = null;
	try {
		src = new BufferedWriter(new FileWriter(file));
		for (int x = 0; x < s.length; x++) {
			src.write(s[x]);
			src.newLine();
		}
		src.flush();
		src.close();
		ok = true;
	} catch (Exception e) {
		try {
			src.close();
		} catch (Exception ed) {
		}
	}
	return ok;
}
}
